/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress.zstd;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictCompress;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.compress.CanReinit;
import org.apache.hadoop.hbase.io.compress.CompressionUtil;
import org.apache.hadoop.hbase.io.compress.zstd.ZstdCodec;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ZstdCompressor
implements CanReinit,
Compressor {
    protected static final Logger LOG = LoggerFactory.getLogger(ZstdCompressor.class);
    protected int level;
    protected int bufferSize;
    protected ByteBuffer inBuf;
    protected ByteBuffer outBuf;
    protected boolean finish;
    protected boolean finished;
    protected long bytesRead;
    protected long bytesWritten;
    protected int dictId;
    protected ZstdDictCompress dict;

    ZstdCompressor(int level, int bufferSize, byte[] dictionary) {
        this.level = level;
        this.bufferSize = bufferSize;
        this.inBuf = ByteBuffer.allocateDirect(bufferSize);
        this.outBuf = ByteBuffer.allocateDirect(bufferSize);
        this.outBuf.position(bufferSize);
        if (dictionary != null) {
            this.dictId = ZstdCodec.getDictionaryId(dictionary);
            this.dict = new ZstdDictCompress(dictionary, level);
        }
    }

    ZstdCompressor(int level, int bufferSize) {
        this(level, bufferSize, null);
    }

    public int compress(byte[] b, int off, int len) throws IOException {
        if (this.outBuf.hasRemaining()) {
            int remaining = this.outBuf.remaining();
            int n = Math.min(remaining, len);
            this.outBuf.get(b, off, n);
            LOG.trace("compress: {} bytes from outBuf", (Object)n);
            return n;
        }
        if (this.finish) {
            if (this.inBuf.position() > 0) {
                this.inBuf.flip();
                int uncompressed = this.inBuf.remaining();
                int needed = ZstdCompressor.maxCompressedLength(uncompressed);
                if (this.outBuf.capacity() < needed) {
                    needed = CompressionUtil.roundInt2((int)needed);
                    LOG.trace("compress: resize outBuf {}", (Object)needed);
                    this.outBuf = ByteBuffer.allocateDirect(needed);
                } else {
                    this.outBuf.clear();
                }
                int written = this.dict != null ? Zstd.compress((ByteBuffer)this.outBuf, (ByteBuffer)this.inBuf, (ZstdDictCompress)this.dict) : Zstd.compress((ByteBuffer)this.outBuf, (ByteBuffer)this.inBuf, (int)this.level);
                this.bytesWritten += (long)written;
                this.inBuf.clear();
                LOG.trace("compress: compressed {} -> {} (level {})", new Object[]{uncompressed, written, this.level});
                this.finished = true;
                this.outBuf.flip();
                int n = Math.min(written, len);
                this.outBuf.get(b, off, n);
                LOG.trace("compress: {} bytes", (Object)n);
                return n;
            }
            this.finished = true;
        }
        LOG.trace("No output");
        return 0;
    }

    public void end() {
        LOG.trace("end");
    }

    public void finish() {
        LOG.trace("finish");
        this.finish = true;
    }

    public boolean finished() {
        boolean b = this.finished && !this.outBuf.hasRemaining();
        LOG.trace("finished: {}", (Object)b);
        return b;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public boolean needsInput() {
        boolean b = !this.finished();
        LOG.trace("needsInput: {}", (Object)b);
        return b;
    }

    public void reinit(Configuration conf) {
        LOG.trace("reinit");
        if (conf != null) {
            byte[] b;
            boolean levelChanged = false;
            int newLevel = ZstdCodec.getLevel(conf);
            if (this.level != newLevel) {
                LOG.trace("Level changed, was {} now {}", (Object)this.level, (Object)newLevel);
                this.level = newLevel;
                levelChanged = true;
            }
            if ((b = ZstdCodec.getDictionary(conf)) != null) {
                int thisDictId = ZstdCodec.getDictionaryId(b);
                if (this.dict == null || this.dictId != thisDictId || levelChanged) {
                    this.dictId = thisDictId;
                    this.dict = new ZstdDictCompress(b, this.level);
                    LOG.trace("Reloaded dictionary, new id is {}", (Object)this.dictId);
                }
            } else {
                this.dict = null;
            }
            int newBufferSize = ZstdCodec.getBufferSize(conf);
            if (this.bufferSize != newBufferSize) {
                this.bufferSize = newBufferSize;
                this.inBuf = ByteBuffer.allocateDirect(this.bufferSize);
                this.outBuf = ByteBuffer.allocateDirect(this.bufferSize);
                LOG.trace("Resized buffers, new size is {}", (Object)this.bufferSize);
            }
        }
        this.reset();
    }

    public void reset() {
        LOG.trace("reset");
        this.inBuf.clear();
        this.outBuf.clear();
        this.outBuf.position(this.outBuf.capacity());
        this.bytesRead = 0L;
        this.bytesWritten = 0L;
        this.finish = false;
        this.finished = false;
    }

    public void setDictionary(byte[] b, int off, int len) {
        throw new UnsupportedOperationException("setDictionary is not supported");
    }

    public void setInput(byte[] b, int off, int len) {
        LOG.trace("setInput: off={} len={}", (Object)off, (Object)len);
        if (this.inBuf.remaining() < len) {
            int needed = CompressionUtil.roundInt2((int)(this.inBuf.capacity() + len));
            LOG.trace("setInput: resize inBuf {}", (Object)needed);
            ByteBuffer newBuf = ByteBuffer.allocateDirect(needed);
            this.inBuf.flip();
            newBuf.put(this.inBuf);
            this.inBuf = newBuf;
        }
        this.inBuf.put(b, off, len);
        this.bytesRead += (long)len;
        this.finished = false;
    }

    static int maxCompressedLength(int len) {
        return (int)Zstd.compressBound((long)len);
    }
}

