/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress.zstd;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.compress.DictionaryCache;
import org.apache.hadoop.hbase.io.compress.zstd.ZstdCodec;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, LargeTests.class})
public class TestZstdDictionarySplitMerge {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestZstdDictionarySplitMerge.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Configuration conf;

    @BeforeClass
    public static void setUp() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.io.compress.zstd.codec", ZstdCodec.class.getCanonicalName());
        Compression.Algorithm.ZSTD.reload(conf);
        conf.setInt("hbase.client.meta.operation.timeout", 1000);
        conf.setInt("hbase.client.retries.number", 2);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws Exception {
        final TableName tableName = TableName.valueOf((String)"TestZstdDictionarySplitMerge");
        byte[] cfName = Bytes.toBytes((String)"info");
        String dictionaryPath = "resource://zstd.test.dict";
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])cfName).setCompressionType(Compression.Algorithm.ZSTD).setConfiguration("hbase.io.compress.zstd.dictionary", "resource://zstd.test.dict").build()).build();
        Admin admin = TEST_UTIL.getAdmin();
        admin.createTable(td, (byte[][])new byte[][]{Bytes.toBytes((int)1)});
        TEST_UTIL.waitTableAvailable(tableName);
        Table t = ConnectionFactory.createConnection((Configuration)conf).getTable(tableName);
        TEST_UTIL.loadNumericRows(t, cfName, 0, 100000);
        admin.flush(tableName);
        Assert.assertTrue((String)"Dictionary was not loaded", (boolean)DictionaryCache.contains((String)"resource://zstd.test.dict"));
        TEST_UTIL.verifyNumericRows(t, cfName, 0, 100000, 0);
        admin.split(tableName, Bytes.toBytes((int)50000));
        TEST_UTIL.waitFor(30000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TEST_UTIL.getMiniHBaseCluster().getRegions(tableName).size() == 3;
            }

            public String explainFailure() throws Exception {
                return "Split has not finished yet";
            }
        });
        TEST_UTIL.waitUntilNoRegionsInTransition();
        TEST_UTIL.verifyNumericRows(t, cfName, 0, 100000, 0);
        RegionInfo regionA = null;
        RegionInfo regionB = null;
        for (RegionInfo region : admin.getRegions(tableName)) {
            if (region.getStartKey().length == 0) {
                regionA = region;
                continue;
            }
            if (!Bytes.equals((byte[])region.getStartKey(), (byte[])Bytes.toBytes((int)1))) continue;
            regionB = region;
        }
        Assert.assertNotNull(regionA);
        Assert.assertNotNull(regionB);
        admin.mergeRegionsAsync((byte[][])new byte[][]{regionA.getRegionName(), regionB.getRegionName()}, false).get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)2L, (long)admin.getRegions(tableName).size());
        ServerName expected = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0).getServerName();
        Assert.assertEquals((Object)expected, (Object)TEST_UTIL.getConnection().getRegionLocator(tableName).getRegionLocation(Bytes.toBytes((int)1), true).getServerName());
        try (AsyncConnection asyncConn = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)conf).get();){
            Assert.assertEquals((Object)expected, (Object)((HRegionLocation)asyncConn.getRegionLocator(tableName).getRegionLocation(Bytes.toBytes((int)1), true).get()).getServerName());
        }
        TEST_UTIL.verifyNumericRows(t, cfName, 0, 100000, 0);
    }
}

