/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress.zstd;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.io.compress.CompressionTestBase;
import org.apache.hadoop.hbase.io.compress.DictionaryCache;
import org.apache.hadoop.hbase.io.compress.zstd.ZstdCodec;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.RandomDistribution;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestZstdDictionary
extends CompressionTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestZstdDictionary.class);
    private static final String DICTIONARY_PATH = "resource://zstd.test.dict";
    private static final int EXPECTED_COMPRESSED_SIZE = 359909;
    private static byte[] TEST_DATA;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = new Configuration();
        TEST_DATA = DictionaryCache.loadFromResource((Configuration)conf, (String)"resource://zstd.test.data", (int)0x100000);
        Assert.assertNotNull((String)"Failed to load test data", (Object)TEST_DATA);
    }

    @Test
    public void test() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("io.compression.codec.zstd.level", 3);
        conf.set("hbase.io.compress.zstd.dictionary", DICTIONARY_PATH);
        ZstdCodec codec = new ZstdCodec();
        codec.setConf(conf);
        this.codecTest((CompressionCodec)codec, new byte[][]{TEST_DATA}, 359909);
        Assert.assertTrue((String)"Dictionary was not loaded by codec", (boolean)DictionaryCache.contains((String)DICTIONARY_PATH));
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.err.println("Usage: TestZstdCodec <outFile>");
            System.exit(-1);
        }
        RandomDistribution.Zipf rng = new RandomDistribution.Zipf(new Random(), 0, 127, 2.0);
        File outFile = new File(args[0]);
        byte[] buffer = new byte[1024];
        System.out.println("Generating " + outFile);
        try (FileOutputStream os = new FileOutputStream(outFile);){
            for (int i = 0; i < 1000; ++i) {
                TestZstdDictionary.fill((RandomDistribution.DiscreteRNG)rng, (byte[])buffer);
                os.write(buffer);
            }
        }
        System.out.println("Done");
    }
}

