/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress.zstd;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.io.compress.CompressionTestBase;
import org.apache.hadoop.hbase.io.compress.zstd.ZstdCodec;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestZstdCodec
extends CompressionTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestZstdCodec.class);

    @Test
    public void testZstdCodecSmall() throws Exception {
        this.codecSmallTest((CompressionCodec)new ZstdCodec());
    }

    @Test
    public void testZstdCodecLarge() throws Exception {
        this.codecLargeTest((CompressionCodec)new ZstdCodec(), 1.1);
        this.codecLargeTest((CompressionCodec)new ZstdCodec(), 2.0);
        this.codecLargeTest((CompressionCodec)new ZstdCodec(), 10.0);
    }

    @Test
    public void testZstdCodecVeryLarge() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("io.compression.codec.zstd.level", 3);
        ZstdCodec codec = new ZstdCodec();
        codec.setConf(conf);
        this.codecVeryLargeTest((CompressionCodec)codec, 3.0);
    }
}

