/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress.zstd;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.compress.HFileTestBase;
import org.apache.hadoop.hbase.io.compress.zstd.ZstdCodec;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IOTests.class, SmallTests.class})
public class TestHFileCompressionZstd
extends HFileTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHFileCompressionZstd.class);
    private static Configuration conf;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.io.compress.zstd.codec", ZstdCodec.class.getCanonicalName());
        Compression.Algorithm.ZSTD.reload(conf);
        HFileTestBase.setUpBeforeClass();
    }

    @Test
    public void test() throws Exception {
        Path path = new Path(TEST_UTIL.getDataTestDir(), HBaseTestingUtility.getRandomUUID().toString() + ".hfile");
        this.doTest(conf, path, Compression.Algorithm.ZSTD);
    }

    @Test
    public void testReconfLevels() throws Exception {
        Path path_1 = new Path(TEST_UTIL.getDataTestDir(), HBaseTestingUtility.getRandomUUID().toString() + ".1.hfile");
        Path path_2 = new Path(TEST_UTIL.getDataTestDir(), HBaseTestingUtility.getRandomUUID().toString() + ".2.hfile");
        conf.setInt("hbase.io.compress.zstd.level", 1);
        this.doTest(conf, path_1, Compression.Algorithm.ZSTD);
        long len_1 = FS.getFileStatus(path_1).getLen();
        conf.setInt("hbase.io.compress.zstd.level", 22);
        this.doTest(conf, path_2, Compression.Algorithm.ZSTD);
        long len_2 = FS.getFileStatus(path_2).getLen();
        LOG.info("Level 1 len {}", (Object)len_1);
        LOG.info("Level 22 len {}", (Object)len_2);
        Assert.assertTrue((String)"Reconfiguraton with ZSTD_LEVEL_KEY did not seem to work", (len_1 > len_2 ? 1 : 0) != 0);
    }
}

