/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress.zstd;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictDecompress;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.compress.CanReinit;
import org.apache.hadoop.hbase.io.compress.CompressionUtil;
import org.apache.hadoop.hbase.io.compress.zstd.ZstdCodec;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ZstdDecompressor
implements CanReinit,
Decompressor {
    protected ByteBuffer inBuf;
    protected ByteBuffer outBuf;
    protected int bufferSize;
    protected int inLen;
    protected boolean finished;
    protected int dictId;
    protected ZstdDictDecompress dict;

    ZstdDecompressor(int bufferSize, byte[] dictionary) {
        this.bufferSize = bufferSize;
        this.inBuf = ByteBuffer.allocateDirect(bufferSize);
        this.outBuf = ByteBuffer.allocateDirect(bufferSize);
        this.outBuf.position(bufferSize);
        if (dictionary != null) {
            this.dictId = ZstdCodec.getDictionaryId(dictionary);
            this.dict = new ZstdDictDecompress(dictionary);
        }
    }

    ZstdDecompressor(int bufferSize) {
        this(bufferSize, null);
    }

    public int decompress(byte[] b, int off, int len) throws IOException {
        if (this.outBuf.hasRemaining()) {
            int remaining = this.outBuf.remaining();
            int n = Math.min(remaining, len);
            this.outBuf.get(b, off, n);
            return n;
        }
        if (this.inBuf.position() > 0) {
            this.inBuf.flip();
            int remaining = this.inBuf.remaining();
            this.inLen -= remaining;
            this.outBuf.clear();
            int written = this.dict != null ? Zstd.decompress((ByteBuffer)this.outBuf, (ByteBuffer)this.inBuf, (ZstdDictDecompress)this.dict) : Zstd.decompress((ByteBuffer)this.outBuf, (ByteBuffer)this.inBuf);
            this.inBuf.clear();
            this.outBuf.flip();
            int n = Math.min(written, len);
            this.outBuf.get(b, off, n);
            return n;
        }
        this.finished = true;
        return 0;
    }

    public void end() {
    }

    public boolean finished() {
        return this.finished;
    }

    public int getRemaining() {
        return this.inLen;
    }

    public boolean needsDictionary() {
        return false;
    }

    public void reset() {
        this.inBuf.clear();
        this.inLen = 0;
        this.outBuf.clear();
        this.outBuf.position(this.outBuf.capacity());
        this.finished = false;
    }

    public boolean needsInput() {
        return this.inBuf.position() == 0;
    }

    public void setDictionary(byte[] b, int off, int len) {
        throw new UnsupportedOperationException("setDictionary is not supported");
    }

    public void setInput(byte[] b, int off, int len) {
        if (this.inBuf.remaining() < len) {
            int needed = CompressionUtil.roundInt2((int)(this.inBuf.capacity() + len));
            ByteBuffer newBuf = ByteBuffer.allocateDirect(needed);
            this.inBuf.flip();
            newBuf.put(this.inBuf);
            this.inBuf = newBuf;
        }
        this.inBuf.put(b, off, len);
        this.inLen += len;
        this.finished = false;
    }

    public void reinit(Configuration conf) {
        if (conf != null) {
            byte[] b = ZstdCodec.getDictionary(conf);
            if (b != null) {
                int thisDictId = ZstdCodec.getDictionaryId(b);
                if (this.dict == null || this.dictId != thisDictId) {
                    this.dictId = thisDictId;
                    this.dict = new ZstdDictDecompress(b);
                }
            } else {
                this.dict = null;
            }
            int newBufferSize = ZstdCodec.getBufferSize(conf);
            if (this.bufferSize != newBufferSize) {
                this.bufferSize = newBufferSize;
                this.inBuf = ByteBuffer.allocateDirect(this.bufferSize);
                this.outBuf = ByteBuffer.allocateDirect(this.bufferSize);
            }
        }
        this.reset();
    }
}

