/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress.lz4;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.compress.lz4.Lz4Codec;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.wal.CompressedWALTestBase;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestWALCompressionLz4
extends CompressedWALTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWALCompressionLz4.class);
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.io.compress.lz4.codec", Lz4Codec.class.getCanonicalName());
        Compression.Algorithm.LZ4.reload(conf);
        conf.setBoolean("hbase.regionserver.wal.enablecompression", true);
        conf.setBoolean("hbase.regionserver.wal.value.enablecompression", true);
        conf.set("hbase.regionserver.wal.value.compression.type", Compression.Algorithm.LZ4.getName());
        TEST_UTIL.startMiniDFSCluster(3);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName().replaceAll("[^a-zA-Z0-9]", "_"));
        this.doTest(tableName);
    }
}

