/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCellUtil {
    @Test
    public void testCreateCellScannerOverflow() throws IOException {
        this.consume(this.doCreateCellScanner(1, 1), 1);
        this.consume(this.doCreateCellScanner(3, 0), 0);
        this.consume(this.doCreateCellScanner(3, 3), 9);
        this.consume(this.doCreateCellScanner(0, 1), 0);
        int hundredK = 100000;
        this.consume(this.doCreateCellScanner(100000, 0), 0);
        this.consume(this.doCreateCellArray(1), 1);
        this.consume(this.doCreateCellArray(0), 0);
        this.consume(this.doCreateCellArray(3), 3);
        ArrayList<TestCellScannable> cells = new ArrayList<TestCellScannable>(100000);
        for (int i = 0; i < 100000; ++i) {
            cells.add(new TestCellScannable(1));
        }
        this.consume(CellUtil.createCellScanner(cells), 100000);
        TreeMap m = new TreeMap(Bytes.BYTES_COMPARATOR);
        ArrayList<TestCell> cellArray = new ArrayList<TestCell>(100000);
        for (int i = 0; i < 100000; ++i) {
            cellArray.add(new TestCell(i));
        }
        m.put(new byte[]{102}, cellArray);
        this.consume(CellUtil.createCellScanner(m), 100000);
    }

    private CellScanner doCreateCellArray(int itemsPerList) {
        Cell[] cells = new Cell[itemsPerList];
        for (int i = 0; i < itemsPerList; ++i) {
            cells[i] = new TestCell(i);
        }
        return CellUtil.createCellScanner((Cell[])cells);
    }

    private CellScanner doCreateCellScanner(int listsCount, final int itemsPerList) throws IOException {
        ArrayList<1> cells = new ArrayList<1>(listsCount);
        for (int i = 0; i < listsCount; ++i) {
            CellScannable cs = new CellScannable(){

                public CellScanner cellScanner() {
                    return new TestCellScanner(itemsPerList);
                }
            };
            cells.add(cs);
        }
        return CellUtil.createCellScanner(cells);
    }

    private void consume(CellScanner scanner, int expected) throws IOException {
        int count = 0;
        while (scanner.advance()) {
            ++count;
        }
        Assert.assertEquals((long)expected, (long)count);
    }

    @Test
    public void testOverlappingKeys() {
        byte[] empty = HConstants.EMPTY_BYTE_ARRAY;
        byte[] a = Bytes.toBytes((String)"a");
        byte[] b = Bytes.toBytes((String)"b");
        byte[] c = Bytes.toBytes((String)"c");
        byte[] d = Bytes.toBytes((String)"d");
        Assert.assertTrue((boolean)CellUtil.overlappingKeys((byte[])a, (byte[])b, (byte[])a, (byte[])b));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys((byte[])a, (byte[])c, (byte[])a, (byte[])b));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys((byte[])a, (byte[])b, (byte[])a, (byte[])c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys((byte[])b, (byte[])c, (byte[])a, (byte[])c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys((byte[])a, (byte[])c, (byte[])b, (byte[])c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys((byte[])a, (byte[])d, (byte[])b, (byte[])c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys((byte[])b, (byte[])c, (byte[])a, (byte[])d));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys((byte[])empty, (byte[])b, (byte[])a, (byte[])b));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys((byte[])empty, (byte[])b, (byte[])a, (byte[])c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys((byte[])a, (byte[])b, (byte[])empty, (byte[])b));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys((byte[])a, (byte[])b, (byte[])empty, (byte[])c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys((byte[])a, (byte[])empty, (byte[])a, (byte[])b));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys((byte[])a, (byte[])empty, (byte[])a, (byte[])c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys((byte[])a, (byte[])b, (byte[])empty, (byte[])empty));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys((byte[])empty, (byte[])empty, (byte[])a, (byte[])b));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys((byte[])a, (byte[])b, (byte[])c, (byte[])d));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys((byte[])c, (byte[])d, (byte[])a, (byte[])b));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys((byte[])b, (byte[])c, (byte[])c, (byte[])d));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys((byte[])b, (byte[])c, (byte[])c, (byte[])empty));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys((byte[])b, (byte[])c, (byte[])d, (byte[])empty));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys((byte[])c, (byte[])d, (byte[])b, (byte[])c));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys((byte[])c, (byte[])empty, (byte[])b, (byte[])c));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys((byte[])d, (byte[])empty, (byte[])b, (byte[])c));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys((byte[])b, (byte[])c, (byte[])a, (byte[])b));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys((byte[])b, (byte[])c, (byte[])empty, (byte[])b));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys((byte[])b, (byte[])c, (byte[])empty, (byte[])a));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys((byte[])a, (byte[])b, (byte[])b, (byte[])c));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys((byte[])empty, (byte[])b, (byte[])b, (byte[])c));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys((byte[])empty, (byte[])a, (byte[])b, (byte[])c));
    }

    private class TestCell
    implements Cell {
        private final byte[] row;

        TestCell(int i) {
            this.row = Bytes.toBytes((int)i);
        }

        public byte[] getRowArray() {
            return this.row;
        }

        public int getRowOffset() {
            return 0;
        }

        public short getRowLength() {
            return (short)this.row.length;
        }

        public byte[] getFamilyArray() {
            return null;
        }

        public int getFamilyOffset() {
            return 0;
        }

        public byte getFamilyLength() {
            return 0;
        }

        public byte[] getQualifierArray() {
            return null;
        }

        public int getQualifierOffset() {
            return 0;
        }

        public int getQualifierLength() {
            return 0;
        }

        public long getTimestamp() {
            return 0L;
        }

        public byte getTypeByte() {
            return 0;
        }

        public long getMvccVersion() {
            return 0L;
        }

        public byte[] getValueArray() {
            return null;
        }

        public int getValueOffset() {
            return 0;
        }

        public int getValueLength() {
            return 0;
        }

        public byte[] getTagsArray() {
            return null;
        }

        public int getTagsOffset() {
            return 0;
        }

        public short getTagsLength() {
            return 0;
        }

        public int getTagsLengthUnsigned() {
            return 0;
        }

        public byte[] getValue() {
            return null;
        }

        public byte[] getFamily() {
            return null;
        }

        public byte[] getQualifier() {
            return null;
        }

        public byte[] getRow() {
            return null;
        }
    }

    private class TestCellScanner
    implements CellScanner {
        private int count = 0;
        private Cell current = null;
        private final int cellsCount;

        TestCellScanner(int cellsCount) {
            this.cellsCount = cellsCount;
        }

        public Cell current() {
            return this.current;
        }

        public boolean advance() throws IOException {
            if (this.count < this.cellsCount) {
                this.current = new TestCell(this.count);
                ++this.count;
                return true;
            }
            return false;
        }
    }

    private class TestCellScannable
    implements CellScannable {
        private final int cellsCount;

        TestCellScannable(int cellsCount) {
            this.cellsCount = cellsCount;
        }

        public CellScanner cellScanner() {
            return new TestCellScanner(this.cellsCount);
        }
    }
}

