/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.RpcController;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.MasterAdminKeepAliveConnection;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterAdminProtos;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestSnapshotFromAdmin {
    private static final Log LOG = LogFactory.getLog(TestSnapshotFromAdmin.class);

    @Test(timeout=60000L)
    public void testBackoffLogic() throws Exception {
        int pauseTime = 100;
        int maxWaitTime = HConstants.RETRY_BACKOFF[HConstants.RETRY_BACKOFF.length - 1] * 100;
        int numRetries = HConstants.RETRY_BACKOFF.length;
        long ignoreExpectedTime = 0L;
        for (int i = 0; i < HConstants.RETRY_BACKOFF.length; ++i) {
            ignoreExpectedTime += (long)(HConstants.RETRY_BACKOFF[i] * 100);
        }
        long time = 300 + maxWaitTime / numRetries * 3 + 300;
        Assert.assertTrue((String)"Capped snapshot wait time isn't less that the uncapped backoff time - further testing won't prove anything.", (time < ignoreExpectedTime ? 1 : 0) != 0);
        HConnectionManager.HConnectionImplementation mockConnection = (HConnectionManager.HConnectionImplementation)Mockito.mock(HConnectionManager.HConnectionImplementation.class);
        Configuration conf = HBaseConfiguration.create();
        conf.setInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, numRetries);
        conf.setLong("hbase.client.pause", 100L);
        MasterAdminKeepAliveConnection mockMaster = (MasterAdminKeepAliveConnection)Mockito.mock(MasterAdminKeepAliveConnection.class);
        Mockito.when((Object)mockConnection.getConfiguration()).thenReturn((Object)conf);
        Mockito.when((Object)mockConnection.getKeepAliveMasterAdminService()).thenReturn((Object)mockMaster);
        MasterAdminProtos.TakeSnapshotResponse response = MasterAdminProtos.TakeSnapshotResponse.newBuilder().setExpectedTimeout((long)maxWaitTime).build();
        Mockito.when((Object)mockMaster.snapshot((RpcController)Mockito.isNull(), (MasterAdminProtos.TakeSnapshotRequest)Mockito.any(MasterAdminProtos.TakeSnapshotRequest.class))).thenReturn((Object)response);
        MasterAdminProtos.IsSnapshotDoneResponse.Builder builder = MasterAdminProtos.IsSnapshotDoneResponse.newBuilder();
        builder.setDone(false);
        Mockito.when((Object)mockMaster.isSnapshotDone((RpcController)Mockito.isNull(), (MasterAdminProtos.IsSnapshotDoneRequest)Mockito.any(MasterAdminProtos.IsSnapshotDoneRequest.class))).thenReturn((Object)builder.build(), (Object[])new MasterAdminProtos.IsSnapshotDoneResponse[]{builder.build(), builder.build(), builder.build(), builder.build(), builder.setDone(true).build()});
        HBaseAdmin admin = new HBaseAdmin((HConnection)mockConnection);
        String snapshot = "snapshot";
        TableName table = TableName.valueOf((String)"table");
        long start = System.currentTimeMillis();
        admin.snapshot(snapshot, table);
        long finish = System.currentTimeMillis();
        long elapsed = finish - start;
        Assert.assertTrue((String)("Elapsed time:" + elapsed + " is more than expected max:" + time), (elapsed <= time ? 1 : 0) != 0);
        admin.close();
    }

    @Test
    public void testValidateSnapshotName() throws Exception {
        HConnectionManager.HConnectionImplementation mockConnection = (HConnectionManager.HConnectionImplementation)Mockito.mock(HConnectionManager.HConnectionImplementation.class);
        Configuration conf = HBaseConfiguration.create();
        Mockito.when((Object)mockConnection.getConfiguration()).thenReturn((Object)conf);
        HBaseAdmin admin = new HBaseAdmin((HConnection)mockConnection);
        HBaseProtos.SnapshotDescription.Builder builder = HBaseProtos.SnapshotDescription.newBuilder();
        this.failSnapshotStart(admin, builder.setName(".hbase-snapshot").build());
        this.failSnapshotStart(admin, builder.setName("-snapshot").build());
        this.failSnapshotStart(admin, builder.setName("snapshot fails").build());
        this.failSnapshotStart(admin, builder.setName("snap$hot").build());
        this.failSnapshotStart(admin, builder.setName("snap:hot").build());
        this.failSnapshotStart(admin, builder.setName("snapshot").setTable(".table").build());
        this.failSnapshotStart(admin, builder.setName("snapshot").setTable("-table").build());
        this.failSnapshotStart(admin, builder.setName("snapshot").setTable("table fails").build());
        this.failSnapshotStart(admin, builder.setName("snapshot").setTable("tab%le").build());
        MasterAdminKeepAliveConnection master = (MasterAdminKeepAliveConnection)Mockito.mock(MasterAdminKeepAliveConnection.class);
        Mockito.when((Object)mockConnection.getKeepAliveMasterAdminService()).thenReturn((Object)master);
        MasterAdminProtos.TakeSnapshotResponse response = MasterAdminProtos.TakeSnapshotResponse.newBuilder().setExpectedTimeout(0L).build();
        Mockito.when((Object)master.snapshot((RpcController)Mockito.isNull(), (MasterAdminProtos.TakeSnapshotRequest)Mockito.any(MasterAdminProtos.TakeSnapshotRequest.class))).thenReturn((Object)response);
        MasterAdminProtos.IsSnapshotDoneResponse doneResponse = MasterAdminProtos.IsSnapshotDoneResponse.newBuilder().setDone(true).build();
        Mockito.when((Object)master.isSnapshotDone((RpcController)Mockito.isNull(), (MasterAdminProtos.IsSnapshotDoneRequest)Mockito.any(MasterAdminProtos.IsSnapshotDoneRequest.class))).thenReturn((Object)doneResponse);
        admin.snapshot(builder.setName("snapshot").setTable("table").build());
    }

    private void failSnapshotStart(HBaseAdmin admin, HBaseProtos.SnapshotDescription snapshot) throws IOException {
        try {
            admin.snapshot(snapshot);
            Assert.fail((String)("Snapshot should not have succeed with name:" + snapshot.getName()));
        }
        catch (IllegalArgumentException e) {
            LOG.debug((Object)("Correctly failed to start snapshot:" + e.getMessage()));
        }
    }
}

