/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.Registry;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;

public class TestClientNoCluster {
    private static final Log LOG = LogFactory.getLog(TestClientNoCluster.class);
    private Configuration conf;

    @Before
    public void setUp() throws Exception {
        this.conf = HBaseConfiguration.create();
        this.conf.set("hbase.client.registry.impl", SimpleRegistry.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testTimeoutAndRetries() throws IOException {
        Configuration localConfig = HBaseConfiguration.create((Configuration)this.conf);
        localConfig.set("hbase.client.connection.impl", RpcTimeoutConnection.class.getName());
        HTable table = new HTable(localConfig, TableName.META_TABLE_NAME);
        SocketTimeoutException t = null;
        LOG.info((Object)"Start");
        try {
            table.exists(new Get(Bytes.toBytes((String)"abc")));
        }
        catch (SocketTimeoutException e) {
            LOG.info((Object)"Got expected exception", (Throwable)e);
            t = e;
        }
        catch (RetriesExhaustedException e) {
            Assert.fail();
        }
        finally {
            table.close();
        }
        LOG.info((Object)"Stop");
        Assert.assertTrue((t != null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRocTimeout() throws IOException {
        Configuration localConfig = HBaseConfiguration.create((Configuration)this.conf);
        localConfig.set("hbase.client.connection.impl", RpcTimeoutConnection.class.getName());
        int pause = 10;
        localConfig.setInt("hbase.client.pause", pause);
        localConfig.setInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, 10);
        localConfig.setInt("hbase.client.meta.operation.timeout", pause - 1);
        HTable table = new HTable(localConfig, TableName.META_TABLE_NAME);
        SocketTimeoutException t = null;
        try {
            table.exists(new Get(Bytes.toBytes((String)"abc")));
        }
        catch (SocketTimeoutException e) {
            LOG.info((Object)"Got expected exception", (Throwable)e);
            t = e;
        }
        catch (RetriesExhaustedException e) {
            Assert.fail();
        }
        finally {
            table.close();
        }
        Assert.assertTrue((t != null ? 1 : 0) != 0);
    }

    @Test
    public void testDoNotRetryMetaScanner() throws IOException {
        this.conf.set("hbase.client.connection.impl", RegionServerStoppedOnScannerOpenConnection.class.getName());
        MetaScanner.metaScan((Configuration)this.conf, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoNotRetryOnScanNext() throws IOException {
        this.conf.set("hbase.client.connection.impl", RegionServerStoppedOnScannerOpenConnection.class.getName());
        HTable table = new HTable(this.conf, TableName.META_TABLE_NAME);
        ResultScanner scanner = table.getScanner(HConstants.CATALOG_FAMILY);
        try {
            Result result = null;
            while ((result = scanner.next()) != null) {
                LOG.info((Object)result);
            }
        }
        finally {
            scanner.close();
            table.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionServerStoppedOnScannerOpen() throws IOException {
        this.conf.set("hbase.client.connection.impl", RegionServerStoppedOnScannerOpenConnection.class.getName());
        HTable table = new HTable(this.conf, TableName.META_TABLE_NAME);
        ResultScanner scanner = table.getScanner(HConstants.CATALOG_FAMILY);
        try {
            Result result = null;
            while ((result = scanner.next()) != null) {
                LOG.info((Object)result);
            }
        }
        finally {
            scanner.close();
            table.close();
        }
    }

    static class RpcTimeoutConnection
    extends HConnectionManager.HConnectionImplementation {
        final ClientProtos.ClientService.BlockingInterface stub = (ClientProtos.ClientService.BlockingInterface)Mockito.mock(ClientProtos.ClientService.BlockingInterface.class);

        RpcTimeoutConnection(Configuration conf, boolean managed, ExecutorService pool) throws IOException {
            super(conf, managed);
            try {
                Mockito.when((Object)this.stub.get((RpcController)Mockito.any(), (ClientProtos.GetRequest)Mockito.any())).thenThrow(new Throwable[]{new ServiceException((Throwable)new RegionServerStoppedException("From Mockito"))});
            }
            catch (ServiceException e) {
                throw new IOException(e);
            }
        }

        public ClientProtos.ClientService.BlockingInterface getClient(ServerName sn) throws IOException {
            return this.stub;
        }
    }

    static class RegionServerStoppedOnScannerOpenConnection
    extends HConnectionManager.HConnectionImplementation {
        final ClientProtos.ClientService.BlockingInterface stub = (ClientProtos.ClientService.BlockingInterface)Mockito.mock(ClientProtos.ClientService.BlockingInterface.class);

        RegionServerStoppedOnScannerOpenConnection(Configuration conf, boolean managed, ExecutorService pool) throws IOException {
            super(conf, managed);
            long sid = 12345L;
            try {
                Mockito.when((Object)this.stub.scan((RpcController)Mockito.any(), (ClientProtos.ScanRequest)Mockito.any())).thenReturn((Object)ClientProtos.ScanResponse.newBuilder().setScannerId(sid).build()).thenThrow(new Throwable[]{new ServiceException((Throwable)new RegionServerStoppedException("From Mockito"))}).thenReturn((Object)ClientProtos.ScanResponse.newBuilder().setScannerId(sid).setMoreResults(false).build());
            }
            catch (ServiceException e) {
                throw new IOException(e);
            }
        }

        public ClientProtos.ClientService.BlockingInterface getClient(ServerName sn) throws IOException {
            return this.stub;
        }
    }

    static class ScanOpenNextThenExceptionThenRecoverConnection
    extends HConnectionManager.HConnectionImplementation {
        final ClientProtos.ClientService.BlockingInterface stub = (ClientProtos.ClientService.BlockingInterface)Mockito.mock(ClientProtos.ClientService.BlockingInterface.class);

        ScanOpenNextThenExceptionThenRecoverConnection(Configuration conf, boolean managed, ExecutorService pool) throws IOException {
            super(conf, managed);
            long sid = 12345L;
            try {
                Mockito.when((Object)this.stub.scan((RpcController)Mockito.any(), (ClientProtos.ScanRequest)Mockito.any())).thenReturn((Object)ClientProtos.ScanResponse.newBuilder().setScannerId(sid).build()).thenThrow(new Throwable[]{new ServiceException((Throwable)new RegionServerStoppedException("From Mockito"))}).thenReturn((Object)ClientProtos.ScanResponse.newBuilder().setScannerId(sid).setMoreResults(false).build());
            }
            catch (ServiceException e) {
                throw new IOException(e);
            }
        }

        public ClientProtos.ClientService.BlockingInterface getClient(ServerName sn) throws IOException {
            return this.stub;
        }
    }

    static class SimpleRegistry
    implements Registry {
        final ServerName META_HOST = new ServerName("10.10.10.10", 60010, 12345L);

        SimpleRegistry() {
        }

        public void init(HConnection connection) {
        }

        public HRegionLocation getMetaRegionLocation() throws IOException {
            return new HRegionLocation(HRegionInfo.FIRST_META_REGIONINFO, this.META_HOST);
        }

        public String getClusterId() {
            return "default-cluster";
        }

        public boolean isTableOnlineState(TableName tableName, boolean enabled) throws IOException {
            return enabled;
        }

        public int getCurrentNrHRS() throws IOException {
            return 1;
        }
    }
}

