/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.asyncfs;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CipherOption;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.CryptoCodec;
import org.apache.hadoop.crypto.Decryptor;
import org.apache.hadoop.crypto.Encryptor;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.hbase.io.asyncfs.ProtobufDecoder;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.datatransfer.InvalidEncryptionKeyException;
import org.apache.hadoop.hdfs.protocol.datatransfer.TrustedChannelResolver;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.SaslDataTransferClient;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.security.SaslPropertiesResolver;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hbase.thirdparty.com.google.common.base.Throwables;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBufOutputStream;
import org.apache.hbase.thirdparty.io.netty.buffer.CompositeByteBuf;
import org.apache.hbase.thirdparty.io.netty.buffer.Unpooled;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelDuplexHandler;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandler;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelOutboundHandlerAdapter;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelPipeline;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelPromise;
import org.apache.hbase.thirdparty.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.hbase.thirdparty.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.apache.hbase.thirdparty.io.netty.handler.codec.MessageToByteEncoder;
import org.apache.hbase.thirdparty.io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import org.apache.hbase.thirdparty.io.netty.handler.timeout.IdleState;
import org.apache.hbase.thirdparty.io.netty.handler.timeout.IdleStateEvent;
import org.apache.hbase.thirdparty.io.netty.handler.timeout.IdleStateHandler;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.Promise;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class FanOutOneBlockAsyncDFSOutputSaslHelper {
    private static final Logger LOG = LoggerFactory.getLogger(FanOutOneBlockAsyncDFSOutputSaslHelper.class);
    private static final String SERVER_NAME = "0";
    private static final String PROTOCOL = "hdfs";
    private static final String MECHANISM = "DIGEST-MD5";
    private static final int SASL_TRANSFER_MAGIC_NUMBER = -559038737;
    private static final String NAME_DELIMITER = " ";
    private static final SaslAdaptor SASL_ADAPTOR;
    private static final TransparentCryptoHelper TRANSPARENT_CRYPTO_HELPER;

    private FanOutOneBlockAsyncDFSOutputSaslHelper() {
    }

    private static SaslAdaptor createSaslAdaptor() throws NoSuchFieldException, NoSuchMethodException {
        final Field saslPropsResolverField = SaslDataTransferClient.class.getDeclaredField("saslPropsResolver");
        saslPropsResolverField.setAccessible(true);
        final Field trustedChannelResolverField = SaslDataTransferClient.class.getDeclaredField("trustedChannelResolver");
        trustedChannelResolverField.setAccessible(true);
        final Field fallbackToSimpleAuthField = SaslDataTransferClient.class.getDeclaredField("fallbackToSimpleAuth");
        fallbackToSimpleAuthField.setAccessible(true);
        return new SaslAdaptor(){

            @Override
            public TrustedChannelResolver getTrustedChannelResolver(SaslDataTransferClient saslClient) {
                try {
                    return (TrustedChannelResolver)trustedChannelResolverField.get(saslClient);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public SaslPropertiesResolver getSaslPropsResolver(SaslDataTransferClient saslClient) {
                try {
                    return (SaslPropertiesResolver)saslPropsResolverField.get(saslClient);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public AtomicBoolean getFallbackToSimpleAuth(SaslDataTransferClient saslClient) {
                try {
                    return (AtomicBoolean)fallbackToSimpleAuthField.get(saslClient);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private static TransparentCryptoHelper createTransparentCryptoHelperWithoutHDFS12396() throws NoSuchMethodException {
        final Method decryptEncryptedDataEncryptionKeyMethod = DFSClient.class.getDeclaredMethod("decryptEncryptedDataEncryptionKey", FileEncryptionInfo.class);
        decryptEncryptedDataEncryptionKeyMethod.setAccessible(true);
        return new TransparentCryptoHelper(){

            @Override
            public Encryptor createEncryptor(Configuration conf, FileEncryptionInfo feInfo, DFSClient client) throws IOException {
                try {
                    KeyProvider.KeyVersion decryptedKey = (KeyProvider.KeyVersion)decryptEncryptedDataEncryptionKeyMethod.invoke((Object)client, feInfo);
                    CryptoCodec cryptoCodec = CryptoCodec.getInstance((Configuration)conf, (CipherSuite)feInfo.getCipherSuite());
                    Encryptor encryptor = cryptoCodec.createEncryptor();
                    encryptor.init(decryptedKey.getMaterial(), feInfo.getIV());
                    return encryptor;
                }
                catch (InvocationTargetException e) {
                    Throwables.propagateIfPossible((Throwable)e.getTargetException(), IOException.class);
                    throw new RuntimeException(e.getTargetException());
                }
                catch (GeneralSecurityException e) {
                    throw new IOException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private static TransparentCryptoHelper createTransparentCryptoHelperWithHDFS12396() throws ClassNotFoundException, NoSuchMethodException {
        Class<?> hdfsKMSUtilCls = Class.forName("org.apache.hadoop.hdfs.HdfsKMSUtil");
        final Method decryptEncryptedDataEncryptionKeyMethod = hdfsKMSUtilCls.getDeclaredMethod("decryptEncryptedDataEncryptionKey", FileEncryptionInfo.class, KeyProvider.class);
        decryptEncryptedDataEncryptionKeyMethod.setAccessible(true);
        return new TransparentCryptoHelper(){

            @Override
            public Encryptor createEncryptor(Configuration conf, FileEncryptionInfo feInfo, DFSClient client) throws IOException {
                try {
                    KeyProvider.KeyVersion decryptedKey = (KeyProvider.KeyVersion)decryptEncryptedDataEncryptionKeyMethod.invoke(null, feInfo, client.getKeyProvider());
                    CryptoCodec cryptoCodec = CryptoCodec.getInstance((Configuration)conf, (CipherSuite)feInfo.getCipherSuite());
                    Encryptor encryptor = cryptoCodec.createEncryptor();
                    encryptor.init(decryptedKey.getMaterial(), feInfo.getIV());
                    return encryptor;
                }
                catch (InvocationTargetException e) {
                    Throwables.propagateIfPossible((Throwable)e.getTargetException(), IOException.class);
                    throw new RuntimeException(e.getTargetException());
                }
                catch (GeneralSecurityException e) {
                    throw new IOException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private static TransparentCryptoHelper createTransparentCryptoHelper() throws NoSuchMethodException, ClassNotFoundException {
        try {
            return FanOutOneBlockAsyncDFSOutputSaslHelper.createTransparentCryptoHelperWithoutHDFS12396();
        }
        catch (NoSuchMethodException e) {
            LOG.debug("No decryptEncryptedDataEncryptionKey method in DFSClient, should be hadoop version with HDFS-12396", (Throwable)e);
            return FanOutOneBlockAsyncDFSOutputSaslHelper.createTransparentCryptoHelperWithHDFS12396();
        }
    }

    private static String getUserNameFromEncryptionKey(DataEncryptionKey encryptionKey) {
        return encryptionKey.keyId + NAME_DELIMITER + encryptionKey.blockPoolId + NAME_DELIMITER + Base64.getEncoder().encodeToString(encryptionKey.nonce);
    }

    private static char[] encryptionKeyToPassword(byte[] encryptionKey) {
        return Base64.getEncoder().encodeToString(encryptionKey).toCharArray();
    }

    private static String buildUsername(Token<BlockTokenIdentifier> blockToken) {
        return Base64.getEncoder().encodeToString(blockToken.getIdentifier());
    }

    private static char[] buildClientPassword(Token<BlockTokenIdentifier> blockToken) {
        return Base64.getEncoder().encodeToString(blockToken.getPassword()).toCharArray();
    }

    private static Map<String, String> createSaslPropertiesForEncryption(String encryptionAlgorithm) {
        HashMap saslProps = Maps.newHashMapWithExpectedSize((int)3);
        saslProps.put("javax.security.sasl.qop", SaslRpcServer.QualityOfProtection.PRIVACY.getSaslQop());
        saslProps.put("javax.security.sasl.server.authentication", "true");
        saslProps.put("com.sun.security.sasl.digest.cipher", encryptionAlgorithm);
        return saslProps;
    }

    private static void doSaslNegotiation(Configuration conf, Channel channel, int timeoutMs, String username, char[] password, Map<String, String> saslProps, Promise<Void> saslPromise, DFSClient dfsClient) {
        try {
            channel.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler((long)timeoutMs, 0L, 0L, TimeUnit.MILLISECONDS), new ProtobufVarint32FrameDecoder(), new ProtobufDecoder(DataTransferProtos.DataTransferEncryptorMessageProto.getDefaultInstance()), new SaslNegotiateHandler(conf, username, password, saslProps, timeoutMs, saslPromise, dfsClient)});
        }
        catch (SaslException e) {
            saslPromise.tryFailure((Throwable)e);
        }
    }

    static void trySaslNegotiate(Configuration conf, Channel channel, DatanodeInfo dnInfo, int timeoutMs, DFSClient client, Token<BlockTokenIdentifier> accessToken, Promise<Void> saslPromise) throws IOException {
        SaslDataTransferClient saslClient = client.getSaslDataTransferClient();
        SaslPropertiesResolver saslPropsResolver = SASL_ADAPTOR.getSaslPropsResolver(saslClient);
        TrustedChannelResolver trustedChannelResolver = SASL_ADAPTOR.getTrustedChannelResolver(saslClient);
        AtomicBoolean fallbackToSimpleAuth = SASL_ADAPTOR.getFallbackToSimpleAuth(saslClient);
        InetAddress addr = ((InetSocketAddress)channel.remoteAddress()).getAddress();
        if (trustedChannelResolver.isTrusted() || trustedChannelResolver.isTrusted(addr)) {
            saslPromise.trySuccess(null);
            return;
        }
        DataEncryptionKey encryptionKey = client.newDataEncryptionKey();
        if (encryptionKey != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("SASL client doing encrypted handshake for addr = " + addr + ", datanodeId = " + dnInfo);
            }
            FanOutOneBlockAsyncDFSOutputSaslHelper.doSaslNegotiation(conf, channel, timeoutMs, FanOutOneBlockAsyncDFSOutputSaslHelper.getUserNameFromEncryptionKey(encryptionKey), FanOutOneBlockAsyncDFSOutputSaslHelper.encryptionKeyToPassword(encryptionKey.encryptionKey), FanOutOneBlockAsyncDFSOutputSaslHelper.createSaslPropertiesForEncryption(encryptionKey.encryptionAlgorithm), saslPromise, client);
        } else if (!UserGroupInformation.isSecurityEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("SASL client skipping handshake in unsecured configuration for addr = " + addr + ", datanodeId = " + dnInfo);
            }
            saslPromise.trySuccess(null);
        } else if (dnInfo.getXferPort() < 1024) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("SASL client skipping handshake in secured configuration with privileged port for addr = " + addr + ", datanodeId = " + dnInfo);
            }
            saslPromise.trySuccess(null);
        } else if (fallbackToSimpleAuth != null && fallbackToSimpleAuth.get()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("SASL client skipping handshake in secured configuration with unsecured cluster for addr = " + addr + ", datanodeId = " + dnInfo);
            }
            saslPromise.trySuccess(null);
        } else if (saslPropsResolver != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("SASL client doing general handshake for addr = " + addr + ", datanodeId = " + dnInfo);
            }
            FanOutOneBlockAsyncDFSOutputSaslHelper.doSaslNegotiation(conf, channel, timeoutMs, FanOutOneBlockAsyncDFSOutputSaslHelper.buildUsername(accessToken), FanOutOneBlockAsyncDFSOutputSaslHelper.buildClientPassword(accessToken), saslPropsResolver.getClientProperties(addr), saslPromise, client);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("SASL client skipping handshake in secured configuration with no SASL protection configured for addr = " + addr + ", datanodeId = " + dnInfo);
            }
            saslPromise.trySuccess(null);
        }
    }

    static Encryptor createEncryptor(Configuration conf, HdfsFileStatus stat, DFSClient client) throws IOException {
        FileEncryptionInfo feInfo = stat.getFileEncryptionInfo();
        if (feInfo == null) {
            return null;
        }
        return TRANSPARENT_CRYPTO_HELPER.createEncryptor(conf, feInfo, client);
    }

    static {
        try {
            SASL_ADAPTOR = FanOutOneBlockAsyncDFSOutputSaslHelper.createSaslAdaptor();
            TRANSPARENT_CRYPTO_HELPER = FanOutOneBlockAsyncDFSOutputSaslHelper.createTransparentCryptoHelper();
        }
        catch (Exception e) {
            String msg = "Couldn't properly initialize access to HDFS internals. Please update your WAL Provider to not make use of the 'asyncfs' provider. See HBASE-16110 for more information.";
            LOG.error(msg, (Throwable)e);
            throw new Error(msg, e);
        }
    }

    private static final class EncryptHandler
    extends MessageToByteEncoder<ByteBuf> {
        private final Encryptor encryptor;

        public EncryptHandler(CryptoCodec codec, byte[] key, byte[] iv) throws GeneralSecurityException, IOException {
            this.encryptor = codec.createEncryptor();
            this.encryptor.init(key, Arrays.copyOf(iv, iv.length));
        }

        protected ByteBuf allocateBuffer(ChannelHandlerContext ctx, ByteBuf msg, boolean preferDirect) throws Exception {
            if (preferDirect) {
                return ctx.alloc().directBuffer(msg.readableBytes());
            }
            return ctx.alloc().buffer(msg.readableBytes());
        }

        protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) throws Exception {
            ByteBuf inBuf;
            boolean release = false;
            if (msg.nioBufferCount() == 1) {
                inBuf = msg;
            } else {
                inBuf = ctx.alloc().directBuffer(msg.readableBytes());
                msg.readBytes(inBuf);
                release = true;
            }
            ByteBuffer inBuffer = inBuf.nioBuffer();
            ByteBuffer outBuffer = out.nioBuffer(0, inBuf.readableBytes());
            this.encryptor.encrypt(inBuffer, outBuffer);
            out.writerIndex(inBuf.readableBytes());
            if (release) {
                inBuf.release();
            }
        }
    }

    private static final class DecryptHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        private final Decryptor decryptor;

        public DecryptHandler(CryptoCodec codec, byte[] key, byte[] iv) throws GeneralSecurityException, IOException {
            this.decryptor = codec.createDecryptor();
            this.decryptor.init(key, Arrays.copyOf(iv, iv.length));
        }

        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
            ByteBuf inBuf;
            boolean release = false;
            if (msg.nioBufferCount() == 1) {
                inBuf = msg;
            } else {
                inBuf = ctx.alloc().directBuffer(msg.readableBytes());
                msg.readBytes(inBuf);
                release = true;
            }
            ByteBuffer inBuffer = inBuf.nioBuffer();
            ByteBuf outBuf = ctx.alloc().directBuffer(inBuf.readableBytes());
            ByteBuffer outBuffer = outBuf.nioBuffer(0, inBuf.readableBytes());
            this.decryptor.decrypt(inBuffer, outBuffer);
            outBuf.writerIndex(inBuf.readableBytes());
            if (release) {
                inBuf.release();
            }
            ctx.fireChannelRead((Object)outBuf);
        }
    }

    private static final class SaslWrapHandler
    extends ChannelOutboundHandlerAdapter {
        private final SaslClient saslClient;
        private CompositeByteBuf cBuf;

        public SaslWrapHandler(SaslClient saslClient) {
            this.saslClient = saslClient;
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            this.cBuf = new CompositeByteBuf(ctx.alloc(), false, Integer.MAX_VALUE);
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (msg instanceof ByteBuf) {
                ByteBuf buf = (ByteBuf)msg;
                this.cBuf.addComponent(buf);
                this.cBuf.writerIndex(this.cBuf.writerIndex() + buf.readableBytes());
            } else {
                ctx.write(msg);
            }
        }

        public void flush(ChannelHandlerContext ctx) throws Exception {
            if (this.cBuf.isReadable()) {
                byte[] b = new byte[this.cBuf.readableBytes()];
                this.cBuf.readBytes(b);
                this.cBuf.discardReadComponents();
                byte[] wrapped = this.saslClient.wrap(b, 0, b.length);
                ByteBuf buf = ctx.alloc().ioBuffer(4 + wrapped.length);
                buf.writeInt(wrapped.length);
                buf.writeBytes(wrapped);
                ctx.write((Object)buf);
            }
            ctx.flush();
        }

        public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            this.cBuf.release();
            this.cBuf = null;
        }
    }

    private static final class SaslUnwrapHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        private final SaslClient saslClient;

        public SaslUnwrapHandler(SaslClient saslClient) {
            this.saslClient = saslClient;
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.saslClient.dispose();
        }

        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
            msg.skipBytes(4);
            byte[] b = new byte[msg.readableBytes()];
            msg.readBytes(b);
            ctx.fireChannelRead((Object)Unpooled.wrappedBuffer((byte[])this.saslClient.unwrap(b, 0, b.length)));
        }
    }

    private static final class SaslNegotiateHandler
    extends ChannelDuplexHandler {
        private final Configuration conf;
        private final Map<String, String> saslProps;
        private final SaslClient saslClient;
        private final int timeoutMs;
        private final Promise<Void> promise;
        private final DFSClient dfsClient;
        private int step = 0;

        public SaslNegotiateHandler(Configuration conf, String username, char[] password, Map<String, String> saslProps, int timeoutMs, Promise<Void> promise, DFSClient dfsClient) throws SaslException {
            this.conf = conf;
            this.saslProps = saslProps;
            this.saslClient = Sasl.createSaslClient(new String[]{FanOutOneBlockAsyncDFSOutputSaslHelper.MECHANISM}, username, FanOutOneBlockAsyncDFSOutputSaslHelper.PROTOCOL, FanOutOneBlockAsyncDFSOutputSaslHelper.SERVER_NAME, saslProps, new SaslClientCallbackHandler(username, password));
            this.timeoutMs = timeoutMs;
            this.promise = promise;
            this.dfsClient = dfsClient;
        }

        private void sendSaslMessage(ChannelHandlerContext ctx, byte[] payload) throws IOException {
            this.sendSaslMessage(ctx, payload, null);
        }

        private List<CipherOption> getCipherOptions() throws IOException {
            String cipherSuites = this.conf.get("dfs.encrypt.data.transfer.cipher.suites");
            if (StringUtils.isBlank((CharSequence)cipherSuites)) {
                return null;
            }
            if (!cipherSuites.equals(CipherSuite.AES_CTR_NOPADDING.getName())) {
                throw new IOException(String.format("Invalid cipher suite, %s=%s", "dfs.encrypt.data.transfer.cipher.suites", cipherSuites));
            }
            return Collections.singletonList(new CipherOption(CipherSuite.AES_CTR_NOPADDING));
        }

        private void sendSaslMessage(ChannelHandlerContext ctx, byte[] payload, List<CipherOption> options) throws IOException {
            DataTransferProtos.DataTransferEncryptorMessageProto.Builder builder = DataTransferProtos.DataTransferEncryptorMessageProto.newBuilder();
            builder.setStatus(DataTransferProtos.DataTransferEncryptorMessageProto.DataTransferEncryptorStatus.SUCCESS);
            if (payload != null) {
                BuilderPayloadSetter.wrapAndSetPayload(builder, payload);
            }
            if (options != null) {
                builder.addAllCipherOption((Iterable)PBHelperClient.convertCipherOptions(options));
            }
            DataTransferProtos.DataTransferEncryptorMessageProto proto = builder.build();
            int size = proto.getSerializedSize();
            size += CodedOutputStream.computeRawVarint32Size((int)size);
            ByteBuf buf = ctx.alloc().buffer(size);
            proto.writeDelimitedTo((OutputStream)new ByteBufOutputStream(buf));
            ctx.write((Object)buf);
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            ctx.write((Object)ctx.alloc().buffer(4).writeInt(-559038737));
            this.sendSaslMessage(ctx, new byte[0]);
            ctx.flush();
            ++this.step;
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.saslClient.dispose();
        }

        private void check(DataTransferProtos.DataTransferEncryptorMessageProto proto) throws IOException {
            if (proto.getStatus() == DataTransferProtos.DataTransferEncryptorMessageProto.DataTransferEncryptorStatus.ERROR_UNKNOWN_KEY) {
                this.dfsClient.clearDataEncryptionKey();
                throw new InvalidEncryptionKeyException(proto.getMessage());
            }
            if (proto.getStatus() == DataTransferProtos.DataTransferEncryptorMessageProto.DataTransferEncryptorStatus.ERROR) {
                throw new IOException(proto.getMessage());
            }
        }

        private String getNegotiatedQop() {
            return (String)this.saslClient.getNegotiatedProperty("javax.security.sasl.qop");
        }

        private boolean isNegotiatedQopPrivacy() {
            String qop = this.getNegotiatedQop();
            return qop != null && "auth-conf".equalsIgnoreCase(qop);
        }

        private boolean requestedQopContainsPrivacy() {
            ImmutableSet requestedQop = ImmutableSet.copyOf(Arrays.asList(this.saslProps.get("javax.security.sasl.qop").split(",")));
            return requestedQop.contains("auth-conf");
        }

        private void checkSaslComplete() throws IOException {
            if (!this.saslClient.isComplete()) {
                throw new IOException("Failed to complete SASL handshake");
            }
            ImmutableSet requestedQop = ImmutableSet.copyOf(Arrays.asList(this.saslProps.get("javax.security.sasl.qop").split(",")));
            String negotiatedQop = this.getNegotiatedQop();
            LOG.debug("Verifying QOP, requested QOP = " + requestedQop + ", negotiated QOP = " + negotiatedQop);
            if (!requestedQop.contains(negotiatedQop)) {
                throw new IOException(String.format("SASL handshake completed, but channel does not have acceptable quality of protection, requested = %s, negotiated = %s", requestedQop, negotiatedQop));
            }
        }

        private boolean useWrap() {
            String qop = (String)this.saslClient.getNegotiatedProperty("javax.security.sasl.qop");
            return qop != null && !"auth".equalsIgnoreCase(qop);
        }

        private CipherOption unwrap(CipherOption option, SaslClient saslClient) throws IOException {
            byte[] outKey;
            byte[] inKey = option.getInKey();
            if (inKey != null) {
                inKey = saslClient.unwrap(inKey, 0, inKey.length);
            }
            if ((outKey = option.getOutKey()) != null) {
                outKey = saslClient.unwrap(outKey, 0, outKey.length);
            }
            return new CipherOption(option.getCipherSuite(), inKey, option.getInIv(), outKey, option.getOutIv());
        }

        private CipherOption getCipherOption(DataTransferProtos.DataTransferEncryptorMessageProto proto, boolean isNegotiatedQopPrivacy, SaslClient saslClient) throws IOException {
            List cipherOptions = PBHelperClient.convertCipherOptionProtos((List)proto.getCipherOptionList());
            if (cipherOptions == null || cipherOptions.isEmpty()) {
                return null;
            }
            CipherOption cipherOption = (CipherOption)cipherOptions.get(0);
            return isNegotiatedQopPrivacy ? this.unwrap(cipherOption, saslClient) : cipherOption;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof DataTransferProtos.DataTransferEncryptorMessageProto) {
                DataTransferProtos.DataTransferEncryptorMessageProto proto = (DataTransferProtos.DataTransferEncryptorMessageProto)msg;
                this.check(proto);
                byte[] challenge = proto.getPayload().toByteArray();
                byte[] response = this.saslClient.evaluateChallenge(challenge);
                switch (this.step) {
                    case 1: {
                        List<CipherOption> cipherOptions = null;
                        if (this.requestedQopContainsPrivacy()) {
                            cipherOptions = this.getCipherOptions();
                        }
                        this.sendSaslMessage(ctx, response, cipherOptions);
                        ctx.flush();
                        ++this.step;
                        break;
                    }
                    case 2: {
                        assert (response == null);
                        this.checkSaslComplete();
                        CipherOption cipherOption = this.getCipherOption(proto, this.isNegotiatedQopPrivacy(), this.saslClient);
                        ChannelPipeline p = ctx.pipeline();
                        while (p.first() != null) {
                            p.removeFirst();
                        }
                        if (cipherOption != null) {
                            CryptoCodec codec = CryptoCodec.getInstance((Configuration)this.conf, (CipherSuite)cipherOption.getCipherSuite());
                            p.addLast(new ChannelHandler[]{new EncryptHandler(codec, cipherOption.getInKey(), cipherOption.getInIv()), new DecryptHandler(codec, cipherOption.getOutKey(), cipherOption.getOutIv())});
                        } else if (this.useWrap()) {
                            p.addLast(new ChannelHandler[]{new SaslWrapHandler(this.saslClient), new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4), new SaslUnwrapHandler(this.saslClient)});
                        }
                        this.promise.trySuccess(null);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unrecognized negotiation step: " + this.step);
                    }
                }
            } else {
                ctx.fireChannelRead(msg);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            this.promise.tryFailure(cause);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof IdleStateEvent && ((IdleStateEvent)evt).state() == IdleState.READER_IDLE) {
                this.promise.tryFailure((Throwable)new IOException("Timeout(" + this.timeoutMs + "ms) waiting for response"));
            } else {
                super.userEventTriggered(ctx, evt);
            }
        }

        private static class BuilderPayloadSetter {
            private static Method setPayloadMethod;
            private static Constructor<?> constructor;

            private BuilderPayloadSetter() {
            }

            static void wrapAndSetPayload(DataTransferProtos.DataTransferEncryptorMessageProto.Builder builder, byte[] payload) throws IOException {
                try {
                    Object byteStringObject = constructor.newInstance(new Object[]{payload});
                    setPayloadMethod.invoke((Object)builder, constructor.getDeclaringClass().cast(byteStringObject));
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    Throwables.propagateIfPossible((Throwable)e.getTargetException(), IOException.class);
                    throw new RuntimeException(e.getTargetException());
                }
            }

            static {
                Class<?> literalByteStringClass;
                Class<DataTransferProtos.DataTransferEncryptorMessageProto.Builder> builderClass = DataTransferProtos.DataTransferEncryptorMessageProto.Builder.class;
                Class byteStringClass = ByteString.class;
                try {
                    byteStringClass = Class.forName("org.apache.hadoop.thirdparty.protobuf.ByteString");
                    LOG.debug("Found relocated ByteString class from hadoop-thirdparty. Assuming this is Hadoop 3.3.0+.");
                }
                catch (ClassNotFoundException e) {
                    LOG.debug("Did not find relocated ByteString class from hadoop-thirdparty. Assuming this is below Hadoop 3.3.0", (Throwable)e);
                }
                try {
                    literalByteStringClass = Class.forName("org.apache.hadoop.thirdparty.protobuf.ByteString$LiteralByteString");
                    LOG.debug("Shaded LiteralByteString from hadoop-thirdparty is found.");
                }
                catch (ClassNotFoundException e) {
                    try {
                        literalByteStringClass = Class.forName("com.google.protobuf.LiteralByteString");
                        LOG.debug("com.google.protobuf.LiteralByteString found.");
                    }
                    catch (ClassNotFoundException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                try {
                    constructor = literalByteStringClass.getDeclaredConstructor(byte[].class);
                    constructor.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
                try {
                    setPayloadMethod = builderClass.getMethod("setPayload", byteStringClass);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static final class SaslClientCallbackHandler
    implements CallbackHandler {
        private final char[] password;
        private final String userName;

        public SaslClientCallbackHandler(String userName, char[] password) {
            this.password = password;
            this.userName = userName;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            NameCallback nc = null;
            PasswordCallback pc = null;
            TextInputCallback rc = null;
            for (Callback callback : callbacks) {
                if (callback instanceof RealmChoiceCallback) continue;
                if (callback instanceof NameCallback) {
                    nc = (NameCallback)callback;
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    pc = (PasswordCallback)callback;
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    rc = (RealmCallback)callback;
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized SASL client callback");
            }
            if (nc != null) {
                nc.setName(this.userName);
            }
            if (pc != null) {
                pc.setPassword(this.password);
            }
            if (rc != null) {
                rc.setText(rc.getDefaultText());
            }
        }
    }

    private static interface TransparentCryptoHelper {
        public Encryptor createEncryptor(Configuration var1, FileEncryptionInfo var2, DFSClient var3) throws IOException;
    }

    private static interface SaslAdaptor {
        public TrustedChannelResolver getTrustedChannelResolver(SaslDataTransferClient var1);

        public SaslPropertiesResolver getSaslPropsResolver(SaslDataTransferClient var1);

        public AtomicBoolean getFallbackToSimpleAuth(SaslDataTransferClient var1);
    }
}

