/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.kafka;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableBuilder;
import org.apache.hadoop.hbase.kafka.HBaseKafkaEvent;
import org.apache.hadoop.hbase.kafka.KafkaTableForBridge;
import org.apache.hadoop.hbase.kafka.TopicRoutingRules;
import org.apache.hadoop.hbase.security.User;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class KafkaBridgeConnection
implements Connection {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaBridgeConnection.class);
    private final Configuration conf;
    private final User user;
    private final ExecutorService pool;
    private volatile boolean closed = false;
    private TopicRoutingRules routingRules;
    private Producer<byte[], byte[]> producer;
    private DatumWriter<HBaseKafkaEvent> avroWriter = new SpecificDatumWriter(HBaseKafkaEvent.getClassSchema());

    public KafkaBridgeConnection(Configuration conf, ExecutorService pool, User user) throws IOException {
        this.conf = conf;
        this.user = user;
        this.pool = pool;
        this.setupRules();
        this.startKafkaConnection();
    }

    public KafkaBridgeConnection(Configuration conf, ExecutorService pool, User user, TopicRoutingRules routingRules, Producer<byte[], byte[]> producer) throws IOException {
        this.conf = conf;
        this.user = user;
        this.pool = pool;
        this.producer = producer;
        this.routingRules = routingRules;
    }

    private void setupRules() throws IOException {
        String file = this.conf.get("kafkaproxy.rule.file");
        this.routingRules = new TopicRoutingRules();
        try (FileInputStream fin = new FileInputStream(file);){
            this.routingRules.parseRules(fin);
        }
    }

    private void startKafkaConnection() throws IOException {
        Properties configProperties = new Properties();
        String kafkaPropsFile = this.conf.get("kafkaproxy.kafka.properties", "");
        if (!StringUtils.isEmpty((CharSequence)kafkaPropsFile)) {
            try (FileInputStream fs = new FileInputStream(new File(kafkaPropsFile));){
                configProperties.load(fs);
            }
        } else {
            String kafkaServers = this.conf.get("kafkaproxy.kafka.brokers");
            configProperties.put("bootstrap.servers", kafkaServers);
        }
        configProperties.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        configProperties.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        this.producer = new KafkaProducer(configProperties);
    }

    public void abort(String why, Throwable e) {
    }

    public boolean isAborted() {
        return false;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public BufferedMutator getBufferedMutator(TableName tableName) throws IOException {
        return null;
    }

    public BufferedMutator getBufferedMutator(BufferedMutatorParams params) throws IOException {
        return null;
    }

    public RegionLocator getRegionLocator(TableName tableName) throws IOException {
        return null;
    }

    public Admin getAdmin() throws IOException {
        return null;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.producer.close();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public TableBuilder getTableBuilder(final TableName tn, ExecutorService pool) {
        if (this.isClosed()) {
            throw new RuntimeException("KafkaBridgeConnection is closed.");
        }
        final Configuration passedInConfiguration = this.getConfiguration();
        return new TableBuilder(){

            public TableBuilder setOperationTimeout(int timeout) {
                return null;
            }

            public TableBuilder setRpcTimeout(int timeout) {
                return null;
            }

            public TableBuilder setReadRpcTimeout(int timeout) {
                return null;
            }

            public TableBuilder setWriteRpcTimeout(int timeout) {
                return null;
            }

            public Table build() {
                return new KafkaTableForBridge(tn, passedInConfiguration, KafkaBridgeConnection.this.routingRules, (Producer<byte[], byte[]>)KafkaBridgeConnection.this.producer, (DatumWriter<HBaseKafkaEvent>)KafkaBridgeConnection.this.avroWriter);
            }
        };
    }
}

