/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic$class;
import org.apache.spark.sql.catalyst.expressions.Shuffle$;
import org.apache.spark.sql.catalyst.expressions.Stateful;
import org.apache.spark.sql.catalyst.expressions.Stateful$class;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.RandomIndicesGenerator;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(array) - Returns a random permutation of the given array.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 20, 3, 5));\n       [3,1,5,20]\n      > SELECT _FUNC_(array(1, 20, null, 3));\n       [20,null,3,1]\n  ", note="The function is non-deterministic.", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\t%c\u0001B\u0001\u0003\u0001>\u0011qa\u00155vM\u001adWM\u0003\u0002\u0004\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)a!\u0001\u0005dCR\fG._:u\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u001d\u0001\u0001\u0003F\f\u001b;\r\u0002\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\u0004\"!E\u000b\n\u0005Y\u0011!!E#ya\u0016\u001cGo]%oaV$H+\u001f9fgB\u0011\u0011\u0003G\u0005\u00033\t\u0011\u0001b\u0015;bi\u00164W\u000f\u001c\t\u0003#mI!\u0001\b\u0002\u00031\u0015C\bO]3tg&|gnV5uQJ\u000bg\u000eZ8n'\u0016,G\r\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sDA\u0004Qe>$Wo\u0019;\u0011\u0005y!\u0013BA\u0013 \u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!9\u0003A!f\u0001\n\u0003A\u0013!B2iS2$W#A\u0015\u0011\u0005EQ\u0013BA\u0016\u0003\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\t[\u0001\u0011\t\u0012)A\u0005S\u000511\r[5mI\u0002B\u0001b\f\u0001\u0003\u0016\u0004%\t\u0001M\u0001\u000be\u0006tGm\\7TK\u0016$W#A\u0019\u0011\u0007y\u0011D'\u0003\u00024?\t1q\n\u001d;j_:\u0004\"AH\u001b\n\u0005Yz\"\u0001\u0002'p]\u001eD\u0001\u0002\u000f\u0001\u0003\u0012\u0003\u0006I!M\u0001\fe\u0006tGm\\7TK\u0016$\u0007\u0005C\u0003;\u0001\u0011\u00051(\u0001\u0004=S:LGO\u0010\u000b\u0004yur\u0004CA\t\u0001\u0011\u00159\u0013\b1\u0001*\u0011\u001dy\u0013\b%AA\u0002EBQA\u000f\u0001\u0005\u0002\u0001#\"\u0001P!\t\u000b\u001dz\u0004\u0019A\u0015\t\u000b\r\u0003A\u0011\t#\u0002\u0017]LG\u000f\u001b(foN+W\r\u001a\u000b\u0003y\u0015CQA\u0012\"A\u0002Q\nAa]3fI\"A\u0001\n\u0001EC\u0002\u0013\u0005\u0013*\u0001\u0005sKN|GN^3e+\u0005Q\u0005C\u0001\u0010L\u0013\tauDA\u0004C_>dW-\u00198\t\u00119\u0003\u0001\u0012!Q!\n)\u000b\u0011B]3t_24X\r\u001a\u0011\t\u000bA\u0003A\u0011I)\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001S!\r\u00196L\u0018\b\u0003)fs!!\u0016-\u000e\u0003YS!a\u0016\b\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0013B\u0001. \u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001X/\u0003\u0007M+\u0017O\u0003\u0002[?A\u0011qLY\u0007\u0002A*\u0011\u0011MB\u0001\u0006if\u0004Xm]\u0005\u0003G\u0002\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\t\u000b\u0015\u0004A\u0011\t4\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012a\u001a\t\u0003?\"L!!\u001b1\u0003\u0011\u0011\u000bG/\u0019+za\u0016D\u0001b\u001b\u0001\t\u0006\u0004%\tAZ\u0001\fK2,W.\u001a8u)f\u0004X\r\u0003\u0005n\u0001!\u0005\t\u0015)\u0003h\u00031)G.Z7f]R$\u0016\u0010]3!Q\taw\u000e\u0005\u0002\u001fa&\u0011\u0011o\b\u0002\niJ\fgn]5f]RD\u0011b\u001d\u0001A\u0002\u0003\u0005\u000b\u0015\u0002;\u0002\rI\fg\u000eZ8n!\t)\b0D\u0001w\u0015\t9H!\u0001\u0003vi&d\u0017BA=w\u0005Y\u0011\u0016M\u001c3p[&sG-[2fg\u001e+g.\u001a:bi>\u0014\bF\u0001:p\u0011\u0015a\b\u0001\"\u0015~\u0003IIg.\u001b;jC2L'0Z%oi\u0016\u0014h.\u00197\u0015\u0007y\f\u0019\u0001\u0005\u0002\u001f\u007f&\u0019\u0011\u0011A\u0010\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u000bY\b\u0019AA\u0004\u00039\u0001\u0018M\u001d;ji&|g.\u00138eKb\u00042AHA\u0005\u0013\r\tYa\b\u0002\u0004\u0013:$\bbBA\b\u0001\u0011E\u0013\u0011C\u0001\rKZ\fG.\u00138uKJt\u0017\r\u001c\u000b\u0005\u0003'\tI\u0002E\u0002\u001f\u0003+I1!a\u0006 \u0005\r\te.\u001f\u0005\t\u00037\ti\u00011\u0001\u0002\u001e\u0005)\u0011N\u001c9viB!\u0011qDA\u0011\u001b\u0005!\u0011bAA\u0012\t\tY\u0011J\u001c;fe:\fGNU8x\u0011\u001d\t9\u0003\u0001C)\u0003S\t\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\r\u0005-\u0012qGA!!\u0011\ti#a\r\u000e\u0005\u0005=\"bAA\u0019\u0005\u000591m\u001c3fO\u0016t\u0017\u0002BA\u001b\u0003_\u0011\u0001\"\u0012=qe\u000e{G-\u001a\u0005\t\u0003s\t)\u00031\u0001\u0002<\u0005\u00191\r\u001e=\u0011\t\u00055\u0012QH\u0005\u0005\u0003\u007f\tyC\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u0011\u0005\r\u0013Q\u0005a\u0001\u0003W\t!!\u001a<\t\u000f\u0005\u001d\u0003\u0001\"\u0003\u0002J\u0005\u00192\u000f[;gM2,\u0017I\u001d:bs\u000e{G-Z$f]RA\u00111JA-\u00037\ni\u0006\u0005\u0003\u0002N\u0005Mcb\u0001\u0010\u0002P%\u0019\u0011\u0011K\u0010\u0002\rA\u0013X\rZ3g\u0013\u0011\t)&a\u0016\u0003\rM#(/\u001b8h\u0015\r\t\tf\b\u0005\t\u0003s\t)\u00051\u0001\u0002<!A\u00111IA#\u0001\u0004\tY\u0003\u0003\u0005\u0002`\u0005\u0015\u0003\u0019AA&\u0003%\u0019\u0007.\u001b7e\u001d\u0006lW\rC\u0004\u0002d\u0001!\t%!\u001a\u0002\u0013\u0019\u0014Xm\u001d5D_BLH#\u0001\u001f\t\u0013\u0005%\u0004!!A\u0005\u0002\u0005-\u0014\u0001B2paf$R\u0001PA7\u0003_B\u0001bJA4!\u0003\u0005\r!\u000b\u0005\t_\u0005\u001d\u0004\u0013!a\u0001c!I\u00111\u000f\u0001\u0012\u0002\u0013\u0005\u0011QO\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t9HK\u0002*\u0003sZ#!a\u001f\u0011\t\u0005u\u0014qQ\u0007\u0003\u0003\u007fRA!!!\u0002\u0004\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000b{\u0012AC1o]>$\u0018\r^5p]&!\u0011\u0011RA@\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003\u001b\u0003\u0011\u0013!C\u0001\u0003\u001f\u000babY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u0012*\u001a\u0011'!\u001f\t\u0013\u0005U\u0005!!A\u0005B\u0005]\u0015!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u001aB!\u00111TAS\u001b\t\tiJ\u0003\u0003\u0002 \u0006\u0005\u0016\u0001\u00027b]\u001eT!!a)\u0002\t)\fg/Y\u0005\u0005\u0003+\ni\nC\u0005\u0002*\u0002\t\t\u0011\"\u0001\u0002,\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u0001\u0005\n\u0003_\u0003\u0011\u0011!C\u0001\u0003c\u000ba\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0014\u0005M\u0006BCA[\u0003[\u000b\t\u00111\u0001\u0002\b\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005e\u0006!!A\u0005B\u0005m\u0016a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005u\u0006CBA`\u0003\u000b\f\u0019\"\u0004\u0002\u0002B*\u0019\u00111Y\u0010\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002H\u0006\u0005'\u0001C%uKJ\fGo\u001c:\t\u0013\u0005-\u0007!!A\u0005\u0002\u00055\u0017\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007)\u000by\r\u0003\u0006\u00026\u0006%\u0017\u0011!a\u0001\u0003'A\u0011\"a5\u0001\u0003\u0003%\t%!6\u0002\r\u0015\fX/\u00197t)\rQ\u0015q\u001b\u0005\u000b\u0003k\u000b\t.!AA\u0002\u0005M\u0001f\u0005\u0001\u0002\\\u0006\u0005\u00181]At\u0003S\fi/a<\u0002t\u0006U\bcA\t\u0002^&\u0019\u0011q\u001c\u0002\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011Q]\u0001A?\u001a+fjQ0)CJ\u0014\u0018-_\u0015![\u0001\u0012V\r^;s]N\u0004\u0013\r\t:b]\u0012|W\u000e\t9fe6,H/\u0019;j_:\u0004sN\u001a\u0011uQ\u0016\u0004s-\u001b<f]\u0002\n'O]1z]\u0005AQ\r_1na2,7/\t\u0002\u0002l\u0006\t\u0019C\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010K\u0019-AI\u0002D\u0006I\u001a-AUJ\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\g1\nD&\u000e\u00173auS\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfD\u0013\u0007\f\u00113a1\u0002c.\u001e7mY\u0001\u001a\u0014&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7J\u0002DF\\;mY2\u001aD&M/\u000bA\u0001\nAA\\8uK\u0006\u0012\u0011\u0011_\u0001#)\",\u0007EZ;oGRLwN\u001c\u0011jg\u0002rwN\\\u0017eKR,'/\\5oSN$\u0018n\u0019\u0018\u0002\u000bMLgnY3\"\u0005\u0005]\u0018!\u0002\u001a/i9\u0002t!CA~\u0005\u0005\u0005\t\u0012AA\u007f\u0003\u001d\u0019\u0006.\u001e4gY\u0016\u00042!EA\u0000\r!\t!!!A\t\u0002\t\u00051#BA\u0000\u0005\u0007\u0019\u0003c\u0002B\u0003\u0005\u0017I\u0013\u0007P\u0007\u0003\u0005\u000fQ1A!\u0003 \u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u0004\u0003\b\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\t\u000fi\ny\u0010\"\u0001\u0003\u0012Q\u0011\u0011Q \u0005\u000b\u0005+\ty0!A\u0005F\t]\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005e\u0005B\u0003B\u000e\u0003\u007f\f\t\u0011\"!\u0003\u001e\u0005)\u0011\r\u001d9msR)AHa\b\u0003\"!1qE!\u0007A\u0002%B\u0001b\fB\r!\u0003\u0005\r!\r\u0005\u000b\u0005K\ty0!A\u0005\u0002\n\u001d\u0012aB;oCB\u0004H.\u001f\u000b\u0005\u0005S\u0011\t\u0004\u0005\u0003\u001fe\t-\u0002#\u0002\u0010\u0003.%\n\u0014b\u0001B\u0018?\t1A+\u001e9mKJB\u0011Ba\r\u0003$\u0005\u0005\t\u0019\u0001\u001f\u0002\u0007a$\u0003\u0007\u0003\u0006\u00038\u0005}\u0018\u0013!C\u0001\u0003\u001f\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0004B\u0003B\u001e\u0003\u007f\f\n\u0011\"\u0001\u0002\u0010\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#\u0007\u0003\u0006\u0003@\u0005}\u0018\u0011!C\u0005\u0005\u0003\n1B]3bIJ+7o\u001c7wKR\u0011!1\t\t\u0005\u00037\u0013)%\u0003\u0003\u0003H\u0005u%AB(cU\u0016\u001cG\u000f")
public class Shuffle
extends UnaryExpression
implements ExpectsInputTypes,
Stateful,
ExpressionWithRandomSeed,
Serializable {
    private final Expression child;
    private final Option<Object> randomSeed;
    private boolean resolved;
    private transient DataType elementType;
    private transient RandomIndicesGenerator random;
    private final boolean deterministic;
    private transient boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Object> apply$default$2() {
        return Shuffle$.MODULE$.apply$default$2();
    }

    public static Option<Object> $lessinit$greater$default$2() {
        return Shuffle$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Object>>> unapply(Shuffle shuffle) {
        return Shuffle$.MODULE$.unapply(shuffle);
    }

    public static Function1<Tuple2<Expression, Option<Object>>, Shuffle> tupled() {
        return Shuffle$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Object>, Shuffle>> curried() {
        return Shuffle$.MODULE$.curried();
    }

    private boolean resolved$lzycompute() {
        Shuffle shuffle = this;
        synchronized (shuffle) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.resolved = this.childrenResolved() && this.checkInputDataTypes().isSuccess() && this.randomSeed().isDefined();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.resolved;
        }
    }

    private DataType elementType$lzycompute() {
        Shuffle shuffle = this;
        synchronized (shuffle) {
            if (!this.bitmap$trans$0) {
                this.elementType = ((ArrayType)this.dataType()).elementType();
                this.bitmap$trans$0 = true;
            }
            return this.elementType;
        }
    }

    @Override
    public boolean fastEquals(TreeNode<?> other) {
        return Stateful$class.fastEquals(this, other);
    }

    private boolean deterministic$lzycompute() {
        Shuffle shuffle = this;
        synchronized (shuffle) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.deterministic = Nondeterministic$class.deterministic(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.deterministic;
        }
    }

    @Override
    public final boolean deterministic() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.deterministic$lzycompute() : this.deterministic;
    }

    @Override
    public boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized() {
        return this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized_$eq(boolean x$1) {
        this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized = x$1;
    }

    @Override
    public final boolean foldable() {
        return Nondeterministic$class.foldable(this);
    }

    @Override
    public final void initialize(int partitionIndex) {
        Nondeterministic$class.initialize(this, partitionIndex);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Nondeterministic$class.eval(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Nondeterministic$class.eval$default$1(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public Option<Object> randomSeed() {
        return this.randomSeed;
    }

    @Override
    public Shuffle withNewSeed(long seed) {
        Some x$82 = new Some((Object)BoxesRunTime.boxToLong((long)seed));
        Expression x$83 = this.copy$default$1();
        return this.copy(x$83, (Option<Object>)x$82);
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayType$[]{ArrayType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    public DataType elementType() {
        return this.bitmap$trans$0 ? this.elementType : this.elementType$lzycompute();
    }

    @Override
    public void initializeInternal(int partitionIndex) {
        this.random = new RandomIndicesGenerator(BoxesRunTime.unboxToLong((Object)this.randomSeed().get()) + (long)partitionIndex);
    }

    @Override
    public Object evalInternal(InternalRow input) {
        GenericArrayData genericArrayData;
        Object value2 = this.child().eval(input);
        if (value2 == null) {
            genericArrayData = null;
        } else {
            ArrayData source = (ArrayData)value2;
            int numElements = source.numElements();
            int[] indices = this.random.getNextIndices(numElements);
            genericArrayData = new GenericArrayData(Predef$.MODULE$.intArrayOps(indices).map((Function1)new Serializable(this, source){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Shuffle $outer;
                private final ArrayData source$1;

                public final Object apply(int x$24) {
                    return this.source$1.get(x$24, this.$outer.elementType());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.source$1 = source$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Object())));
        }
        return genericArrayData;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)new Serializable(this, ctx, ev){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Shuffle $outer;
            private final CodegenContext ctx$6;
            private final ExprCode ev$6;

            public final String apply(String c) {
                return this.$outer.org$apache$spark$sql$catalyst$expressions$Shuffle$$shuffleArrayCodeGen(this.ctx$6, this.ev$6, c);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ctx$6 = ctx$6;
                this.ev$6 = ev$6;
            }
        });
    }

    public String org$apache$spark$sql$catalyst$expressions$Shuffle$$shuffleArrayCodeGen(CodegenContext ctx, ExprCode ev, String childName) {
        String randomClass;
        String x$84 = randomClass = RandomIndicesGenerator.class.getName();
        String x$85 = "rand";
        boolean x$86 = true;
        Function1<String, String> x$87 = ctx.addMutableState$default$3();
        boolean x$88 = ctx.addMutableState$default$5();
        String rand = ctx.addMutableState(x$84, x$85, x$87, x$86, x$88);
        ctx.addPartitionInitializationStatement(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = new ", "(", "L + partitionIndex);"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rand, randomClass, this.randomSeed().get()})));
        String numElements = ctx.freshName("numElements");
        String arrayData = ctx.freshName("arrayData");
        String indices = ctx.freshName("indices");
        String i = ctx.freshName("i");
        String initialization = CodeGenerator$.MODULE$.createArrayData(arrayData, this.elementType(), numElements, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " failed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prettyName()})));
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(arrayData, this.elementType(), childName, i, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{indices, i})), ((ArrayType)this.dataType()).containsNull());
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |int ", " = ", ".numElements();\n       |int[] ", " = ", ".getNextIndices(", ");\n       |", "\n       |for (int ", " = 0; ", " < ", "; ", "++) {\n       |  ", "\n       |}\n       |", " = ", ";\n     "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{numElements, childName, indices, rand, numElements, initialization, i, i, numElements, i, assignment, ev.value(), arrayData})))).stripMargin();
    }

    @Override
    public Shuffle freshCopy() {
        return new Shuffle(this.child(), this.randomSeed());
    }

    public Shuffle copy(Expression child, Option<Object> randomSeed) {
        return new Shuffle(child, randomSeed);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Option<Object> copy$default$2() {
        return this.randomSeed();
    }

    @Override
    public String productPrefix() {
        return "Shuffle";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                object = this.randomSeed();
                break;
            }
            case 0: {
                object = this.child();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Shuffle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Shuffle)) return false;
        boolean bl = true;
        if (!bl) return false;
        Shuffle shuffle = (Shuffle)x$1;
        Expression expression = this.child();
        Expression expression2 = shuffle.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Object> option = this.randomSeed();
        Option<Object> option2 = shuffle.randomSeed();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!shuffle.canEqual(this)) return false;
        return true;
    }

    public Shuffle(Expression child, Option<Object> randomSeed) {
        this.child = child;
        this.randomSeed = randomSeed;
        ExpectsInputTypes$class.$init$(this);
        Nondeterministic$class.$init$(this);
        Stateful$class.$init$(this);
    }

    public Shuffle(Expression child) {
        this(child, (Option<Object>)None$.MODULE$);
    }
}

