/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark.example.hbasecontext;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.spark.HBaseContext;
import org.apache.hadoop.hbase.spark.HBaseContext$;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.yetus.audience.InterfaceAudience;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@InterfaceAudience.Private
public final class HBaseDistributedScanExample$ {
    public static final HBaseDistributedScanExample$ MODULE$;

    static {
        new HBaseDistributedScanExample$();
    }

    /*
     * WARNING - void declaration
     */
    public void main(String[] args) {
        if (args.length < 1) {
            Predef$.MODULE$.println((Object)"HBaseDistributedScanExample {tableName} missing an argument");
            return;
        }
        String tableName = args[0];
        SparkConf sparkConf = new SparkConf().setAppName(new StringBuilder().append((Object)"HBaseDistributedScanExample ").append((Object)tableName).toString());
        SparkContext sc = new SparkContext(sparkConf);
        try {
            Configuration conf = HBaseConfiguration.create();
            HBaseContext hbaseContext = new HBaseContext(sc, conf, HBaseContext$.MODULE$.$lessinit$greater$default$3());
            Scan scan = new Scan();
            scan.setCaching(100);
            RDD<Tuple2<ImmutableBytesWritable, Result>> getRdd = hbaseContext.hbaseRDD(TableName.valueOf((String)tableName), scan);
            getRdd.foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<ImmutableBytesWritable, Result> v) {
                    Predef$.MODULE$.println((Object)Bytes.toString((byte[])((ImmutableBytesWritable)v._1()).get()));
                }
            });
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Length: ").append((Object)BoxesRunTime.boxToInteger((int)((byte[][])getRdd.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final byte[] apply(Tuple2<ImmutableBytesWritable, Result> r) {
                    return ((ImmutableBytesWritable)r._1()).copyBytes();
                }
            }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))).collect()).length)).toString());
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.stop();
            throw throwable;
        }
        sc.stop();
    }

    private HBaseDistributedScanExample$() {
        MODULE$ = this;
    }
}

