/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark.example.hbasecontext;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.spark.HBaseContext;
import org.apache.hadoop.hbase.spark.HBaseContext$;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.yetus.audience.InterfaceAudience;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;

@InterfaceAudience.Private
public final class HBaseBulkPutExampleFromFile$ {
    public static final HBaseBulkPutExampleFromFile$ MODULE$;

    static {
        new HBaseBulkPutExampleFromFile$();
    }

    /*
     * WARNING - void declaration
     */
    public void main(String[] args) {
        if (args.length < 3) {
            Predef$.MODULE$.println((Object)"HBaseBulkPutExampleFromFile {tableName} {columnFamily} {inputFile} are missing an argument");
            return;
        }
        String tableName = args[0];
        String columnFamily = args[1];
        String inputFile = args[2];
        SparkConf sparkConf = new SparkConf().setAppName(new StringBuilder().append((Object)"HBaseBulkPutExampleFromFile ").append((Object)tableName).append((Object)" ").append((Object)columnFamily).append((Object)" ").append((Object)inputFile).toString());
        SparkContext sc = new SparkContext(sparkConf);
        try {
            RDD rdd = sc.hadoopFile(inputFile, TextInputFormat.class, LongWritable.class, Text.class, sc.hadoopFile$default$5()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<LongWritable, Text> v) {
                    System.out.println(new StringBuilder().append((Object)"reading-").append((Object)((Text)v._2()).toString()).toString());
                    return ((Text)v._2()).toString();
                }
            }, ClassTag$.MODULE$.apply(String.class));
            Configuration conf = HBaseConfiguration.create();
            HBaseContext hbaseContext = new HBaseContext(sc, conf, HBaseContext$.MODULE$.$lessinit$greater$default$3());
            hbaseContext.bulkPut(rdd, TableName.valueOf((String)tableName), new Serializable(){
                public static final long serialVersionUID = 0L;

                /*
                 * WARNING - void declaration
                 */
                public final Put apply(String putRecord) {
                    void var2_2;
                    System.out.println(new StringBuilder().append((Object)"hbase-").append((Object)putRecord).toString());
                    Put put = new Put(Bytes.toBytes((String)new StringBuilder().append((Object)"Value- ").append((Object)putRecord).toString()));
                    put.addColumn(Bytes.toBytes((String)"c"), Bytes.toBytes((String)"1"), Bytes.toBytes((int)putRecord.length()));
                    return var2_2;
                }
            });
        }
        catch (Throwable throwable) {
            void var6_6;
            var6_6.stop();
            throw throwable;
        }
        sc.stop();
    }

    private HBaseBulkPutExampleFromFile$() {
        MODULE$ = this;
    }
}

