/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.assignment.MoveRegionProcedure;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ReopenTableRegionsProcedure
extends AbstractStateMachineTableProcedure<MasterProcedureProtos.ReopenTableRegionsState> {
    private static final Logger LOG = LoggerFactory.getLogger(ReopenTableRegionsProcedure.class);
    private TableName tableName;
    private List<HRegionLocation> regions = Collections.emptyList();

    public ReopenTableRegionsProcedure() {
    }

    public ReopenTableRegionsProcedure(TableName tableName) {
        this.tableName = tableName;
    }

    @Override
    public TableName getTableName() {
        return this.tableName;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.REGION_EDIT;
    }

    private MoveRegionProcedure createReopenProcedure(MasterProcedureEnv env, HRegionLocation loc) {
        try {
            return new MoveRegionProcedure(env, new RegionPlan(loc.getRegion(), loc.getServerName(), loc.getServerName()), false);
        }
        catch (HBaseIOException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.ReopenTableRegionsState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        switch (state) {
            case REOPEN_TABLE_REGIONS_GET_REGIONS: {
                if (!env.getAssignmentManager().isTableEnabled(this.tableName)) {
                    LOG.info("Table {} is disabled, give up reopening its regions");
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                this.regions = env.getAssignmentManager().getRegionStates().getRegionsOfTableForReopen(this.tableName);
                this.setNextState(MasterProcedureProtos.ReopenTableRegionsState.REOPEN_TABLE_REGIONS_REOPEN_REGIONS);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case REOPEN_TABLE_REGIONS_REOPEN_REGIONS: {
                this.addChildProcedure((Procedure[])this.regions.stream().filter(l -> l.getSeqNum() >= 0L).map(l -> this.createReopenProcedure(env, (HRegionLocation)l)).toArray(MoveRegionProcedure[]::new));
                this.setNextState(MasterProcedureProtos.ReopenTableRegionsState.REOPEN_TABLE_REGIONS_CONFIRM_REOPENED);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case REOPEN_TABLE_REGIONS_CONFIRM_REOPENED: {
                this.regions = this.regions.stream().map(env.getAssignmentManager().getRegionStates()::checkReopened).filter(l -> l != null).collect(Collectors.toList());
                if (this.regions.isEmpty()) {
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                if (this.regions.stream().anyMatch(l -> l.getSeqNum() >= 0L)) {
                    this.setNextState(MasterProcedureProtos.ReopenTableRegionsState.REOPEN_TABLE_REGIONS_REOPEN_REGIONS);
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                LOG.info("There are still {} region(s) which need to be reopened for table {} are in OPENING state, try again later", (Object)this.regions.size(), (Object)this.tableName);
                Thread.sleep(1000L);
                throw new ProcedureYieldException();
            }
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.ReopenTableRegionsState state) throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    protected MasterProcedureProtos.ReopenTableRegionsState getState(int stateId) {
        return MasterProcedureProtos.ReopenTableRegionsState.forNumber((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.ReopenTableRegionsState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.ReopenTableRegionsState getInitialState() {
        return MasterProcedureProtos.ReopenTableRegionsState.REOPEN_TABLE_REGIONS_GET_REGIONS;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.ReopenTableRegionsStateData.Builder builder = MasterProcedureProtos.ReopenTableRegionsStateData.newBuilder().setTableName(ProtobufUtil.toProtoTableName((TableName)this.tableName));
        this.regions.stream().map(ProtobufUtil::toRegionLocation).forEachOrdered(arg_0 -> ((MasterProcedureProtos.ReopenTableRegionsStateData.Builder)builder).addRegion(arg_0));
        serializer.serialize((Message)builder.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.ReopenTableRegionsStateData data = (MasterProcedureProtos.ReopenTableRegionsStateData)serializer.deserialize(MasterProcedureProtos.ReopenTableRegionsStateData.class);
        this.tableName = ProtobufUtil.toTableName((HBaseProtos.TableName)data.getTableName());
        this.regions = data.getRegionList().stream().map(ProtobufUtil::toRegionLocation).collect(Collectors.toList());
    }
}

