/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public interface ReplicationQueueStorage {
    public void removeQueue(ServerName var1, String var2) throws ReplicationException;

    public void addWAL(ServerName var1, String var2, String var3) throws ReplicationException;

    public void removeWAL(ServerName var1, String var2, String var3) throws ReplicationException;

    public void setWALPosition(ServerName var1, String var2, String var3, long var4, Map<String, Long> var6) throws ReplicationException;

    public long getLastSequenceId(String var1, String var2) throws ReplicationException;

    public void setLastSequenceIds(String var1, Map<String, Long> var2) throws ReplicationException;

    public void removeLastSequenceIds(String var1) throws ReplicationException;

    public void removeLastSequenceIds(String var1, List<String> var2) throws ReplicationException;

    public long getWALPosition(ServerName var1, String var2, String var3) throws ReplicationException;

    public List<String> getWALsInQueue(ServerName var1, String var2) throws ReplicationException;

    public List<String> getAllQueues(ServerName var1) throws ReplicationException;

    public Pair<String, SortedSet<String>> claimQueue(ServerName var1, String var2, ServerName var3) throws ReplicationException;

    public void removeReplicatorIfQueueIsEmpty(ServerName var1) throws ReplicationException;

    public List<ServerName> getListOfReplicators() throws ReplicationException;

    public Set<String> getAllWALs() throws ReplicationException;

    public void addPeerToHFileRefs(String var1) throws ReplicationException;

    public void removePeerFromHFileRefs(String var1) throws ReplicationException;

    public void addHFileRefs(String var1, List<Pair<Path, Path>> var2) throws ReplicationException;

    public void removeHFileRefs(String var1, List<String> var2) throws ReplicationException;

    public List<String> getAllPeersFromHFileRefsQueue() throws ReplicationException;

    public List<String> getReplicableHFiles(String var1) throws ReplicationException;

    public Set<String> getAllHFileRefs() throws ReplicationException;
}

