/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.ApplicationHistoryProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.webproxy.AppReportFetcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestAppReportFetcher {
    static ApplicationHistoryProtocol historyManager;
    static Configuration conf;
    private static ApplicationClientProtocol appManager;
    private static AppReportFetcher fetcher;
    private final String appNotFoundExceptionMsg = "APP NOT FOUND";

    @After
    public void cleanUp() {
        historyManager = null;
        appManager = null;
        fetcher = null;
    }

    public void testHelper(boolean isAHSEnabled) throws YarnException, IOException {
        conf.setBoolean("yarn.timeline-service.generic-application-history.enabled", isAHSEnabled);
        appManager = (ApplicationClientProtocol)Mockito.mock(ApplicationClientProtocol.class);
        Mockito.when((Object)appManager.getApplicationReport((GetApplicationReportRequest)Mockito.any(GetApplicationReportRequest.class))).thenThrow(new Throwable[]{new ApplicationNotFoundException("APP NOT FOUND")});
        fetcher = new AppReportFetcherForTest(conf, appManager);
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)0);
        fetcher.getApplicationReport(appId);
    }

    @Test
    public void testFetchReportAHSEnabled() throws YarnException, IOException {
        this.testHelper(true);
        ((ApplicationHistoryProtocol)Mockito.verify((Object)historyManager, (VerificationMode)Mockito.times((int)1))).getApplicationReport((GetApplicationReportRequest)Mockito.any(GetApplicationReportRequest.class));
        ((ApplicationClientProtocol)Mockito.verify((Object)appManager, (VerificationMode)Mockito.times((int)1))).getApplicationReport((GetApplicationReportRequest)Mockito.any(GetApplicationReportRequest.class));
    }

    @Test
    public void testFetchReportAHSDisabled() throws YarnException, IOException {
        try {
            this.testHelper(false);
        }
        catch (ApplicationNotFoundException e) {
            Assert.assertTrue((e.getMessage() == "APP NOT FOUND" ? 1 : 0) != 0);
        }
        ((ApplicationClientProtocol)Mockito.verify((Object)appManager, (VerificationMode)Mockito.times((int)1))).getApplicationReport((GetApplicationReportRequest)Mockito.any(GetApplicationReportRequest.class));
        if (historyManager != null) {
            Assert.fail((String)"HistoryManager should be null as AHS is disabled");
        }
    }

    static {
        conf = new Configuration();
    }

    static class AppReportFetcherForTest
    extends AppReportFetcher {
        public AppReportFetcherForTest(Configuration conf, ApplicationClientProtocol acp) {
            super(conf, acp);
        }

        protected ApplicationHistoryProtocol getAHSProxy(Configuration conf) throws IOException {
            GetApplicationReportResponse resp = (GetApplicationReportResponse)Mockito.mock(GetApplicationReportResponse.class);
            historyManager = (ApplicationHistoryProtocol)Mockito.mock(ApplicationHistoryProtocol.class);
            try {
                Mockito.when((Object)historyManager.getApplicationReport((GetApplicationReportRequest)Mockito.any(GetApplicationReportRequest.class))).thenReturn((Object)resp);
            }
            catch (YarnException e) {
                e.printStackTrace();
            }
            return historyManager;
        }
    }
}

