/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.ClientRMProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.exceptions.YarnRemoteException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;

public class AppReportFetcher {
    private static final Log LOG = LogFactory.getLog(AppReportFetcher.class);
    private final Configuration conf;
    private final ClientRMProtocol applicationsManager;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    public AppReportFetcher(Configuration conf) {
        this.conf = conf;
        YarnRPC rpc = YarnRPC.create((Configuration)this.conf);
        InetSocketAddress rmAddress = conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
        LOG.info((Object)("Connecting to ResourceManager at " + rmAddress));
        this.applicationsManager = (ClientRMProtocol)rpc.getProxy(ClientRMProtocol.class, rmAddress, this.conf);
        LOG.info((Object)("Connected to ResourceManager at " + rmAddress));
    }

    public AppReportFetcher(Configuration conf, ClientRMProtocol applicationsManager) {
        this.conf = conf;
        this.applicationsManager = applicationsManager;
    }

    public ApplicationReport getApplicationReport(ApplicationId appId) throws YarnRemoteException {
        GetApplicationReportRequest request = (GetApplicationReportRequest)this.recordFactory.newRecordInstance(GetApplicationReportRequest.class);
        request.setApplicationId(appId);
        GetApplicationReportResponse response = this.applicationsManager.getApplicationReport(request);
        return response.getApplicationReport();
    }
}

