/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.sharedcachemanager.metrics;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.sharedcachemanager.metrics.CleanerMetrics;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCleanerMetrics {
    Configuration conf = new Configuration();
    CleanerMetrics cleanerMetrics;

    @Before
    public void init() {
        this.cleanerMetrics = CleanerMetrics.getInstance();
    }

    @Test
    public void testMetricsOverMultiplePeriods() {
        this.simulateACleanerRun();
        this.assertMetrics(4, 4, 1, 1);
        this.simulateACleanerRun();
        this.assertMetrics(4, 8, 1, 2);
    }

    public void simulateACleanerRun() {
        this.cleanerMetrics.reportCleaningStart();
        this.cleanerMetrics.reportAFileProcess();
        this.cleanerMetrics.reportAFileDelete();
        this.cleanerMetrics.reportAFileProcess();
        this.cleanerMetrics.reportAFileProcess();
    }

    void assertMetrics(int proc, int totalProc, int del, int totalDel) {
        Assert.assertEquals((String)"Processed files in the last period are not measured correctly", (long)proc, (long)this.cleanerMetrics.getProcessedFiles());
        Assert.assertEquals((String)"Total processed files are not measured correctly", (long)totalProc, (long)this.cleanerMetrics.getTotalProcessedFiles());
        Assert.assertEquals((String)"Deleted files in the last period are not measured correctly", (long)del, (long)this.cleanerMetrics.getDeletedFiles());
        Assert.assertEquals((String)"Total deleted files are not measured correctly", (long)totalDel, (long)this.cleanerMetrics.getTotalDeletedFiles());
    }
}

