/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.applications.distributedshell;

import com.google.common.annotations.VisibleForTesting;
import com.sun.jersey.api.client.ClientHandlerException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerRetryPolicy;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntityGroupId;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.applications.distributedshell.ApplicationMaster;
import org.apache.hadoop.yarn.applications.distributedshell.Log4jPropertyHelper;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.TimelineClient;
import org.apache.hadoop.yarn.client.api.TimelineV2Client;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.client.api.async.NMClientAsync;
import org.apache.hadoop.yarn.client.api.async.impl.NMClientAsyncImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.util.TimelineServiceHelper;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;
import org.apache.log4j.LogManager;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class ApplicationMaster {
    private static final Log LOG = LogFactory.getLog(ApplicationMaster.class);
    private static final String YARN_SHELL_ID = "YARN_SHELL_ID";
    private Configuration conf;
    private AMRMClientAsync amRMClient;
    @VisibleForTesting
    UserGroupInformation appSubmitterUgi;
    private NMClientAsync nmClientAsync;
    private NMCallbackHandler containerListener;
    @VisibleForTesting
    protected ApplicationAttemptId appAttemptID;
    private String appMasterHostname = "";
    private int appMasterRpcPort = -1;
    private String appMasterTrackingUrl = "";
    private boolean timelineServiceV2Enabled = false;
    private boolean timelineServiceV1Enabled = false;
    @VisibleForTesting
    protected int numTotalContainers = 1;
    private long containerMemory = 10L;
    private int containerVirtualCores = 1;
    private int requestPriority;
    private AtomicInteger numCompletedContainers = new AtomicInteger();
    @VisibleForTesting
    protected AtomicInteger numAllocatedContainers = new AtomicInteger();
    private AtomicInteger numFailedContainers = new AtomicInteger();
    @VisibleForTesting
    protected AtomicInteger numRequestedContainers = new AtomicInteger();
    private String shellCommand = "";
    private String shellArgs = "";
    private Map<String, String> shellEnv = new HashMap();
    private String scriptPath = "";
    private long shellScriptPathTimestamp = 0L;
    private long shellScriptPathLen = 0L;
    private ContainerRetryPolicy containerRetryPolicy = ContainerRetryPolicy.NEVER_RETRY;
    private Set<Integer> containerRetryErrorCodes = null;
    private int containerMaxRetries = 0;
    private int containrRetryInterval = 0;
    private String domainId = null;
    private static final String EXEC_SHELL_STRING_PATH = "ExecScript.sh";
    private static final String EXEC_BAT_SCRIPT_STRING_PATH = "ExecScript.bat";
    private static final String log4jPath = "log4j.properties";
    private static final String shellCommandPath = "shellCommands";
    private static final String shellArgsPath = "shellArgs";
    private volatile boolean done;
    private ByteBuffer allTokens;
    private List<Thread> launchThreads = new ArrayList();
    @VisibleForTesting
    TimelineClient timelineClient;
    @VisibleForTesting
    TimelineV2Client timelineV2Client;
    static final String CONTAINER_ENTITY_GROUP_ID = "CONTAINERS";
    static final String APPID_TIMELINE_FILTER_NAME = "appId";
    static final String USER_TIMELINE_FILTER_NAME = "user";
    private final String linux_bash_command = "bash";
    private final String windows_command = "cmd /c";
    private int yarnShellIdCounter = 1;
    @VisibleForTesting
    protected final Set<ContainerId> launchedContainers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ConcurrentMap<ContainerId, Long> containerStartTimes = new ConcurrentHashMap();

    private ConcurrentMap<ContainerId, Long> getContainerStartTimes() {
        return this.containerStartTimes;
    }

    public static void main(String[] args) {
        boolean result = false;
        try {
            ApplicationMaster appMaster = new ApplicationMaster();
            LOG.info((Object)"Initializing ApplicationMaster");
            boolean doRun = appMaster.init(args);
            if (!doRun) {
                System.exit(0);
            }
            appMaster.run();
            result = appMaster.finish();
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error running ApplicationMaster", t);
            LogManager.shutdown();
            ExitUtil.terminate((int)1, (Throwable)t);
        }
        if (result) {
            LOG.info((Object)"Application Master completed successfully. exiting");
            System.exit(0);
        } else {
            LOG.info((Object)"Application Master failed. exiting");
            System.exit(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpOutDebugInfo() {
        LOG.info((Object)"Dump debug output");
        Map<String, String> envs = System.getenv();
        for (Map.Entry<String, String> env : envs.entrySet()) {
            LOG.info((Object)("System env: key=" + env.getKey() + ", val=" + env.getValue()));
            System.out.println("System env: key=" + env.getKey() + ", val=" + env.getValue());
        }
        BufferedReader buf = null;
        try {
            String lines = Shell.WINDOWS ? Shell.execCommand((String[])new String[]{"cmd", "/c", "dir"}) : Shell.execCommand((String[])new String[]{"ls", "-al"});
            buf = new BufferedReader(new StringReader(lines));
            String line = "";
            while ((line = buf.readLine()) != null) {
                LOG.info((Object)("System CWD content: " + line));
                System.out.println("System CWD content: " + line);
            }
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                org.apache.hadoop.io.IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{buf});
                throw throwable;
            }
            org.apache.hadoop.io.IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{buf});
        }
        org.apache.hadoop.io.IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{buf});
    }

    public ApplicationMaster() {
        this.conf = new YarnConfiguration();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean init(String[] args) throws ParseException, IOException {
        Map<String, String> envs;
        Options opts = new Options();
        opts.addOption("app_attempt_id", true, "App Attempt ID. Not to be used unless for testing purposes");
        opts.addOption("shell_env", true, "Environment for shell script. Specified as env_key=env_val pairs");
        opts.addOption("container_memory", true, "Amount of memory in MB to be requested to run the shell command");
        opts.addOption("container_vcores", true, "Amount of virtual cores to be requested to run the shell command");
        opts.addOption("num_containers", true, "No. of containers on which the shell command needs to be executed");
        opts.addOption("priority", true, "Application Priority. Default 0");
        opts.addOption("container_retry_policy", true, "Retry policy when container fails to run, 0: NEVER_RETRY, 1: RETRY_ON_ALL_ERRORS, 2: RETRY_ON_SPECIFIC_ERROR_CODES");
        opts.addOption("container_retry_error_codes", true, "When retry policy is set to RETRY_ON_SPECIFIC_ERROR_CODES, error codes is specified with this option, e.g. --container_retry_error_codes 1,2,3");
        opts.addOption("container_max_retries", true, "If container could retry, it specifies max retires");
        opts.addOption("container_retry_interval", true, "Interval between each retry, unit is milliseconds");
        opts.addOption("debug", false, "Dump out debug information");
        opts.addOption("help", false, "Print usage");
        CommandLine cliParser = new GnuParser().parse(opts, args);
        if (args.length == 0) {
            this.printUsage(opts);
            throw new IllegalArgumentException("No args specified for application master to initialize");
        }
        if (this.fileExist(log4jPath)) {
            try {
                Log4jPropertyHelper.updateLog4jConfiguration(ApplicationMaster.class, (String)log4jPath);
            }
            catch (Exception e) {
                LOG.warn((Object)("Can not set up custom log4j properties. " + e));
            }
        }
        if (cliParser.hasOption("help")) {
            this.printUsage(opts);
            return false;
        }
        if (cliParser.hasOption("debug")) {
            this.dumpOutDebugInfo();
        }
        if (!(envs = System.getenv()).containsKey(ApplicationConstants.Environment.CONTAINER_ID.name())) {
            if (!cliParser.hasOption("app_attempt_id")) throw new IllegalArgumentException("Application Attempt Id not set in the environment");
            String appIdStr = cliParser.getOptionValue("app_attempt_id", "");
            this.appAttemptID = ApplicationAttemptId.fromString((String)appIdStr);
        } else {
            ContainerId containerId = ContainerId.fromString((String)envs.get(ApplicationConstants.Environment.CONTAINER_ID.name()));
            this.appAttemptID = containerId.getApplicationAttemptId();
        }
        if (!envs.containsKey("APP_SUBMIT_TIME_ENV")) {
            throw new RuntimeException("APP_SUBMIT_TIME_ENV not set in the environment");
        }
        if (!envs.containsKey(ApplicationConstants.Environment.NM_HOST.name())) {
            throw new RuntimeException(ApplicationConstants.Environment.NM_HOST.name() + " not set in the environment");
        }
        if (!envs.containsKey(ApplicationConstants.Environment.NM_HTTP_PORT.name())) {
            throw new RuntimeException(ApplicationConstants.Environment.NM_HTTP_PORT + " not set in the environment");
        }
        if (!envs.containsKey(ApplicationConstants.Environment.NM_PORT.name())) {
            throw new RuntimeException(ApplicationConstants.Environment.NM_PORT.name() + " not set in the environment");
        }
        LOG.info((Object)("Application master for app, appId=" + this.appAttemptID.getApplicationId().getId() + ", clustertimestamp=" + this.appAttemptID.getApplicationId().getClusterTimestamp() + ", attemptId=" + this.appAttemptID.getAttemptId()));
        if (!this.fileExist(shellCommandPath) && envs.get("DISTRIBUTEDSHELLSCRIPTLOCATION").isEmpty()) {
            throw new IllegalArgumentException("No shell command or shell script specified to be executed by application master");
        }
        if (this.fileExist(shellCommandPath)) {
            this.shellCommand = this.readContent(shellCommandPath);
        }
        if (this.fileExist(shellArgsPath)) {
            this.shellArgs = this.readContent(shellArgsPath);
        }
        if (cliParser.hasOption("shell_env")) {
            String[] shellEnvs;
            for (String env : shellEnvs = cliParser.getOptionValues("shell_env")) {
                int index = (env = env.trim()).indexOf(61);
                if (index == -1) {
                    this.shellEnv.put(env, "");
                    continue;
                }
                String key = env.substring(0, index);
                String val = "";
                if (index < env.length() - 1) {
                    val = env.substring(index + 1);
                }
                this.shellEnv.put(key, val);
            }
        }
        if (envs.containsKey("DISTRIBUTEDSHELLSCRIPTLOCATION")) {
            this.scriptPath = envs.get("DISTRIBUTEDSHELLSCRIPTLOCATION");
            if (envs.containsKey("DISTRIBUTEDSHELLSCRIPTTIMESTAMP")) {
                this.shellScriptPathTimestamp = Long.parseLong(envs.get("DISTRIBUTEDSHELLSCRIPTTIMESTAMP"));
            }
            if (envs.containsKey("DISTRIBUTEDSHELLSCRIPTLEN")) {
                this.shellScriptPathLen = Long.parseLong(envs.get("DISTRIBUTEDSHELLSCRIPTLEN"));
            }
            if (!(this.scriptPath.isEmpty() || this.shellScriptPathTimestamp > 0L && this.shellScriptPathLen > 0L)) {
                LOG.error((Object)("Illegal values in env for shell script path, path=" + this.scriptPath + ", len=" + this.shellScriptPathLen + ", timestamp=" + this.shellScriptPathTimestamp));
                throw new IllegalArgumentException("Illegal values in env for shell script path");
            }
        }
        if (envs.containsKey("DISTRIBUTEDSHELLTIMELINEDOMAIN")) {
            this.domainId = envs.get("DISTRIBUTEDSHELLTIMELINEDOMAIN");
        }
        this.containerMemory = Integer.parseInt(cliParser.getOptionValue("container_memory", "10"));
        this.containerVirtualCores = Integer.parseInt(cliParser.getOptionValue("container_vcores", "1"));
        this.numTotalContainers = Integer.parseInt(cliParser.getOptionValue("num_containers", "1"));
        if (this.numTotalContainers == 0) {
            throw new IllegalArgumentException("Cannot run distributed shell with no containers");
        }
        this.requestPriority = Integer.parseInt(cliParser.getOptionValue("priority", "0"));
        this.containerRetryPolicy = ContainerRetryPolicy.values()[Integer.parseInt(cliParser.getOptionValue("container_retry_policy", "0"))];
        if (cliParser.hasOption("container_retry_error_codes")) {
            this.containerRetryErrorCodes = new HashSet();
            for (String errorCode : cliParser.getOptionValue("container_retry_error_codes").split(",")) {
                this.containerRetryErrorCodes.add(Integer.parseInt(errorCode));
            }
        }
        this.containerMaxRetries = Integer.parseInt(cliParser.getOptionValue("container_max_retries", "0"));
        this.containrRetryInterval = Integer.parseInt(cliParser.getOptionValue("container_retry_interval", "0"));
        if (YarnConfiguration.timelineServiceEnabled((Configuration)this.conf)) return true;
        this.timelineClient = null;
        this.timelineV2Client = null;
        LOG.warn((Object)"Timeline service is not enabled");
        return true;
    }

    private void printUsage(Options opts) {
        new HelpFormatter().printHelp("ApplicationMaster", opts);
    }

    public void run() throws YarnException, IOException, InterruptedException {
        LOG.info((Object)"Starting ApplicationMaster");
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        DataOutputBuffer dob = new DataOutputBuffer();
        credentials.writeTokenStorageToStream((DataOutputStream)dob);
        Iterator iter = credentials.getAllTokens().iterator();
        LOG.info((Object)"Executing with tokens:");
        while (iter.hasNext()) {
            Token token = (Token)iter.next();
            LOG.info((Object)token);
            if (!token.getKind().equals((Object)AMRMTokenIdentifier.KIND_NAME)) continue;
            iter.remove();
        }
        this.allTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        String appSubmitterUserName = System.getenv(ApplicationConstants.Environment.USER.name());
        this.appSubmitterUgi = UserGroupInformation.createRemoteUser((String)appSubmitterUserName);
        this.appSubmitterUgi.addCredentials(credentials);
        RMCallbackHandler allocListener = new RMCallbackHandler(this);
        this.amRMClient = AMRMClientAsync.createAMRMClientAsync((int)1000, (AMRMClientAsync.AbstractCallbackHandler)allocListener);
        this.amRMClient.init(this.conf);
        this.amRMClient.start();
        this.containerListener = this.createNMCallbackHandler();
        this.nmClientAsync = new NMClientAsyncImpl((NMClientAsync.AbstractCallbackHandler)this.containerListener);
        this.nmClientAsync.init(this.conf);
        this.nmClientAsync.start();
        this.startTimelineClient(this.conf);
        if (this.timelineServiceV2Enabled) {
            this.amRMClient.registerTimelineV2Client(this.timelineV2Client);
            this.publishApplicationAttemptEventOnTimelineServiceV2(DSEvent.DS_APP_ATTEMPT_START);
        }
        if (this.timelineServiceV1Enabled) {
            this.publishApplicationAttemptEvent(this.timelineClient, this.appAttemptID.toString(), DSEvent.DS_APP_ATTEMPT_START, this.domainId, this.appSubmitterUgi);
        }
        this.appMasterHostname = NetUtils.getHostname();
        RegisterApplicationMasterResponse response = this.amRMClient.registerApplicationMaster(this.appMasterHostname, this.appMasterRpcPort, this.appMasterTrackingUrl);
        long maxMem = response.getMaximumResourceCapability().getMemorySize();
        LOG.info((Object)("Max mem capability of resources in this cluster " + maxMem));
        int maxVCores = response.getMaximumResourceCapability().getVirtualCores();
        LOG.info((Object)("Max vcores capability of resources in this cluster " + maxVCores));
        if (this.containerMemory > maxMem) {
            LOG.info((Object)("Container memory specified above max threshold of cluster. Using max value., specified=" + this.containerMemory + ", max=" + maxMem));
            this.containerMemory = maxMem;
        }
        if (this.containerVirtualCores > maxVCores) {
            LOG.info((Object)("Container virtual cores specified above max threshold of cluster. Using max value., specified=" + this.containerVirtualCores + ", max=" + maxVCores));
            this.containerVirtualCores = maxVCores;
        }
        List previousAMRunningContainers = response.getContainersFromPreviousAttempts();
        LOG.info((Object)(this.appAttemptID + " received " + previousAMRunningContainers.size() + " previous attempts' running containers on AM registration."));
        for (Container container : previousAMRunningContainers) {
            this.launchedContainers.add(container.getId());
        }
        this.numAllocatedContainers.addAndGet(previousAMRunningContainers.size());
        int numTotalContainersToRequest = this.numTotalContainers - previousAMRunningContainers.size();
        for (int i = 0; i < numTotalContainersToRequest; ++i) {
            AMRMClient.ContainerRequest containerAsk = this.setupContainerAskForRM();
            this.amRMClient.addContainerRequest(containerAsk);
        }
        this.numRequestedContainers.set(this.numTotalContainers);
    }

    @VisibleForTesting
    void startTimelineClient(Configuration conf) throws YarnException, IOException, InterruptedException {
        try {
            this.appSubmitterUgi.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (UndeclaredThrowableException e) {
            throw new YarnException(e.getCause());
        }
    }

    @VisibleForTesting
    NMCallbackHandler createNMCallbackHandler() {
        return new NMCallbackHandler(this);
    }

    @VisibleForTesting
    protected boolean finish() {
        FinalApplicationStatus appStatus;
        while (!this.done && this.numCompletedContainers.get() != this.numTotalContainers) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.timelineServiceV1Enabled) {
            this.publishApplicationAttemptEvent(this.timelineClient, this.appAttemptID.toString(), DSEvent.DS_APP_ATTEMPT_END, this.domainId, this.appSubmitterUgi);
        }
        if (this.timelineServiceV2Enabled) {
            this.publishApplicationAttemptEventOnTimelineServiceV2(DSEvent.DS_APP_ATTEMPT_END);
        }
        for (Thread launchThread : this.launchThreads) {
            try {
                launchThread.join(10000L);
            }
            catch (InterruptedException e) {
                LOG.info((Object)("Exception thrown in thread join: " + e.getMessage()));
                e.printStackTrace();
            }
        }
        LOG.info((Object)"Application completed. Stopping running containers");
        this.nmClientAsync.stop();
        LOG.info((Object)"Application completed. Signalling finish to RM");
        String appMessage = null;
        boolean success = true;
        if (this.numCompletedContainers.get() - this.numFailedContainers.get() >= this.numTotalContainers) {
            appStatus = FinalApplicationStatus.SUCCEEDED;
        } else {
            appStatus = FinalApplicationStatus.FAILED;
            appMessage = "Diagnostics., total=" + this.numTotalContainers + ", completed=" + this.numCompletedContainers.get() + ", allocated=" + this.numAllocatedContainers.get() + ", failed=" + this.numFailedContainers.get();
            LOG.info((Object)appMessage);
            success = false;
        }
        try {
            this.amRMClient.unregisterApplicationMaster(appStatus, appMessage, null);
        }
        catch (YarnException ex) {
            LOG.error((Object)"Failed to unregister application", (Throwable)ex);
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to unregister application", (Throwable)e);
        }
        this.amRMClient.stop();
        if (this.timelineServiceV1Enabled) {
            this.timelineClient.stop();
        }
        if (this.timelineServiceV2Enabled) {
            this.timelineV2Client.stop();
        }
        return success;
    }

    private void renameScriptFile(Path renamedScriptPath) throws IOException, InterruptedException {
        this.appSubmitterUgi.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        LOG.info((Object)("User " + this.appSubmitterUgi.getUserName() + " added suffix(.sh/.bat) to script file as " + renamedScriptPath));
    }

    private AMRMClient.ContainerRequest setupContainerAskForRM() {
        Priority pri = Priority.newInstance((int)this.requestPriority);
        Resource capability = Resource.newInstance((long)this.containerMemory, (int)this.containerVirtualCores);
        AMRMClient.ContainerRequest request = new AMRMClient.ContainerRequest(capability, null, null, pri);
        LOG.info((Object)("Requested container ask: " + request.toString()));
        return request;
    }

    private boolean fileExist(String filePath) {
        return new File(filePath).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readContent(String filePath) throws IOException {
        String string;
        DataInputStream ds = null;
        try {
            ds = new DataInputStream(new FileInputStream(filePath));
            string = ds.readUTF();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(ds);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)ds);
        return string;
    }

    private void publishContainerStartEvent(TimelineClient timelineClient, Container container, String domainId, UserGroupInformation ugi) {
        TimelineEntity entity = new TimelineEntity();
        entity.setEntityId(container.getId().toString());
        entity.setEntityType(DSEntity.DS_CONTAINER.toString());
        entity.setDomainId(domainId);
        entity.addPrimaryFilter(USER_TIMELINE_FILTER_NAME, (Object)ugi.getShortUserName());
        entity.addPrimaryFilter(APPID_TIMELINE_FILTER_NAME, (Object)container.getId().getApplicationAttemptId().getApplicationId().toString());
        TimelineEvent event = new TimelineEvent();
        event.setTimestamp(System.currentTimeMillis());
        event.setEventType(DSEvent.DS_CONTAINER_START.toString());
        event.addEventInfo("Node", (Object)container.getNodeId().toString());
        event.addEventInfo("Resources", (Object)container.getResource().toString());
        entity.addEvent(event);
        try {
            this.processTimelineResponseErrors(this.putContainerEntity(timelineClient, container.getId().getApplicationAttemptId(), entity));
        }
        catch (ClientHandlerException | IOException | YarnException e) {
            LOG.error((Object)("Container start event could not be published for " + container.getId().toString()), e);
        }
    }

    @VisibleForTesting
    void publishContainerEndEvent(TimelineClient timelineClient, ContainerStatus container, String domainId, UserGroupInformation ugi) {
        TimelineEntity entity = new TimelineEntity();
        entity.setEntityId(container.getContainerId().toString());
        entity.setEntityType(DSEntity.DS_CONTAINER.toString());
        entity.setDomainId(domainId);
        entity.addPrimaryFilter(USER_TIMELINE_FILTER_NAME, (Object)ugi.getShortUserName());
        entity.addPrimaryFilter(APPID_TIMELINE_FILTER_NAME, (Object)container.getContainerId().getApplicationAttemptId().getApplicationId().toString());
        TimelineEvent event = new TimelineEvent();
        event.setTimestamp(System.currentTimeMillis());
        event.setEventType(DSEvent.DS_CONTAINER_END.toString());
        event.addEventInfo("State", (Object)container.getState().name());
        event.addEventInfo("Exit Status", (Object)container.getExitStatus());
        entity.addEvent(event);
        try {
            this.processTimelineResponseErrors(this.putContainerEntity(timelineClient, container.getContainerId().getApplicationAttemptId(), entity));
        }
        catch (ClientHandlerException | IOException | YarnException e) {
            LOG.error((Object)("Container end event could not be published for " + container.getContainerId().toString()), e);
        }
    }

    private TimelinePutResponse putContainerEntity(TimelineClient timelineClient, ApplicationAttemptId currAttemptId, TimelineEntity entity) throws YarnException, IOException {
        if (TimelineUtils.timelineServiceV1_5Enabled((Configuration)this.conf)) {
            TimelineEntityGroupId groupId = TimelineEntityGroupId.newInstance((ApplicationId)currAttemptId.getApplicationId(), (String)CONTAINER_ENTITY_GROUP_ID);
            return timelineClient.putEntities(currAttemptId, groupId, new TimelineEntity[]{entity});
        }
        return timelineClient.putEntities(new TimelineEntity[]{entity});
    }

    private void publishApplicationAttemptEvent(TimelineClient timelineClient, String appAttemptId, DSEvent appEvent, String domainId, UserGroupInformation ugi) {
        TimelineEntity entity = new TimelineEntity();
        entity.setEntityId(appAttemptId);
        entity.setEntityType(DSEntity.DS_APP_ATTEMPT.toString());
        entity.setDomainId(domainId);
        entity.addPrimaryFilter(USER_TIMELINE_FILTER_NAME, (Object)ugi.getShortUserName());
        TimelineEvent event = new TimelineEvent();
        event.setEventType(appEvent.toString());
        event.setTimestamp(System.currentTimeMillis());
        entity.addEvent(event);
        try {
            TimelinePutResponse response = timelineClient.putEntities(new TimelineEntity[]{entity});
            this.processTimelineResponseErrors(response);
        }
        catch (ClientHandlerException | IOException | YarnException e) {
            LOG.error((Object)("App Attempt " + (appEvent.equals((Object)DSEvent.DS_APP_ATTEMPT_START) ? "start" : "end") + " event could not be published for " + this.appAttemptID), e);
        }
    }

    private TimelinePutResponse processTimelineResponseErrors(TimelinePutResponse response) {
        List errors = response.getErrors();
        if (errors.size() == 0) {
            LOG.debug((Object)"Timeline entities are successfully put");
        } else {
            for (TimelinePutResponse.TimelinePutError error : errors) {
                LOG.error((Object)("Error when publishing entity [" + error.getEntityType() + "," + error.getEntityId() + "], server side error code: " + error.getErrorCode()));
            }
        }
        return response;
    }

    RMCallbackHandler getRMCallbackHandler() {
        return new RMCallbackHandler(this);
    }

    @VisibleForTesting
    void setAmRMClient(AMRMClientAsync client) {
        this.amRMClient = client;
    }

    @VisibleForTesting
    int getNumCompletedContainers() {
        return this.numCompletedContainers.get();
    }

    @VisibleForTesting
    boolean getDone() {
        return this.done;
    }

    @VisibleForTesting
    Thread createLaunchContainerThread(Container allocatedContainer, String shellId) {
        LaunchContainerRunnable runnableLaunchContainer = new LaunchContainerRunnable(this, allocatedContainer, this.containerListener, shellId);
        return new Thread((Runnable)runnableLaunchContainer);
    }

    private void publishContainerStartEventOnTimelineServiceV2(Container container, long startTime) {
        org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity entity = new org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity();
        entity.setId(container.getId().toString());
        entity.setType(DSEntity.DS_CONTAINER.toString());
        entity.setCreatedTime(Long.valueOf(startTime));
        entity.addInfo(USER_TIMELINE_FILTER_NAME, (Object)this.appSubmitterUgi.getShortUserName());
        org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent event = new org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent();
        event.setTimestamp(startTime);
        event.setId(DSEvent.DS_CONTAINER_START.toString());
        event.addInfo("Node", (Object)container.getNodeId().toString());
        event.addInfo("Resources", (Object)container.getResource().toString());
        entity.addEvent(event);
        entity.setIdPrefix(TimelineServiceHelper.invertLong((long)startTime));
        try {
            this.appSubmitterUgi.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            LOG.error((Object)("Container start event could not be published for " + container.getId().toString()), e instanceof UndeclaredThrowableException ? e.getCause() : e);
        }
    }

    private void publishContainerEndEventOnTimelineServiceV2(ContainerStatus container, long containerStartTime) {
        org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity entity = new org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity();
        entity.setId(container.getContainerId().toString());
        entity.setType(DSEntity.DS_CONTAINER.toString());
        entity.addInfo(USER_TIMELINE_FILTER_NAME, (Object)this.appSubmitterUgi.getShortUserName());
        org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent event = new org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent();
        event.setTimestamp(System.currentTimeMillis());
        event.setId(DSEvent.DS_CONTAINER_END.toString());
        event.addInfo("State", (Object)container.getState().name());
        event.addInfo("Exit Status", (Object)container.getExitStatus());
        entity.addEvent(event);
        entity.setIdPrefix(TimelineServiceHelper.invertLong((long)containerStartTime));
        try {
            this.appSubmitterUgi.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            LOG.error((Object)("Container end event could not be published for " + container.getContainerId().toString()), e instanceof UndeclaredThrowableException ? e.getCause() : e);
        }
    }

    private void publishApplicationAttemptEventOnTimelineServiceV2(DSEvent appEvent) {
        org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity entity = new org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity();
        entity.setId(this.appAttemptID.toString());
        entity.setType(DSEntity.DS_APP_ATTEMPT.toString());
        long ts = System.currentTimeMillis();
        if (appEvent == DSEvent.DS_APP_ATTEMPT_START) {
            entity.setCreatedTime(Long.valueOf(ts));
        }
        entity.addInfo(USER_TIMELINE_FILTER_NAME, (Object)this.appSubmitterUgi.getShortUserName());
        org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent event = new org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent();
        event.setId(appEvent.toString());
        event.setTimestamp(ts);
        entity.addEvent(event);
        entity.setIdPrefix(TimelineServiceHelper.invertLong((long)this.appAttemptID.getAttemptId()));
        try {
            this.appSubmitterUgi.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            LOG.error((Object)("App Attempt " + (appEvent.equals((Object)DSEvent.DS_APP_ATTEMPT_START) ? "start" : "end") + " event could not be published for " + this.appAttemptID), e instanceof UndeclaredThrowableException ? e.getCause() : e);
        }
    }

    static /* synthetic */ boolean access$002(ApplicationMaster x0, boolean x1) {
        x0.timelineServiceV1Enabled = x1;
        return x0.timelineServiceV1Enabled;
    }

    static /* synthetic */ boolean access$102(ApplicationMaster x0, boolean x1) {
        x0.timelineServiceV2Enabled = x1;
        return x0.timelineServiceV2Enabled;
    }

    static /* synthetic */ boolean access$000(ApplicationMaster x0) {
        return x0.timelineServiceV1Enabled;
    }

    static /* synthetic */ Log access$200() {
        return LOG;
    }

    static /* synthetic */ boolean access$100(ApplicationMaster x0) {
        return x0.timelineServiceV2Enabled;
    }

    static /* synthetic */ AtomicInteger access$300(ApplicationMaster x0) {
        return x0.numCompletedContainers;
    }

    static /* synthetic */ AtomicInteger access$400(ApplicationMaster x0) {
        return x0.numFailedContainers;
    }

    static /* synthetic */ ConcurrentMap access$500(ApplicationMaster x0) {
        return x0.containerStartTimes;
    }

    static /* synthetic */ void access$600(ApplicationMaster x0, ContainerStatus x1, long x2) {
        x0.publishContainerEndEventOnTimelineServiceV2(x1, x2);
    }

    static /* synthetic */ String access$700(ApplicationMaster x0) {
        return x0.domainId;
    }

    static /* synthetic */ AMRMClient.ContainerRequest access$800(ApplicationMaster x0) {
        return x0.setupContainerAskForRM();
    }

    static /* synthetic */ AMRMClientAsync access$900(ApplicationMaster x0) {
        return x0.amRMClient;
    }

    static /* synthetic */ boolean access$1002(ApplicationMaster x0, boolean x1) {
        x0.done = x1;
        return x0.done;
    }

    static /* synthetic */ int access$1100(ApplicationMaster x0) {
        return x0.yarnShellIdCounter;
    }

    static /* synthetic */ int access$1108(ApplicationMaster x0) {
        return x0.yarnShellIdCounter++;
    }

    static /* synthetic */ List access$1200(ApplicationMaster x0) {
        return x0.launchThreads;
    }

    static /* synthetic */ NMClientAsync access$1300(ApplicationMaster x0) {
        return x0.nmClientAsync;
    }

    static /* synthetic */ ConcurrentMap access$1400(ApplicationMaster x0) {
        return x0.getContainerStartTimes();
    }

    static /* synthetic */ void access$1500(ApplicationMaster x0, Container x1, long x2) {
        x0.publishContainerStartEventOnTimelineServiceV2(x1, x2);
    }

    static /* synthetic */ void access$1600(ApplicationMaster x0, TimelineClient x1, Container x2, String x3, UserGroupInformation x4) {
        x0.publishContainerStartEvent(x1, x2, x3, x4);
    }

    static /* synthetic */ String access$1700(ApplicationMaster x0) {
        return x0.scriptPath;
    }

    static /* synthetic */ void access$1800(ApplicationMaster x0, Path x1) throws IOException, InterruptedException {
        x0.renameScriptFile(x1);
    }

    static /* synthetic */ long access$1900(ApplicationMaster x0) {
        return x0.shellScriptPathLen;
    }

    static /* synthetic */ long access$2000(ApplicationMaster x0) {
        return x0.shellScriptPathTimestamp;
    }

    static /* synthetic */ String access$2102(ApplicationMaster x0, String x1) {
        x0.shellCommand = x1;
        return x0.shellCommand;
    }

    static /* synthetic */ String access$2100(ApplicationMaster x0) {
        return x0.shellCommand;
    }

    static /* synthetic */ String access$2200(ApplicationMaster x0) {
        return x0.shellArgs;
    }

    static /* synthetic */ Map access$2300(ApplicationMaster x0) {
        return x0.shellEnv;
    }

    static /* synthetic */ ContainerRetryPolicy access$2400(ApplicationMaster x0) {
        return x0.containerRetryPolicy;
    }

    static /* synthetic */ Set access$2500(ApplicationMaster x0) {
        return x0.containerRetryErrorCodes;
    }

    static /* synthetic */ int access$2600(ApplicationMaster x0) {
        return x0.containerMaxRetries;
    }

    static /* synthetic */ int access$2700(ApplicationMaster x0) {
        return x0.containrRetryInterval;
    }

    static /* synthetic */ ByteBuffer access$2800(ApplicationMaster x0) {
        return x0.allTokens;
    }

    static /* synthetic */ Configuration access$2900(ApplicationMaster x0) {
        return x0.conf;
    }
}

