/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.streaming.StreamJob;
import org.apache.hadoop.streaming.StreamUtil;
import org.apache.hadoop.streaming.TypedBytesMapApp;
import org.apache.hadoop.streaming.TypedBytesReduceApp;
import org.apache.hadoop.streaming.UtilTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestTypedBytesStreaming {
    protected File INPUT_FILE = new File("target/input.txt");
    protected File OUTPUT_DIR = new File("target/out");
    protected String input = "roses.are.red\nviolets.are.blue\nbunnies.are.pink\n";
    protected String map = UtilTest.makeJavaCommand(TypedBytesMapApp.class, (String[])new String[]{"."});
    protected String reduce = UtilTest.makeJavaCommand(TypedBytesReduceApp.class, (String[])new String[0]);
    protected String outputExpect = "are\t3\nred\t1\nblue\t1\npink\t1\nroses\t1\nbunnies\t1\nviolets\t1\n";

    public TestTypedBytesStreaming() throws IOException {
        UtilTest utilTest = new UtilTest(this.getClass().getName());
        utilTest.checkUserDir();
        utilTest.redirectIfAntJunit();
    }

    protected void createInput() throws IOException {
        DataOutputStream out = new DataOutputStream(new FileOutputStream(this.INPUT_FILE.getAbsoluteFile()));
        out.write(this.input.getBytes("UTF-8"));
        out.close();
    }

    protected String[] genArgs() {
        return new String[]{"-input", this.INPUT_FILE.getAbsolutePath(), "-output", this.OUTPUT_DIR.getAbsolutePath(), "-mapper", this.map, "-reducer", this.reduce, "-jobconf", "mapreduce.task.files.preserve.failedtasks=true", "-jobconf", "stream.tmpdir=" + System.getProperty("test.build.data", "/tmp"), "-io", "typedbytes"};
    }

    @Before
    @After
    public void cleanupOutput() throws Exception {
        FileUtil.fullyDelete((File)this.OUTPUT_DIR.getAbsoluteFile());
        this.INPUT_FILE.delete();
        this.createInput();
    }

    @Test
    public void testCommandLine() throws Exception {
        StreamJob job = new StreamJob();
        job.setConf(new Configuration());
        job.run(this.genArgs());
        File outFile = new File(this.OUTPUT_DIR, "part-00000").getAbsoluteFile();
        String output = StreamUtil.slurp((File)outFile);
        outFile.delete();
        System.out.println("   map=" + this.map);
        System.out.println("reduce=" + this.reduce);
        System.err.println("outEx1=" + this.outputExpect);
        System.err.println("  out1=" + output);
        Assert.assertEquals((Object)this.outputExpect, (Object)output);
    }
}

