/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.streaming.StreamJob;
import org.apache.hadoop.streaming.TestStreaming;
import org.apache.hadoop.streaming.UtilTest;
import org.apache.hadoop.util.Shell;
import org.junit.Assert;
import org.junit.Test;

public class TestStreamingTaskLog {
    String input = "the dummy input";
    Path inputPath = new Path("target/inDir");
    Path outputPath = new Path("target/outDir");
    String map = null;
    MiniMRCluster mr = null;
    FileSystem fs = null;
    final long USERLOG_LIMIT_KB = 5L;

    String[] genArgs() {
        String[] argv;
        ArrayList<String> args = new ArrayList<String>();
        for (Map.Entry entry : this.mr.createJobConf()) {
            args.add("-jobconf");
            args.add((String)entry.getKey() + "=" + (String)entry.getValue());
        }
        for (String arg : argv = new String[]{"-input", this.inputPath.toString(), "-output", this.outputPath.toString(), "-mapper", this.map, "-reducer", "NONE", "-jobconf", "mapred.map.tasks=1", "-jobconf", "keep.failed.task.files=true", "-jobconf", "mapreduce.task.userlog.limit.kb=5", "-jobconf", "stream.tmpdir=" + System.getProperty("test.build.data", "/tmp"), "-jobconf", "mapred.jar=" + TestStreaming.STREAMING_JAR}) {
            args.add(arg);
        }
        argv = args.toArray(new String[args.size()]);
        return argv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStreamingTaskLogWithHadoopCmd() {
        try {
            boolean numSlaves = true;
            JobConf conf = new JobConf();
            this.fs = FileSystem.getLocal((Configuration)conf);
            Path testDir = new Path(System.getProperty("test.build.data", "/tmp"));
            if (this.fs.exists(testDir)) {
                this.fs.delete(testDir, true);
            }
            this.fs.mkdirs(testDir);
            File scriptFile = this.createScript(testDir.toString() + "/testTaskLog.sh");
            conf.setBoolean("mapreduce.jobtracker.persist.jobstatus.active", false);
            this.mr = new MiniMRCluster(1, this.fs.getUri().toString(), 1, null, null, conf);
            this.writeInputFile(this.fs, this.inputPath);
            this.map = scriptFile.getAbsolutePath();
            this.runStreamJobAndValidateEnv();
            this.fs.delete(this.outputPath, true);
            Assert.assertFalse((String)"output not cleaned up", (boolean)this.fs.exists(this.outputPath));
        }
        catch (IOException e) {
            Assert.fail((String)e.toString());
        }
        finally {
            if (this.mr != null) {
                this.mr.shutdown();
            }
        }
    }

    private File createScript(String script) throws IOException {
        File scriptFile = new File(script);
        UtilTest.recursiveDelete((File)scriptFile);
        FileOutputStream in = new FileOutputStream(scriptFile);
        in.write("cat > /dev/null 2>&1\necho $HADOOP_ROOT_LOGGER $HADOOP_CLIENT_OPTS".getBytes());
        in.close();
        Shell.execCommand((String[])new String[]{"chmod", "+x", scriptFile.getAbsolutePath()});
        return scriptFile;
    }

    private void writeInputFile(FileSystem fs, Path dir) throws IOException {
        FSDataOutputStream out = fs.create(new Path(dir, "part0"));
        out.writeBytes(this.input);
        out.close();
    }

    private void runStreamJobAndValidateEnv() throws IOException {
        int returnStatus = -1;
        boolean mayExit = false;
        StreamJob job = new StreamJob(this.genArgs(), mayExit);
        returnStatus = job.go();
        Assert.assertEquals((String)"StreamJob failed.", (long)0L, (long)returnStatus);
        String env = MapReduceTestUtil.readOutput((Path)this.outputPath, (Configuration)this.mr.createJobConf());
        long logSize = 5120L;
        Assert.assertTrue((String)"environment set for child is wrong", (env.contains("INFO,CLA") && env.contains("-Dyarn.app.mapreduce.container.log.dir=") && env.contains("-Dyarn.app.mapreduce.container.log.filesize=" + logSize) && env.contains("-Dlog4j.configuration=") ? 1 : 0) != 0);
    }
}

