/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.IOException;
import org.apache.hadoop.streaming.TestStreaming;
import org.apache.hadoop.streaming.TestStreamingOutputKeyValueTypes;
import org.junit.Before;
import org.junit.Test;

public class TestStreamingOutputKeyValueTypes
extends TestStreaming {
    public TestStreamingOutputKeyValueTypes() throws IOException {
        this.input = "one line dummy input\n";
    }

    @Before
    public void setUp() throws IOException {
        this.args.clear();
        super.setUp();
    }

    protected String[] genArgs() {
        this.args.add("-jobconf");
        this.args.add("mapreduce.map.output.key.class=org.apache.hadoop.io.LongWritable");
        this.args.add("-jobconf");
        this.args.add("mapreduce.job.output.key.class=org.apache.hadoop.io.LongWritable");
        this.args.add("-outputformat");
        this.args.add("org.apache.hadoop.mapred.SequenceFileOutputFormat");
        return super.genArgs();
    }

    protected void checkOutput() throws IOException {
    }

    @Test
    public void testJavaMapperAndJavaReducer() throws Exception {
        this.map = "org.apache.hadoop.mapred.lib.IdentityMapper";
        this.reduce = "org.apache.hadoop.mapred.lib.IdentityReducer";
        super.testCommandLine();
    }

    @Test
    public void testJavaMapperAndJavaReducerAndZeroReduces() throws Exception {
        this.map = "org.apache.hadoop.mapred.lib.IdentityMapper";
        this.reduce = "org.apache.hadoop.mapred.lib.IdentityReducer";
        this.args.add("-numReduceTasks");
        this.args.add("0");
        super.testCommandLine();
    }

    @Test
    public void testJavaMapperWithReduceNone() throws Exception {
        this.map = "org.apache.hadoop.mapred.lib.IdentityMapper";
        this.reduce = "NONE";
        super.testCommandLine();
    }

    @Test
    public void testJavaMapperAndCommandReducer() throws Exception {
        this.map = "org.apache.hadoop.mapred.lib.IdentityMapper";
        this.reduce = "cat";
        super.testCommandLine();
    }

    @Test
    public void testJavaMapperAndCommandReducerAndZeroReduces() throws Exception {
        this.map = "org.apache.hadoop.mapred.lib.IdentityMapper";
        this.reduce = "cat";
        this.args.add("-numReduceTasks");
        this.args.add("0");
        super.testCommandLine();
    }

    @Test
    public void testCommandMapperAndJavaReducer() throws Exception {
        this.map = "cat";
        this.reduce = MyReducer.class.getName();
        super.testCommandLine();
    }

    @Test
    public void testCommandMapperAndJavaReducerAndZeroReduces() throws Exception {
        this.map = "cat";
        this.reduce = MyReducer.class.getName();
        this.args.add("-numReduceTasks");
        this.args.add("0");
        super.testCommandLine();
    }

    @Test
    public void testCommandMapperWithReduceNone() throws Exception {
        this.map = "cat";
        this.reduce = "NONE";
        super.testCommandLine();
    }

    @Test
    public void testCommandMapperAndCommandReducer() throws Exception {
        this.map = "cat";
        this.reduce = "cat";
        super.testCommandLine();
    }

    @Test
    public void testCommandMapperAndCommandReducerAndZeroReduces() throws Exception {
        this.map = "cat";
        this.reduce = "cat";
        this.args.add("-numReduceTasks");
        this.args.add("0");
        super.testCommandLine();
    }

    @Test
    public void testCommandLine() {
    }
}

