/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.streaming.StreamJob;
import org.apache.hadoop.streaming.StreamUtil;
import org.apache.hadoop.streaming.UtilTest;
import org.junit.Assert;
import org.junit.Test;

public class TestStreamingKeyValue {
    protected File INPUT_FILE = new File("target/input.txt");
    protected File OUTPUT_DIR = new File("target/stream_out");
    protected String input = "roses are \tred\t\n\tviolets are blue\nbunnies are pink\nthis is for testing a big\tinput line\nsmall input\n";
    protected String outputWithoutKey = "\tviolets are blue\nbunnies are pink\t\nroses are \tred\t\nsmall input\t\nthis is for testing a big\tinput line\n";
    protected String outputWithKey = "0\troses are \tred\t\n16\t\tviolets are blue\n34\tbunnies are pink\n51\tthis is for testing a big\tinput line\n88\tsmall input\n";
    private StreamJob job;

    public TestStreamingKeyValue() throws IOException {
        UtilTest utilTest = new UtilTest(this.getClass().getName());
        utilTest.checkUserDir();
        utilTest.redirectIfAntJunit();
    }

    protected void createInput() throws IOException {
        DataOutputStream out = new DataOutputStream(new FileOutputStream(this.INPUT_FILE.getAbsoluteFile()));
        out.write(this.input.getBytes("UTF-8"));
        out.close();
    }

    protected String[] genArgs(boolean ignoreKey) {
        return new String[]{"-input", this.INPUT_FILE.getAbsolutePath(), "-output", this.OUTPUT_DIR.getAbsolutePath(), "-mapper", "cat", "-jobconf", "mapreduce.task.files.preserve.failedtasks=true", "-jobconf", "stream.non.zero.exit.is.failure=true", "-jobconf", "stream.tmpdir=" + System.getProperty("test.build.data", "/tmp"), "-jobconf", "stream.map.input.ignoreKey=" + ignoreKey};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runStreamJob(String outputExpect, boolean ignoreKey) throws Exception {
        String outFileName = "part-00000";
        File outFile = null;
        try {
            try {
                FileUtil.fullyDelete((File)this.OUTPUT_DIR.getAbsoluteFile());
            }
            catch (Exception e) {
                // empty catch block
            }
            this.createInput();
            boolean mayExit = false;
            this.job = new StreamJob(this.genArgs(ignoreKey), mayExit);
            this.job.go();
            outFile = new File(this.OUTPUT_DIR, outFileName).getAbsoluteFile();
            String output = StreamUtil.slurp((File)outFile);
            System.err.println("outEx1=" + outputExpect);
            System.err.println("  out1=" + output);
            Assert.assertEquals((Object)outputExpect, (Object)output);
        }
        finally {
            this.INPUT_FILE.delete();
            FileUtil.fullyDelete((File)this.OUTPUT_DIR.getAbsoluteFile());
        }
    }

    @Test
    public void testCommandLineWithKey() throws Exception {
        this.runStreamJob(this.outputWithKey, false);
    }

    @Test
    public void testCommandLineWithoutKey() throws Exception {
        this.runStreamJob(this.outputWithoutKey, true);
    }

    public static void main(String[] args) throws Exception {
        new TestStreamingKeyValue().testCommandLineWithKey();
        new TestStreamingKeyValue().testCommandLineWithoutKey();
    }
}

