/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.streaming.StreamJob;
import org.apache.hadoop.streaming.StreamUtil;
import org.apache.hadoop.streaming.TrApp;
import org.apache.hadoop.streaming.UniqApp;
import org.apache.hadoop.streaming.UtilTest;
import org.apache.hadoop.util.JarFinder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestStreaming {
    public static final String STREAMING_JAR = JarFinder.getJar(StreamJob.class);
    protected File TEST_DIR;
    protected File INPUT_FILE;
    protected File OUTPUT_DIR;
    protected String inputFile;
    protected String outDir;
    protected String input = "roses.are.red\nviolets.are.blue\nbunnies.are.pink\n";
    protected String map = UtilTest.makeJavaCommand(TrApp.class, (String[])new String[]{".", "\\n"});
    protected String reduce = UtilTest.makeJavaCommand(UniqApp.class, (String[])new String[]{"R"});
    protected String outputExpect = "Rare\t\nRblue\t\nRbunnies\t\nRpink\t\nRred\t\nRroses\t\nRviolets\t\n";
    protected ArrayList<String> args = new ArrayList();
    protected StreamJob job;

    public TestStreaming() throws IOException {
        UtilTest utilTest = new UtilTest(this.getClass().getName());
        utilTest.checkUserDir();
        utilTest.redirectIfAntJunit();
        this.TEST_DIR = new File("target/TestStreaming").getAbsoluteFile();
        this.OUTPUT_DIR = new File(this.TEST_DIR, "out");
        this.INPUT_FILE = new File(this.TEST_DIR, "input.txt");
    }

    @Before
    public void setUp() throws IOException {
        UtilTest.recursiveDelete((File)this.TEST_DIR);
        Assert.assertTrue((String)("Creating " + this.TEST_DIR), (boolean)this.TEST_DIR.mkdirs());
        this.args.clear();
    }

    @After
    public void tearDown() {
        UtilTest.recursiveDelete((File)this.TEST_DIR);
    }

    protected String getInputData() {
        return this.input;
    }

    protected void createInput() throws IOException {
        FSDataOutputStream out = this.getFileSystem().create(new Path(this.INPUT_FILE.getAbsolutePath()));
        out.write(this.getInputData().getBytes("UTF-8"));
        out.close();
    }

    protected void setInputOutput() {
        this.inputFile = this.INPUT_FILE.getAbsolutePath();
        this.outDir = this.OUTPUT_DIR.getAbsolutePath();
    }

    protected String[] genArgs() {
        this.setInputOutput();
        this.args.add("-input");
        this.args.add(this.inputFile);
        this.args.add("-output");
        this.args.add(this.outDir);
        this.args.add("-mapper");
        this.args.add(this.map);
        this.args.add("-reducer");
        this.args.add(this.reduce);
        this.args.add("-jobconf");
        this.args.add("mapreduce.task.files.preserve.failedtasks=true");
        this.args.add("-jobconf");
        this.args.add("stream.tmpdir=" + System.getProperty("test.build.data", "/tmp"));
        String[] str = new String[this.args.size()];
        this.args.toArray(str);
        return str;
    }

    protected Configuration getConf() {
        return new Configuration();
    }

    protected FileSystem getFileSystem() throws IOException {
        return FileSystem.get((Configuration)this.getConf());
    }

    protected String getExpectedOutput() {
        return this.outputExpect;
    }

    protected void checkOutput() throws IOException {
        Path outPath = new Path(this.OUTPUT_DIR.getAbsolutePath(), "part-00000");
        FileSystem fs = this.getFileSystem();
        String output = StreamUtil.slurpHadoop((Path)outPath, (FileSystem)fs);
        fs.delete(outPath, true);
        System.err.println("outEx1=" + this.getExpectedOutput());
        System.err.println("  out1=" + output);
        this.assertOutput(this.getExpectedOutput(), output);
    }

    protected void assertOutput(String expectedOutput, String output) throws IOException {
        String[] words = expectedOutput.split("\t\n");
        HashSet<String> expectedWords = new HashSet<String>(Arrays.asList(words));
        words = output.split("\t\n");
        HashSet<String> returnedWords = new HashSet<String>(Arrays.asList(words));
        Assert.assertTrue((boolean)returnedWords.containsAll(expectedWords));
    }

    protected int runStreamJob() throws IOException {
        this.createInput();
        boolean mayExit = false;
        this.job = new StreamJob(this.genArgs(), mayExit);
        return this.job.go();
    }

    @Test
    public void testCommandLine() throws Exception {
        int ret = this.runStreamJob();
        Assert.assertEquals((long)0L, (long)ret);
        this.checkOutput();
    }
}

