/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.streaming.TestStreaming;
import org.junit.After;
import org.junit.Before;

public class TestFileArgs
extends TestStreaming {
    private MiniDFSCluster dfs = null;
    private MiniMRCluster mr = null;
    private FileSystem fileSys = null;
    private String namenode = null;
    private Configuration conf = new Configuration();
    private static final String EXPECTED_OUTPUT = "job.jar\t\nsidefile\t\n";
    private static final String LS_PATH = "/bin/ls";

    public TestFileArgs() throws IOException {
        this.dfs = new MiniDFSCluster(this.conf, 1, true, null);
        this.fileSys = this.dfs.getFileSystem();
        this.namenode = this.fileSys.getUri().getAuthority();
        this.mr = new MiniMRCluster(1, this.namenode, 1);
        this.map = LS_PATH;
        FileSystem.setDefaultUri((Configuration)this.conf, (String)("hdfs://" + this.namenode));
    }

    @Before
    public void setUp() throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)this.conf);
        FSDataOutputStream dos = localFs.create(new Path("target/sidefile"));
        dos.write("hello world\n".getBytes("UTF-8"));
        dos.close();
        this.input = "";
    }

    @After
    public void tearDown() {
        if (this.mr != null) {
            this.mr.shutdown();
        }
        if (this.dfs != null) {
            this.dfs.shutdown();
        }
    }

    protected String getExpectedOutput() {
        return EXPECTED_OUTPUT;
    }

    protected Configuration getConf() {
        return this.conf;
    }

    protected String[] genArgs() {
        for (Map.Entry entry : this.mr.createJobConf()) {
            this.args.add("-jobconf");
            this.args.add((String)entry.getKey() + "=" + (String)entry.getValue());
        }
        this.args.add("-file");
        this.args.add(new File("target/sidefile").getAbsolutePath());
        this.args.add("-numReduceTasks");
        this.args.add("0");
        this.args.add("-jobconf");
        this.args.add("mapred.jar=" + STREAMING_JAR);
        this.args.add("-verbose");
        return super.genArgs();
    }
}

