/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.streaming.StreamUtil;

public abstract class StreamBaseRecordReader
implements RecordReader<Text, Text> {
    protected static final Log LOG = LogFactory.getLog((String)StreamBaseRecordReader.class.getName());
    static final String CONF_NS = "stream.recordreader.";
    long lastMem = 0L;
    FSDataInputStream in_;
    FileSplit split_;
    long start_;
    long end_;
    long length_;
    String splitName_;
    Reporter reporter_;
    JobConf job_;
    FileSystem fs_;
    int numRec_ = 0;
    int nextStatusRec_ = 1;
    int statusMaxRecordChars_;

    public StreamBaseRecordReader(FSDataInputStream in, FileSplit split, Reporter reporter, JobConf job, FileSystem fs) throws IOException {
        this.in_ = in;
        this.split_ = split;
        this.start_ = this.split_.getStart();
        this.length_ = this.split_.getLength();
        this.end_ = this.start_ + this.length_;
        this.splitName_ = this.split_.getPath().getName();
        this.reporter_ = reporter;
        this.job_ = job;
        this.fs_ = fs;
        this.statusMaxRecordChars_ = this.job_.getInt("stream.recordreader.statuschars", 200);
    }

    public abstract boolean next(Text var1, Text var2) throws IOException;

    public synchronized long getPos() throws IOException {
        return this.in_.getPos();
    }

    public synchronized void close() throws IOException {
        this.in_.close();
    }

    public float getProgress() throws IOException {
        if (this.end_ == this.start_) {
            return 1.0f;
        }
        return (float)(this.in_.getPos() - this.start_) / (float)(this.end_ - this.start_);
    }

    public Text createKey() {
        return new Text();
    }

    public Text createValue() {
        return new Text();
    }

    public abstract void seekNextRecordBoundary() throws IOException;

    void numRecStats(byte[] record, int start, int len) throws IOException {
        ++this.numRec_;
        if (this.numRec_ == this.nextStatusRec_) {
            String recordStr = new String(record, start, Math.min(len, this.statusMaxRecordChars_), "UTF-8");
            this.nextStatusRec_ += 100;
            String status = this.getStatus((CharSequence)recordStr);
            LOG.info((Object)status);
            this.reporter_.setStatus(status);
        }
    }

    String getStatus(CharSequence record) {
        long pos = -1L;
        try {
            pos = this.getPos();
        }
        catch (IOException io) {
            // empty catch block
        }
        String recStr = record.length() > this.statusMaxRecordChars_ ? record.subSequence(0, this.statusMaxRecordChars_) + "..." : record.toString();
        String unqualSplit = this.split_.getPath().getName() + ":" + this.split_.getStart() + "+" + this.split_.getLength();
        String status = "HSTR " + StreamUtil.HOST + " " + this.numRec_ + ". pos=" + pos + " " + unqualSplit + " Processing record=" + recStr;
        status = status + " " + this.splitName_;
        return status;
    }
}

