/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.streaming;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import org.apache.hadoop.io.IntWritable;

public class RawBytesReduceApp {
    private DataInputStream dis = new DataInputStream(System.in);

    public void go() throws IOException {
        String prevKey = null;
        int sum = 0;
        String key = this.readString();
        while (key != null) {
            if (prevKey != null && !key.equals(prevKey)) {
                System.out.println(prevKey + "\t" + sum);
                sum = 0;
            }
            sum += this.readInt();
            prevKey = key;
            key = this.readString();
        }
        System.out.println(prevKey + "\t" + sum);
        System.out.flush();
    }

    public static void main(String[] args) throws IOException {
        RawBytesReduceApp app = new RawBytesReduceApp();
        app.go();
    }

    private String readString() throws IOException {
        int length;
        try {
            length = this.dis.readInt();
        }
        catch (EOFException eof) {
            return null;
        }
        byte[] bytes = new byte[length];
        this.dis.readFully(bytes);
        return new String(bytes, "UTF-8");
    }

    private int readInt() throws IOException {
        this.dis.readInt();
        IntWritable iw = new IntWritable();
        iw.readFields((DataInput)this.dis);
        return iw.get();
    }
}

