/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.resourceestimator.translator.impl;

import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.resourceestimator.common.api.RecurrenceId;
import org.apache.hadoop.resourceestimator.common.api.ResourceSkyline;
import org.apache.hadoop.resourceestimator.common.exception.ResourceEstimatorException;
import org.apache.hadoop.resourceestimator.skylinestore.api.HistorySkylineStore;
import org.apache.hadoop.resourceestimator.skylinestore.api.SkylineStore;
import org.apache.hadoop.resourceestimator.skylinestore.exceptions.SkylineStoreException;
import org.apache.hadoop.resourceestimator.skylinestore.impl.InMemoryStore;
import org.apache.hadoop.resourceestimator.translator.api.LogParser;
import org.apache.hadoop.resourceestimator.translator.exceptions.DataFieldNotFoundException;
import org.apache.hadoop.resourceestimator.translator.impl.BaseLogParser;
import org.apache.hadoop.resourceestimator.translator.impl.LogParserUtil;
import org.apache.hadoop.resourceestimator.translator.impl.RmSingleLineParser;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRmParser {
    private LogParserUtil logParserUtil = new LogParserUtil();
    private SkylineStore skylineStore;

    @Before
    public final void setup() throws ResourceEstimatorException {
        this.skylineStore = new InMemoryStore();
        BaseLogParser rmParser = new BaseLogParser();
        Configuration config = new Configuration();
        config.addResource(new Path("resourceestimator-config.xml"));
        config.set("resourceestimator.translator.line-parser", RmSingleLineParser.class.getName());
        rmParser.init(config, (HistorySkylineStore)this.skylineStore);
        this.logParserUtil.setLogParser((LogParser)rmParser);
    }

    private void parseFile(String logFile) throws SkylineStoreException, IOException, ParseException, ResourceEstimatorException, DataFieldNotFoundException {
        this.logParserUtil.parseLog(logFile);
    }

    @Test
    public final void testParse() throws SkylineStoreException, IOException, ParseException, ResourceEstimatorException, DataFieldNotFoundException {
        int k;
        String logFile = "src/test/resources/trace/rmLog.txt";
        this.parseFile("src/test/resources/trace/rmLog.txt");
        RecurrenceId recurrenceId = new RecurrenceId("FraudDetection", "1");
        Map jobSkylineLists = this.skylineStore.getHistory(recurrenceId);
        Assert.assertEquals((long)1L, (long)jobSkylineLists.size());
        List jobHistory = (List)jobSkylineLists.get(recurrenceId);
        Assert.assertEquals((long)1L, (long)jobHistory.size());
        ResourceSkyline resourceSkyline = (ResourceSkyline)jobHistory.get(0);
        Assert.assertEquals((double)0.0, (double)resourceSkyline.getJobInputDataSize(), (double)0.0);
        Assert.assertEquals((Object)"application_1497832133857_0330", (Object)resourceSkyline.getJobId());
        Assert.assertEquals((long)this.logParserUtil.stringToUnixTimestamp("06/21/2017 16:10:13"), (long)resourceSkyline.getJobSubmissionTime());
        Assert.assertEquals((long)this.logParserUtil.stringToUnixTimestamp("06/21/2017 16:18:35"), (long)resourceSkyline.getJobFinishTime());
        Resource resource = Resource.newInstance((int)1800, (int)1);
        Assert.assertEquals((long)resource.getMemorySize(), (long)resourceSkyline.getContainerSpec().getMemorySize());
        Assert.assertEquals((long)resource.getVirtualCores(), (long)resourceSkyline.getContainerSpec().getVirtualCores());
        RLESparseResourceAllocation skylineLists = resourceSkyline.getSkylineList();
        for (k = 0; k < 142; ++k) {
            Assert.assertEquals((long)1L, (long)(skylineLists.getCapacityAtTime((long)k).getMemorySize() / resource.getMemorySize()));
        }
        for (k = 142; k < 345; ++k) {
            Assert.assertEquals((long)2L, (long)(skylineLists.getCapacityAtTime((long)k).getMemorySize() / resource.getMemorySize()));
        }
        for (k = 345; k < 502; ++k) {
            Assert.assertEquals((long)1L, (long)(skylineLists.getCapacityAtTime((long)k).getMemorySize() / resource.getMemorySize()));
        }
    }

    @Test(expected=ParseException.class)
    public final void testInvalidDateFormat() throws ParseException {
        this.logParserUtil.stringToUnixTimestamp("2017.07.16 16:37:45");
    }

    @Test
    public final void testDuplicateJobSubmissionTime() throws SkylineStoreException, IOException, ParseException, ResourceEstimatorException, DataFieldNotFoundException {
        String logFile = "src/test/resources/trace/invalidLog1.txt";
        this.parseFile("src/test/resources/trace/invalidLog1.txt");
        RecurrenceId recurrenceId = new RecurrenceId("Test", "1");
        Map jobSkylineLists = this.skylineStore.getHistory(recurrenceId);
        Assert.assertEquals((long)this.logParserUtil.stringToUnixTimestamp("06/21/2017 16:10:23"), (long)((ResourceSkyline)((List)jobSkylineLists.get(recurrenceId)).get(0)).getJobSubmissionTime());
    }

    @Test
    public final void testJobIdNotFoundInJobSubmission() throws SkylineStoreException, IOException, ParseException, ResourceEstimatorException, DataFieldNotFoundException {
        String logFile = "src/test/resources/trace/invalidLog2.txt";
        this.parseFile("src/test/resources/trace/invalidLog2.txt");
        RecurrenceId recurrenceId = new RecurrenceId("Test", "2");
        Assert.assertNull((Object)this.skylineStore.getHistory(recurrenceId));
    }

    @Test
    public final void testJobIdNotFoundInContainerAlloc() throws SkylineStoreException, IOException, ParseException, ResourceEstimatorException, DataFieldNotFoundException {
        String logFile = "src/test/resources/trace/invalidLog3.txt";
        this.parseFile("src/test/resources/trace/invalidLog3.txt");
        RecurrenceId recurrenceId = new RecurrenceId("Test", "3");
        Map jobSkylineLists = this.skylineStore.getHistory(recurrenceId);
        Assert.assertEquals((long)0L, (long)((ResourceSkyline)((List)jobSkylineLists.get(recurrenceId)).get(0)).getSkylineList().getCumulative().size());
    }

    @Test
    public final void testContainerIdNotFoundInContainerAlloc() throws SkylineStoreException, IOException, ParseException, ResourceEstimatorException, DataFieldNotFoundException {
        String logFile = "src/test/resources/trace/invalidLog4.txt";
        this.parseFile("src/test/resources/trace/invalidLog4.txt");
        RecurrenceId recurrenceId = new RecurrenceId("Test", "4");
        Map jobSkylineLists = this.skylineStore.getHistory(recurrenceId);
        Assert.assertEquals((long)0L, (long)((ResourceSkyline)((List)jobSkylineLists.get(recurrenceId)).get(0)).getSkylineList().getCumulative().size());
    }

    @Test
    public final void testJobIdNotFoundInJobFailure() throws SkylineStoreException, IOException, ParseException, ResourceEstimatorException, DataFieldNotFoundException {
        String logFile = "src/test/resources/trace/invalidLog5.txt";
        this.parseFile("src/test/resources/trace/invalidLog5.txt");
        RecurrenceId recurrenceId = new RecurrenceId("Test", "5");
        Map jobSkylineLists = this.skylineStore.getHistory(recurrenceId);
        Assert.assertEquals((long)this.logParserUtil.stringToUnixTimestamp("06/21/2017 16:10:13"), (long)((ResourceSkyline)((List)jobSkylineLists.get(recurrenceId)).get(0)).getJobSubmissionTime());
    }

    @Test
    public final void testJobIdNotFoundInJobFinish() throws SkylineStoreException, IOException, ParseException, ResourceEstimatorException, DataFieldNotFoundException {
        String logFile = "src/test/resources/trace/invalidLog6.txt";
        this.parseFile("src/test/resources/trace/invalidLog6.txt");
        RecurrenceId recurrenceId = new RecurrenceId("Test", "6");
        Assert.assertNull((Object)this.skylineStore.getHistory(recurrenceId));
    }

    @Test
    public final void testRecurrenceIdNotFoundInJobFinish() throws SkylineStoreException, IOException, ParseException, ResourceEstimatorException, DataFieldNotFoundException {
        String logFile = "src/test/resources/trace/invalidLog7.txt";
        this.parseFile("src/test/resources/trace/invalidLog7.txt");
        RecurrenceId recurrenceId = new RecurrenceId("Test", "7");
        Assert.assertNull((Object)this.skylineStore.getHistory(recurrenceId));
    }

    @Test
    public final void testJobIdNotFoundInResourceSpec() throws SkylineStoreException, IOException, ParseException, ResourceEstimatorException, DataFieldNotFoundException {
        String logFile = "src/test/resources/trace/invalidLog8.txt";
        this.parseFile("src/test/resources/trace/invalidLog8.txt");
        RecurrenceId recurrenceId = new RecurrenceId("Test", "8");
        Map jobSkylineLists = this.skylineStore.getHistory(recurrenceId);
        Assert.assertEquals((long)1024L, (long)((ResourceSkyline)((List)jobSkylineLists.get(recurrenceId)).get(0)).getContainerSpec().getMemorySize());
        Assert.assertEquals((long)1L, (long)((ResourceSkyline)((List)jobSkylineLists.get(recurrenceId)).get(0)).getContainerSpec().getVirtualCores());
    }

    @Test
    public final void testResourceSpecNotFoundInResourceSpec() throws SkylineStoreException, IOException, ParseException, ResourceEstimatorException, DataFieldNotFoundException {
        String logFile = "src/test/resources/trace/invalidLog9.txt";
        this.parseFile("src/test/resources/trace/invalidLog9.txt");
        RecurrenceId recurrenceId = new RecurrenceId("Test", "9");
        Map jobSkylineLists = this.skylineStore.getHistory(recurrenceId);
        Assert.assertEquals((long)1024L, (long)((ResourceSkyline)((List)jobSkylineLists.get(recurrenceId)).get(0)).getContainerSpec().getMemorySize());
        Assert.assertEquals((long)1L, (long)((ResourceSkyline)((List)jobSkylineLists.get(recurrenceId)).get(0)).getContainerSpec().getVirtualCores());
    }

    @After
    public final void cleanUp() {
        this.skylineStore = null;
        this.logParserUtil = null;
    }
}

