/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.resourceestimator.translator.impl;

import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.resourceestimator.common.api.RecurrenceId;
import org.apache.hadoop.resourceestimator.common.api.ResourceSkyline;
import org.apache.hadoop.resourceestimator.common.exception.ResourceEstimatorException;
import org.apache.hadoop.resourceestimator.skylinestore.api.HistorySkylineStore;
import org.apache.hadoop.resourceestimator.skylinestore.api.SkylineStore;
import org.apache.hadoop.resourceestimator.skylinestore.exceptions.SkylineStoreException;
import org.apache.hadoop.resourceestimator.skylinestore.impl.InMemoryStore;
import org.apache.hadoop.resourceestimator.translator.api.LogParser;
import org.apache.hadoop.resourceestimator.translator.exceptions.DataFieldNotFoundException;
import org.apache.hadoop.resourceestimator.translator.impl.BaseLogParser;
import org.apache.hadoop.resourceestimator.translator.impl.LogParserUtil;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNativeParser {
    private LogParserUtil logParserUtil = new LogParserUtil();
    private SkylineStore skylineStore;

    @Before
    public final void setup() throws ResourceEstimatorException {
        this.skylineStore = new InMemoryStore();
        BaseLogParser nativeParser = new BaseLogParser();
        Configuration config = new Configuration();
        config.addResource("resourceestimator-config.xml");
        nativeParser.init(config, (HistorySkylineStore)this.skylineStore);
        this.logParserUtil.setLogParser((LogParser)nativeParser);
    }

    private void parseFile(String logFile) throws SkylineStoreException, IOException, ParseException, ResourceEstimatorException, DataFieldNotFoundException {
        this.logParserUtil.parseLog(logFile);
    }

    @Test
    public final void testParse() throws SkylineStoreException, IOException, ParseException, ResourceEstimatorException, DataFieldNotFoundException {
        int k;
        String logFile = "src/test/resources/trace/nativeLog.txt";
        this.parseFile("src/test/resources/trace/nativeLog.txt");
        RecurrenceId recurrenceId = new RecurrenceId("tpch_q12", "tpch_q12_0");
        Map jobSkylineLists = this.skylineStore.getHistory(recurrenceId);
        Assert.assertEquals((long)1L, (long)jobSkylineLists.size());
        List jobHistory = (List)jobSkylineLists.get(recurrenceId);
        Assert.assertEquals((long)1L, (long)jobHistory.size());
        ResourceSkyline resourceSkyline = (ResourceSkyline)jobHistory.get(0);
        Assert.assertEquals((double)0.0, (double)resourceSkyline.getJobInputDataSize(), (double)0.0);
        Assert.assertEquals((Object)"tpch_q12_0", (Object)resourceSkyline.getJobId());
        Assert.assertEquals((long)0L, (long)resourceSkyline.getJobSubmissionTime());
        Assert.assertEquals((long)25L, (long)resourceSkyline.getJobFinishTime());
        Assert.assertEquals((long)1024L, (long)resourceSkyline.getContainerSpec().getMemorySize());
        Assert.assertEquals((long)1L, (long)resourceSkyline.getContainerSpec().getVirtualCores());
        RLESparseResourceAllocation skylineLists = resourceSkyline.getSkylineList();
        for (k = 0; k < 10; ++k) {
            Assert.assertEquals((long)1L, (long)(skylineLists.getCapacityAtTime((long)k).getMemorySize() / 1024L));
        }
        for (k = 10; k < 15; ++k) {
            Assert.assertEquals((long)1074L, (long)(skylineLists.getCapacityAtTime((long)k).getMemorySize() / 1024L));
        }
        for (k = 15; k < 20; ++k) {
            Assert.assertEquals((long)2538L, (long)(skylineLists.getCapacityAtTime((long)k).getMemorySize() / 1024L));
        }
        for (k = 20; k < 25; ++k) {
            Assert.assertEquals((long)2468L, (long)(skylineLists.getCapacityAtTime((long)k).getMemorySize() / 1024L));
        }
        Assert.assertEquals((long)0L, (long)(skylineLists.getCapacityAtTime(25L).getMemorySize() / 1024L));
    }

    @After
    public final void cleanUp() {
        this.skylineStore = null;
        this.logParserUtil = null;
    }
}

