/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.resourceestimator.translator.impl;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.resourceestimator.common.api.RecurrenceId;
import org.apache.hadoop.resourceestimator.common.api.ResourceSkyline;
import org.apache.hadoop.resourceestimator.translator.api.JobMetaData;
import org.apache.hadoop.resourceestimator.translator.api.SingleLineParser;
import org.apache.hadoop.resourceestimator.translator.exceptions.DataFieldNotFoundException;
import org.apache.hadoop.resourceestimator.translator.impl.LogParserUtil;
import org.apache.hadoop.yarn.api.records.Resource;

public class RmSingleLineParser
implements SingleLineParser {
    private static final LogParserUtil PARSERUTIL = new LogParserUtil();
    private static final Pattern FILTER_PATTERN = Pattern.compile("(Submit Application Request|AM Allocated Container|AM Released Container|finalState=FAILED|ApplicationSummary|, Resource:)");
    private static final Pattern SUBMISSION_PATTERN = Pattern.compile("APPID=(\\w+)");
    private static final Pattern FAIL_PATTERN = Pattern.compile("appattempt_(\\d+_\\d+)_\\d+");
    private static final Pattern FINISH_PATTERN = Pattern.compile("appId=(\\w+).*?name=(\\w+)\\-(\\w+)");
    private static final Pattern CONTAINER_EVENT_PATTERN = Pattern.compile("APPID=(\\w+).*?CONTAINERID=(\\w+)");
    private static final Pattern CONTAINER_SPEC_PATTERN = Pattern.compile("(container_[^_]+|appattempt)_(\\d+_\\d+).*?memory:(\\d+),\\svCores:(\\d+)");

    private void aggregateSkyline(ResourceSkyline resourceSkyline, RecurrenceId recurrenceId, Map<RecurrenceId, List<ResourceSkyline>> skylineRecords) {
        List<ResourceSkyline> resourceSkylines = skylineRecords.get(recurrenceId);
        if (resourceSkylines == null) {
            resourceSkylines = new ArrayList<ResourceSkyline>();
            skylineRecords.put(recurrenceId, resourceSkylines);
        }
        resourceSkylines.add(resourceSkyline);
    }

    public final void parseLine(String logLine, Map<String, JobMetaData> jobMetas, Map<RecurrenceId, List<ResourceSkyline>> skylineRecords) throws DataFieldNotFoundException, ParseException {
        String[] splits = logLine.split(",", 5);
        if (splits.length < 5) {
            return;
        }
        Matcher jobEventMatcher = FILTER_PATTERN.matcher(splits[4]);
        if (!jobEventMatcher.find()) {
            return;
        }
        long date = PARSERUTIL.stringToUnixTimestamp(splits[1]);
        String tail = splits[4].split("\\s+", 4)[3];
        switch (jobEventMatcher.group(1)) {
            case "Submit Application Request": {
                Matcher appIdMatch = SUBMISSION_PATTERN.matcher(tail);
                if (appIdMatch.find()) {
                    String appId = appIdMatch.group(1);
                    jobMetas.put(appId, new JobMetaData(date));
                    break;
                }
                throw new DataFieldNotFoundException(tail);
            }
            case "AM Allocated Container": {
                Matcher containerEventMatcher = CONTAINER_EVENT_PATTERN.matcher(tail);
                if (containerEventMatcher.find()) {
                    String appId = containerEventMatcher.group(1);
                    String containerId = containerEventMatcher.group(2);
                    JobMetaData appMeta = jobMetas.get(appId);
                    if (appMeta == null) break;
                    appMeta.setContainerStart(containerId, date);
                    break;
                }
                throw new DataFieldNotFoundException(tail);
            }
            case ", Resource:": {
                Matcher containerSpecMatcher = CONTAINER_SPEC_PATTERN.matcher(tail);
                if (containerSpecMatcher.find()) {
                    String appId = "application_" + containerSpecMatcher.group(2);
                    JobMetaData appMeta = jobMetas.get(appId);
                    if (appMeta == null) break;
                    long memAlloc = Long.parseLong(containerSpecMatcher.group(3));
                    int cpuAlloc = Integer.parseInt(containerSpecMatcher.group(4));
                    Resource containerAlloc = Resource.newInstance((long)memAlloc, (int)cpuAlloc);
                    appMeta.getResourceSkyline().setContainerSpec(containerAlloc);
                    break;
                }
                throw new DataFieldNotFoundException(tail);
            }
            case "AM Released Container": {
                Matcher containerEventMatcher = CONTAINER_EVENT_PATTERN.matcher(tail);
                if (containerEventMatcher.find()) {
                    String appId = containerEventMatcher.group(1);
                    JobMetaData appMeta = jobMetas.get(appId);
                    if (appMeta == null) break;
                    String containerId = containerEventMatcher.group(2);
                    appMeta.setContainerEnd(containerId, date);
                    break;
                }
                throw new DataFieldNotFoundException(tail);
            }
            case "finalState=FAILED": {
                Matcher failMatcher = FAIL_PATTERN.matcher(tail);
                if (failMatcher.find()) {
                    String appId = "application_" + failMatcher.group(1);
                    if (!jobMetas.containsKey(appId)) break;
                    jobMetas.put(appId, new JobMetaData(date));
                    break;
                }
                throw new DataFieldNotFoundException(tail);
            }
            case "ApplicationSummary": {
                Matcher finishMatcher = FINISH_PATTERN.matcher(tail);
                if (finishMatcher.find()) {
                    String appId = finishMatcher.group(1);
                    String pipelineId = finishMatcher.group(2);
                    String runId = finishMatcher.group(3);
                    RecurrenceId recurrenceId = new RecurrenceId(pipelineId, runId);
                    JobMetaData appMeta = jobMetas.remove(appId);
                    if (appMeta == null) break;
                    appMeta.setRecurrenceId(recurrenceId).setJobFinishTime(date).getResourceSkyline().setJobInputDataSize(0.0);
                    appMeta.createSkyline();
                    ResourceSkyline resourceSkyline = appMeta.getResourceSkyline();
                    resourceSkyline.setJobId(appId);
                    this.aggregateSkyline(resourceSkyline, recurrenceId, skylineRecords);
                    break;
                }
                throw new DataFieldNotFoundException(tail);
            }
        }
    }
}

