/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.resourceestimator.translator.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.resourceestimator.common.api.RecurrenceId;
import org.apache.hadoop.resourceestimator.common.api.ResourceSkyline;
import org.apache.hadoop.resourceestimator.common.config.ResourceEstimatorConfiguration;
import org.apache.hadoop.resourceestimator.common.config.ResourceEstimatorUtil;
import org.apache.hadoop.resourceestimator.common.exception.ResourceEstimatorException;
import org.apache.hadoop.resourceestimator.skylinestore.api.HistorySkylineStore;
import org.apache.hadoop.resourceestimator.skylinestore.exceptions.SkylineStoreException;
import org.apache.hadoop.resourceestimator.translator.api.JobMetaData;
import org.apache.hadoop.resourceestimator.translator.api.LogParser;
import org.apache.hadoop.resourceestimator.translator.api.SingleLineParser;
import org.apache.hadoop.resourceestimator.translator.exceptions.DataFieldNotFoundException;
import org.apache.hadoop.resourceestimator.translator.validator.ParserValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseLogParser
implements LogParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseLogParser.class);
    private static final ParserValidator INPUT_VALIDATOR = new ParserValidator();
    private SingleLineParser singleLineParser;
    private HistorySkylineStore historySkylineStore;

    public void init(Configuration config, HistorySkylineStore skylineStore) throws ResourceEstimatorException {
        this.singleLineParser = (SingleLineParser)ResourceEstimatorUtil.createProviderInstance((Configuration)config, (String)"resourceestimator.translator.line-parser", (String)ResourceEstimatorConfiguration.DEFAULT_TRANSLATOR_LINE_PARSER, SingleLineParser.class);
        this.historySkylineStore = skylineStore;
    }

    private void addToSkylineStore(Map<RecurrenceId, List<ResourceSkyline>> skylineRecords) throws SkylineStoreException {
        for (Map.Entry<RecurrenceId, List<ResourceSkyline>> entry : skylineRecords.entrySet()) {
            this.historySkylineStore.addHistory(entry.getKey(), entry.getValue());
        }
    }

    public void parseLine(String logLine, Map<String, JobMetaData> jobMetas, Map<RecurrenceId, List<ResourceSkyline>> skylineRecords) throws DataFieldNotFoundException, ParseException {
        this.singleLineParser.parseLine(logLine, jobMetas, skylineRecords);
    }

    public final void parseStream(InputStream logs) throws SkylineStoreException, IOException {
        if (!INPUT_VALIDATOR.validate(logs)) {
            LOGGER.error("Input validation fails, please specify with valid input parameters.");
            return;
        }
        HashMap skylineRecords = new HashMap();
        HashMap jobMetas = new HashMap();
        BufferedReader bf = new BufferedReader(new InputStreamReader(logs, StandardCharsets.UTF_8));
        String line = null;
        while ((line = bf.readLine()) != null) {
            try {
                this.parseLine(line, jobMetas, skylineRecords);
            }
            catch (DataFieldNotFoundException e) {
                LOGGER.debug("Data field not found", (Throwable)e);
            }
            catch (ParseException e) {
                LOGGER.debug("Date conversion error", (Throwable)e);
            }
        }
        this.addToSkylineStore(skylineRecords);
    }

    public final void close() {
        this.historySkylineStore = null;
    }
}

