/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.resourceestimator.translator.api;

import java.text.ParseException;
import org.apache.hadoop.resourceestimator.common.api.RecurrenceId;
import org.apache.hadoop.resourceestimator.translator.api.JobMetaData;
import org.apache.hadoop.resourceestimator.translator.impl.LogParserUtil;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestJobMetaData {
    private LogParserUtil logParserUtil = new LogParserUtil();
    private JobMetaData jobMetaData;
    private RecurrenceId recurrenceId;

    @Before
    public final void setup() throws ParseException {
        this.recurrenceId = new RecurrenceId("Fraud Detection", "17/07/16 16:27:25");
        this.jobMetaData = new JobMetaData(this.logParserUtil.stringToUnixTimestamp("17/07/16 16:27:25"));
        this.jobMetaData.setRecurrenceId(this.recurrenceId);
        this.jobMetaData.setContainerStart("C1", this.logParserUtil.stringToUnixTimestamp("17/07/16 16:27:30"));
        this.jobMetaData.setContainerEnd("C1", this.logParserUtil.stringToUnixTimestamp("17/07/16 16:37:30"));
        this.jobMetaData.setContainerStart("C2", this.logParserUtil.stringToUnixTimestamp("17/07/16 16:27:40"));
        this.jobMetaData.setContainerEnd("C2", this.logParserUtil.stringToUnixTimestamp("17/07/16 16:37:40"));
        this.jobMetaData.setJobFinishTime(this.logParserUtil.stringToUnixTimestamp("17/07/16 16:37:45"));
        Resource containerAlloc = Resource.newInstance((int)1, (int)1);
        this.jobMetaData.getResourceSkyline().setContainerSpec(containerAlloc);
        this.jobMetaData.getResourceSkyline().setJobInputDataSize(1024.5);
        this.jobMetaData.createSkyline();
    }

    @Test
    public final void testGetContainerSpec() {
        Resource containerAlloc = this.jobMetaData.getResourceSkyline().getContainerSpec();
        Resource containerAlloc2 = Resource.newInstance((int)1, (int)1);
        Assert.assertEquals((long)containerAlloc.getMemorySize(), (long)containerAlloc2.getMemorySize());
        Assert.assertEquals((long)containerAlloc.getVirtualCores(), (long)containerAlloc2.getVirtualCores());
    }

    @Test
    public final void testGetJobSize() {
        Assert.assertEquals((double)this.jobMetaData.getResourceSkyline().getJobInputDataSize(), (double)1024.5, (double)0.0);
    }

    @Test
    public final void testGetRecurrenceeId() {
        RecurrenceId recurrenceIdTest = new RecurrenceId("Fraud Detection", "17/07/16 16:27:25");
        Assert.assertEquals((Object)recurrenceIdTest, (Object)this.jobMetaData.getRecurrenceId());
    }

    @Test
    public final void testStringToUnixTimestamp() throws ParseException {
        long submissionTime = this.logParserUtil.stringToUnixTimestamp("17/07/16 16:27:25");
        Assert.assertEquals((long)this.jobMetaData.getResourceSkyline().getJobSubmissionTime(), (long)submissionTime);
    }

    @Test
    public final void testResourceSkyline() {
        int k;
        RLESparseResourceAllocation skylineList = this.jobMetaData.getResourceSkyline().getSkylineList();
        int containerCPU = this.jobMetaData.getResourceSkyline().getContainerSpec().getVirtualCores();
        for (k = 0; k < 5; ++k) {
            Assert.assertEquals((long)0L, (long)(skylineList.getCapacityAtTime((long)k).getVirtualCores() / containerCPU));
        }
        for (k = 5; k < 15; ++k) {
            Assert.assertEquals((long)1L, (long)(skylineList.getCapacityAtTime((long)k).getVirtualCores() / containerCPU));
        }
        for (k = 15; k < 605; ++k) {
            Assert.assertEquals((long)2L, (long)(skylineList.getCapacityAtTime((long)k).getVirtualCores() / containerCPU));
        }
        for (k = 605; k < 615; ++k) {
            Assert.assertEquals((long)1L, (long)(skylineList.getCapacityAtTime((long)k).getVirtualCores() / containerCPU));
        }
        Assert.assertEquals((long)0L, (long)(skylineList.getCapacityAtTime(615L).getVirtualCores() / containerCPU));
    }

    @Test
    public final void testContainerReleaseTimeMissing() throws ParseException {
        int k;
        this.recurrenceId = new RecurrenceId("Fraud Detection", "17/07/16 16:27:25");
        this.jobMetaData = new JobMetaData(this.logParserUtil.stringToUnixTimestamp("17/07/16 16:27:25"));
        this.jobMetaData.setRecurrenceId(this.recurrenceId);
        this.jobMetaData.setContainerStart("C1", this.logParserUtil.stringToUnixTimestamp("17/07/16 16:27:30"));
        this.jobMetaData.setContainerEnd("C1", this.logParserUtil.stringToUnixTimestamp("17/07/16 16:37:30"));
        this.jobMetaData.setContainerStart("C2", this.logParserUtil.stringToUnixTimestamp("17/07/16 16:27:40"));
        this.jobMetaData.setJobFinishTime(this.logParserUtil.stringToUnixTimestamp("17/07/16 16:37:45"));
        Resource containerAlloc = Resource.newInstance((int)1, (int)1);
        this.jobMetaData.getResourceSkyline().setContainerSpec(containerAlloc);
        this.jobMetaData.getResourceSkyline().setJobInputDataSize(1024.5);
        this.jobMetaData.createSkyline();
        RLESparseResourceAllocation skylineList = this.jobMetaData.getResourceSkyline().getSkylineList();
        int containerCPU = this.jobMetaData.getResourceSkyline().getContainerSpec().getVirtualCores();
        for (k = 0; k < 5; ++k) {
            Assert.assertEquals((long)0L, (long)(skylineList.getCapacityAtTime((long)k).getVirtualCores() / containerCPU));
        }
        for (k = 5; k < 605; ++k) {
            Assert.assertEquals((long)1L, (long)(skylineList.getCapacityAtTime((long)k).getVirtualCores() / containerCPU));
        }
        Assert.assertEquals((long)0L, (long)(skylineList.getCapacityAtTime(605L).getVirtualCores() / containerCPU));
    }

    @After
    public final void cleanUp() {
        this.jobMetaData = null;
        this.recurrenceId = null;
        this.logParserUtil = null;
    }
}

