/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.resourceestimator.solver.impl;

import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.resourceestimator.common.exception.ResourceEstimatorException;
import org.apache.hadoop.resourceestimator.skylinestore.exceptions.SkylineStoreException;
import org.apache.hadoop.resourceestimator.solver.api.Solver;
import org.apache.hadoop.resourceestimator.solver.exceptions.InvalidInputException;
import org.apache.hadoop.resourceestimator.solver.exceptions.SolverException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class TestSolver {
    private Solver solver;

    protected abstract Solver createSolver() throws ResourceEstimatorException;

    @Before
    public void setup() throws SolverException, IOException, SkylineStoreException, ResourceEstimatorException {
        this.solver = this.createSolver();
    }

    @Test(expected=InvalidInputException.class)
    public void testNullJobHistory() throws SolverException, SkylineStoreException {
        this.solver.solve(null);
    }

    @Test(expected=InvalidInputException.class)
    public void testEmptyJobHistory() throws SolverException, SkylineStoreException {
        HashMap jobHistoryInvalid = new HashMap();
        this.solver.solve(jobHistoryInvalid);
    }

    @After
    public final void cleanUp() {
        this.solver.close();
        this.solver = null;
    }
}

