/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.resourceestimator.solver.impl;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.resourceestimator.common.api.RecurrenceId;
import org.apache.hadoop.resourceestimator.common.api.ResourceSkyline;
import org.apache.hadoop.resourceestimator.common.exception.ResourceEstimatorException;
import org.apache.hadoop.resourceestimator.skylinestore.api.HistorySkylineStore;
import org.apache.hadoop.resourceestimator.skylinestore.api.PredictionSkylineStore;
import org.apache.hadoop.resourceestimator.skylinestore.exceptions.SkylineStoreException;
import org.apache.hadoop.resourceestimator.skylinestore.impl.InMemoryStore;
import org.apache.hadoop.resourceestimator.solver.api.Solver;
import org.apache.hadoop.resourceestimator.solver.exceptions.SolverException;
import org.apache.hadoop.resourceestimator.solver.impl.LpSolver;
import org.apache.hadoop.resourceestimator.solver.impl.TestSolver;
import org.apache.hadoop.resourceestimator.translator.api.LogParser;
import org.apache.hadoop.resourceestimator.translator.exceptions.DataFieldNotFoundException;
import org.apache.hadoop.resourceestimator.translator.impl.BaseLogParser;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.junit.Assert;
import org.junit.Test;

public class TestLpSolver
extends TestSolver {
    private static final LogParser SAMPLEPARSER = new BaseLogParser();
    private Solver solver;
    private InMemoryStore skylineStore = new InMemoryStore();

    private void parseLog(String inputLog) throws SolverException, IOException, SkylineStoreException, DataFieldNotFoundException, ParseException {
        FileInputStream logs = new FileInputStream(inputLog);
        SAMPLEPARSER.parseStream((InputStream)logs);
    }

    protected Solver createSolver() throws ResourceEstimatorException {
        this.solver = new LpSolver();
        Configuration config = new Configuration();
        config.addResource("resourceestimator-config.xml");
        this.solver.init(config, (PredictionSkylineStore)this.skylineStore);
        SAMPLEPARSER.init(config, (HistorySkylineStore)this.skylineStore);
        return this.solver;
    }

    @Test
    public void testSolve() throws IOException, SkylineStoreException, SolverException, ResourceEstimatorException, DataFieldNotFoundException, ParseException {
        this.parseLog("src/test/resources/lp/tpch_q12.txt");
        RecurrenceId recurrenceId = new RecurrenceId("tpch_q12", "*");
        Map jobHistory = this.skylineStore.getHistory(recurrenceId);
        this.solver = this.createSolver();
        RLESparseResourceAllocation result = this.solver.solve(jobHistory);
        String file = "src/test/resources/lp/answer.txt";
        InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8"));
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String line = bufferedReader.readLine();
        Configuration config = new Configuration();
        config.addResource(new Path("resourceestimator-config.xml"));
        int timeInterval = config.getInt("resourceestimator.timeInterval", 5);
        long containerMemAlloc = ((ResourceSkyline)((List)jobHistory.entrySet().iterator().next().getValue()).get(0)).getContainerSpec().getMemorySize();
        int count = 0;
        int numContainer = 0;
        while (line != null) {
            numContainer = (int)(result.getCapacityAtTime((long)(count * timeInterval)).getMemorySize() / containerMemAlloc);
            Assert.assertEquals((double)Integer.parseInt(line), (double)numContainer, (double)(0.1 * (double)Integer.parseInt(line)));
            line = bufferedReader.readLine();
            ++count;
        }
        ((Reader)fileReader).close();
        bufferedReader.close();
    }
}

