/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.resourceestimator.skylinestore.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.hadoop.resourceestimator.common.api.RecurrenceId;
import org.apache.hadoop.resourceestimator.common.api.ResourceSkyline;
import org.apache.hadoop.resourceestimator.skylinestore.api.SkylineStore;
import org.apache.hadoop.resourceestimator.skylinestore.exceptions.DuplicateRecurrenceIdException;
import org.apache.hadoop.resourceestimator.skylinestore.exceptions.EmptyResourceSkylineException;
import org.apache.hadoop.resourceestimator.skylinestore.exceptions.NullPipelineIdException;
import org.apache.hadoop.resourceestimator.skylinestore.exceptions.NullRLESparseResourceAllocationException;
import org.apache.hadoop.resourceestimator.skylinestore.exceptions.NullRecurrenceIdException;
import org.apache.hadoop.resourceestimator.skylinestore.exceptions.NullResourceSkylineException;
import org.apache.hadoop.resourceestimator.skylinestore.exceptions.RecurrenceIdNotFoundException;
import org.apache.hadoop.resourceestimator.skylinestore.exceptions.SkylineStoreException;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class TestSkylineStore {
    private SkylineStore skylineStore;
    private TreeMap<Long, Resource> resourceOverTime;
    private RLESparseResourceAllocation skylineList;
    private ReservationInterval riAdd;
    private Resource resource;

    protected abstract SkylineStore createSkylineStore();

    @Before
    public final void setup() {
        this.skylineStore = this.createSkylineStore();
        this.resourceOverTime = new TreeMap();
        this.resource = Resource.newInstance((int)102400, (int)100);
    }

    private void compare(ResourceSkyline skyline1, ResourceSkyline skyline2) {
        Assert.assertEquals((Object)skyline1.getJobId(), (Object)skyline2.getJobId());
        Assert.assertEquals((double)skyline1.getJobInputDataSize(), (double)skyline2.getJobInputDataSize(), (double)0.0);
        Assert.assertEquals((long)skyline1.getJobSubmissionTime(), (long)skyline2.getJobSubmissionTime());
        Assert.assertEquals((long)skyline1.getJobFinishTime(), (long)skyline2.getJobFinishTime());
        Assert.assertEquals((long)skyline1.getContainerSpec().getMemorySize(), (long)skyline2.getContainerSpec().getMemorySize());
        Assert.assertEquals((long)skyline1.getContainerSpec().getVirtualCores(), (long)skyline2.getContainerSpec().getVirtualCores());
        Assert.assertEquals((Object)true, (Object)skyline2.getSkylineList().equals(skyline1.getSkylineList()));
    }

    private void addToStore(RecurrenceId recurrenceId, ResourceSkyline resourceSkyline) throws SkylineStoreException {
        ArrayList<ResourceSkyline> resourceSkylines = new ArrayList<ResourceSkyline>();
        resourceSkylines.add(resourceSkyline);
        this.skylineStore.addHistory(recurrenceId, resourceSkylines);
        List resourceSkylinesGet = (List)this.skylineStore.getHistory(recurrenceId).get(recurrenceId);
        Assert.assertTrue((boolean)resourceSkylinesGet.contains(resourceSkyline));
    }

    private ResourceSkyline getSkyline(int n) {
        this.skylineList = new RLESparseResourceAllocation((NavigableMap)this.resourceOverTime, (ResourceCalculator)new DefaultResourceCalculator());
        for (int i = 0; i < n; ++i) {
            this.riAdd = new ReservationInterval((long)(i * 10), (long)((i + 1) * 10));
            this.skylineList.addInterval(this.riAdd, this.resource);
        }
        ResourceSkyline resourceSkyline = new ResourceSkyline(Integer.toString(n), 1024.5, 0L, 20L, this.resource, this.skylineList);
        return resourceSkyline;
    }

    @Test
    public final void testGetHistory() throws SkylineStoreException {
        List getSkylines;
        RecurrenceId recurrenceId1 = new RecurrenceId("FraudDetection", "17/06/20 00:00:00");
        ResourceSkyline resourceSkyline1 = this.getSkyline(1);
        this.addToStore(recurrenceId1, resourceSkyline1);
        ResourceSkyline resourceSkyline2 = this.getSkyline(2);
        this.addToStore(recurrenceId1, resourceSkyline2);
        RecurrenceId recurrenceId2 = new RecurrenceId("FraudDetection", "17/06/21 00:00:00");
        ResourceSkyline resourceSkyline3 = this.getSkyline(3);
        this.addToStore(recurrenceId2, resourceSkyline3);
        ResourceSkyline resourceSkyline4 = this.getSkyline(4);
        this.addToStore(recurrenceId2, resourceSkyline4);
        RecurrenceId recurrenceId3 = new RecurrenceId("Random", "17/06/20 00:00:00");
        this.addToStore(recurrenceId3, resourceSkyline1);
        this.addToStore(recurrenceId3, resourceSkyline2);
        Map jobHistory = this.skylineStore.getHistory(recurrenceId1);
        Assert.assertEquals((long)1L, (long)jobHistory.size());
        for (Map.Entry entry : jobHistory.entrySet()) {
            Assert.assertEquals((Object)recurrenceId1, entry.getKey());
            List getSkylines2 = (List)entry.getValue();
            Assert.assertEquals((long)2L, (long)getSkylines2.size());
            this.compare(resourceSkyline1, (ResourceSkyline)getSkylines2.get(0));
            this.compare(resourceSkyline2, (ResourceSkyline)getSkylines2.get(1));
        }
        RecurrenceId recurrenceIdTest = new RecurrenceId("FraudDetection", "*");
        jobHistory = this.skylineStore.getHistory(recurrenceIdTest);
        Assert.assertEquals((long)2L, (long)jobHistory.size());
        for (Map.Entry entry : jobHistory.entrySet()) {
            Assert.assertEquals((Object)recurrenceId1.getPipelineId(), (Object)((RecurrenceId)entry.getKey()).getPipelineId());
            getSkylines = (List)entry.getValue();
            if (((RecurrenceId)entry.getKey()).getRunId().equals("17/06/20 00:00:00")) {
                Assert.assertEquals((long)2L, (long)getSkylines.size());
                this.compare(resourceSkyline1, (ResourceSkyline)getSkylines.get(0));
                this.compare(resourceSkyline2, (ResourceSkyline)getSkylines.get(1));
                continue;
            }
            Assert.assertEquals((Object)((RecurrenceId)entry.getKey()).getRunId(), (Object)"17/06/21 00:00:00");
            Assert.assertEquals((long)2L, (long)getSkylines.size());
            this.compare(resourceSkyline3, (ResourceSkyline)getSkylines.get(0));
            this.compare(resourceSkyline4, (ResourceSkyline)getSkylines.get(1));
        }
        recurrenceIdTest = new RecurrenceId("*", "some random runId");
        jobHistory = this.skylineStore.getHistory(recurrenceIdTest);
        Assert.assertEquals((long)3L, (long)jobHistory.size());
        for (Map.Entry entry : jobHistory.entrySet()) {
            if (((RecurrenceId)entry.getKey()).getPipelineId().equals("FraudDetection")) {
                getSkylines = (List)entry.getValue();
                if (((RecurrenceId)entry.getKey()).getRunId().equals("17/06/20 00:00:00")) {
                    Assert.assertEquals((long)2L, (long)getSkylines.size());
                    this.compare(resourceSkyline1, (ResourceSkyline)getSkylines.get(0));
                    this.compare(resourceSkyline2, (ResourceSkyline)getSkylines.get(1));
                    continue;
                }
                Assert.assertEquals((Object)((RecurrenceId)entry.getKey()).getRunId(), (Object)"17/06/21 00:00:00");
                Assert.assertEquals((long)2L, (long)getSkylines.size());
                this.compare(resourceSkyline3, (ResourceSkyline)getSkylines.get(0));
                this.compare(resourceSkyline4, (ResourceSkyline)getSkylines.get(1));
                continue;
            }
            Assert.assertEquals((Object)"Random", (Object)((RecurrenceId)entry.getKey()).getPipelineId());
            Assert.assertEquals((Object)((RecurrenceId)entry.getKey()).getRunId(), (Object)"17/06/20 00:00:00");
            getSkylines = (List)entry.getValue();
            Assert.assertEquals((long)2L, (long)getSkylines.size());
            this.compare(resourceSkyline1, (ResourceSkyline)getSkylines.get(0));
            this.compare(resourceSkyline2, (ResourceSkyline)getSkylines.get(1));
        }
        recurrenceIdTest = new RecurrenceId("some random pipelineId", "some random runId");
        Assert.assertNull((Object)this.skylineStore.getHistory(recurrenceIdTest));
    }

    @Test
    public final void testGetEstimation() throws SkylineStoreException {
        RLESparseResourceAllocation skylineList2 = new RLESparseResourceAllocation((NavigableMap)this.resourceOverTime, (ResourceCalculator)new DefaultResourceCalculator());
        for (int i = 0; i < 5; ++i) {
            this.riAdd = new ReservationInterval((long)(i * 10), (long)((i + 1) * 10));
            skylineList2.addInterval(this.riAdd, this.resource);
        }
        this.skylineStore.addEstimation("FraudDetection", skylineList2);
        RLESparseResourceAllocation estimation = this.skylineStore.getEstimation("FraudDetection");
        for (int i = 0; i < 50; ++i) {
            Assert.assertEquals((Object)skylineList2.getCapacityAtTime((long)i), (Object)estimation.getCapacityAtTime((long)i));
        }
    }

    @Test(expected=NullRecurrenceIdException.class)
    public final void testGetNullRecurrenceId() throws SkylineStoreException {
        RecurrenceId recurrenceId1 = new RecurrenceId("FraudDetection", "17/06/20 00:00:00");
        ResourceSkyline resourceSkyline1 = this.getSkyline(1);
        this.addToStore(recurrenceId1, resourceSkyline1);
        ResourceSkyline resourceSkyline2 = this.getSkyline(2);
        this.addToStore(recurrenceId1, resourceSkyline2);
        RecurrenceId recurrenceId2 = new RecurrenceId("FraudDetection", "17/06/21 00:00:00");
        ResourceSkyline resourceSkyline3 = this.getSkyline(3);
        this.addToStore(recurrenceId2, resourceSkyline3);
        ResourceSkyline resourceSkyline4 = this.getSkyline(4);
        this.addToStore(recurrenceId2, resourceSkyline4);
        RecurrenceId recurrenceId3 = new RecurrenceId("Random", "17/06/20 00:00:00");
        this.addToStore(recurrenceId3, resourceSkyline1);
        this.addToStore(recurrenceId3, resourceSkyline2);
        this.skylineStore.getHistory(null);
    }

    @Test(expected=NullPipelineIdException.class)
    public final void testGetNullPipelineIdException() throws SkylineStoreException {
        this.skylineStore.getEstimation(null);
    }

    @Test
    public final void testAddNormal() throws SkylineStoreException {
        RecurrenceId recurrenceId = new RecurrenceId("FraudDetection", "17/06/20 00:00:00");
        ResourceSkyline resourceSkyline1 = this.getSkyline(1);
        this.addToStore(recurrenceId, resourceSkyline1);
        ArrayList<ResourceSkyline> resourceSkylines = new ArrayList<ResourceSkyline>();
        resourceSkylines.add(null);
        ResourceSkyline resourceSkyline2 = this.getSkyline(2);
        resourceSkylines.add(resourceSkyline2);
        this.skylineStore.addHistory(recurrenceId, resourceSkylines);
        Map jobHistory = this.skylineStore.getHistory(recurrenceId);
        Assert.assertEquals((long)1L, (long)jobHistory.size());
        for (Map.Entry entry : jobHistory.entrySet()) {
            Assert.assertEquals((Object)recurrenceId, entry.getKey());
            List getSkylines = (List)entry.getValue();
            Assert.assertEquals((long)2L, (long)getSkylines.size());
            this.compare(resourceSkyline1, (ResourceSkyline)getSkylines.get(0));
            this.compare(resourceSkyline2, (ResourceSkyline)getSkylines.get(1));
        }
    }

    @Test(expected=NullRecurrenceIdException.class)
    public final void testAddNullRecurrenceId() throws SkylineStoreException {
        RecurrenceId recurrenceIdNull = null;
        ArrayList<ResourceSkyline> resourceSkylines = new ArrayList<ResourceSkyline>();
        ResourceSkyline resourceSkyline1 = this.getSkyline(1);
        resourceSkylines.add(resourceSkyline1);
        this.skylineStore.addHistory(recurrenceIdNull, resourceSkylines);
    }

    @Test(expected=NullResourceSkylineException.class)
    public final void testAddNullResourceSkyline() throws SkylineStoreException {
        RecurrenceId recurrenceId = new RecurrenceId("FraudDetection", "17/06/20 00:00:00");
        ArrayList<ResourceSkyline> resourceSkylines = new ArrayList<ResourceSkyline>();
        ResourceSkyline resourceSkyline1 = this.getSkyline(1);
        resourceSkylines.add(resourceSkyline1);
        this.skylineStore.addHistory(recurrenceId, null);
    }

    @Test(expected=DuplicateRecurrenceIdException.class)
    public final void testAddDuplicateRecurrenceId() throws SkylineStoreException {
        RecurrenceId recurrenceId = new RecurrenceId("FraudDetection", "17/06/20 00:00:00");
        ArrayList<ResourceSkyline> resourceSkylines = new ArrayList<ResourceSkyline>();
        ResourceSkyline resourceSkyline1 = this.getSkyline(1);
        resourceSkylines.add(resourceSkyline1);
        this.skylineStore.addHistory(recurrenceId, resourceSkylines);
        this.skylineStore.addHistory(recurrenceId, resourceSkylines);
    }

    @Test(expected=NullPipelineIdException.class)
    public final void testAddNullPipelineIdException() throws SkylineStoreException {
        RLESparseResourceAllocation skylineList2 = new RLESparseResourceAllocation((NavigableMap)this.resourceOverTime, (ResourceCalculator)new DefaultResourceCalculator());
        for (int i = 0; i < 5; ++i) {
            this.riAdd = new ReservationInterval((long)(i * 10), (long)((i + 1) * 10));
            skylineList2.addInterval(this.riAdd, this.resource);
        }
        this.skylineStore.addEstimation(null, skylineList2);
    }

    @Test(expected=NullRLESparseResourceAllocationException.class)
    public final void testAddNullRLESparseResourceAllocationExceptionException() throws SkylineStoreException {
        this.skylineStore.addEstimation("FraudDetection", null);
    }

    @Test
    public final void testDeleteNormal() throws SkylineStoreException {
        RecurrenceId recurrenceId1 = new RecurrenceId("FraudDetection", "17/06/20 00:00:00");
        ResourceSkyline resourceSkyline1 = this.getSkyline(1);
        this.addToStore(recurrenceId1, resourceSkyline1);
        ResourceSkyline resourceSkyline2 = this.getSkyline(2);
        this.addToStore(recurrenceId1, resourceSkyline2);
        this.skylineStore.deleteHistory(recurrenceId1);
    }

    @Test(expected=NullRecurrenceIdException.class)
    public final void testDeleteNullRecurrenceId() throws SkylineStoreException {
        RecurrenceId recurrenceId1 = new RecurrenceId("FraudDetection", "17/06/20 00:00:00");
        ResourceSkyline resourceSkyline1 = this.getSkyline(1);
        this.addToStore(recurrenceId1, resourceSkyline1);
        this.skylineStore.deleteHistory(null);
    }

    @Test(expected=RecurrenceIdNotFoundException.class)
    public final void testDeleteRecurrenceIdNotFound() throws SkylineStoreException {
        RecurrenceId recurrenceId1 = new RecurrenceId("FraudDetection", "17/06/20 00:00:00");
        ResourceSkyline resourceSkyline1 = this.getSkyline(1);
        this.addToStore(recurrenceId1, resourceSkyline1);
        RecurrenceId recurrenceIdInvalid = new RecurrenceId("Some random pipelineId", "Some random runId");
        this.skylineStore.deleteHistory(recurrenceIdInvalid);
    }

    @Test
    public final void testUpdateNormal() throws SkylineStoreException {
        RecurrenceId recurrenceId1 = new RecurrenceId("FraudDetection", "17/06/20 00:00:00");
        ResourceSkyline resourceSkyline1 = this.getSkyline(1);
        this.addToStore(recurrenceId1, resourceSkyline1);
        ArrayList<ResourceSkyline> resourceSkylines = new ArrayList<ResourceSkyline>();
        ResourceSkyline resourceSkyline2 = this.getSkyline(2);
        resourceSkylines.add(resourceSkyline1);
        resourceSkylines.add(resourceSkyline2);
        this.skylineStore.updateHistory(recurrenceId1, resourceSkylines);
        Map jobHistory = this.skylineStore.getHistory(recurrenceId1);
        Assert.assertEquals((long)1L, (long)jobHistory.size());
        for (Map.Entry entry : jobHistory.entrySet()) {
            Assert.assertEquals((Object)recurrenceId1, entry.getKey());
            List getSkylines = (List)entry.getValue();
            Assert.assertEquals((long)2L, (long)getSkylines.size());
            this.compare(resourceSkyline1, (ResourceSkyline)getSkylines.get(0));
            this.compare(resourceSkyline2, (ResourceSkyline)getSkylines.get(1));
        }
    }

    @Test(expected=NullRecurrenceIdException.class)
    public final void testUpdateNullRecurrenceId() throws SkylineStoreException {
        ArrayList<ResourceSkyline> resourceSkylines = new ArrayList<ResourceSkyline>();
        ResourceSkyline resourceSkyline1 = this.getSkyline(1);
        resourceSkylines.add(resourceSkyline1);
        ArrayList<Object> resourceSkylinesInvalid = new ArrayList<Object>();
        resourceSkylinesInvalid.add(null);
        this.skylineStore.updateHistory(null, resourceSkylines);
    }

    @Test(expected=NullResourceSkylineException.class)
    public final void testUpdateNullResourceSkyline() throws SkylineStoreException {
        RecurrenceId recurrenceId = new RecurrenceId("FraudDetection", "17/06/20 00:00:00");
        ArrayList<ResourceSkyline> resourceSkylines = new ArrayList<ResourceSkyline>();
        ResourceSkyline resourceSkyline1 = this.getSkyline(1);
        resourceSkylines.add(resourceSkyline1);
        ArrayList<Object> resourceSkylinesInvalid = new ArrayList<Object>();
        resourceSkylinesInvalid.add(null);
        this.skylineStore.addHistory(recurrenceId, resourceSkylines);
        this.skylineStore.updateHistory(recurrenceId, null);
    }

    @Test(expected=EmptyResourceSkylineException.class)
    public final void testUpdateEmptyRecurrenceId() throws SkylineStoreException {
        RecurrenceId recurrenceId = new RecurrenceId("FraudDetection", "17/06/20 00:00:00");
        ArrayList<ResourceSkyline> resourceSkylines = new ArrayList<ResourceSkyline>();
        ResourceSkyline resourceSkyline1 = this.getSkyline(1);
        resourceSkylines.add(resourceSkyline1);
        ArrayList<Object> resourceSkylinesInvalid = new ArrayList<Object>();
        resourceSkylinesInvalid.add(null);
        this.skylineStore.addHistory(recurrenceId, resourceSkylines);
        this.skylineStore.updateHistory(recurrenceId, resourceSkylinesInvalid);
    }

    @Test(expected=RecurrenceIdNotFoundException.class)
    public final void testUpdateRecurrenceIdNotFound() throws SkylineStoreException {
        ArrayList<ResourceSkyline> resourceSkylines = new ArrayList<ResourceSkyline>();
        ResourceSkyline resourceSkyline1 = this.getSkyline(1);
        resourceSkylines.add(resourceSkyline1);
        RecurrenceId recurrenceIdInvalid = new RecurrenceId("Some random pipelineId", "Some random runId");
        ArrayList<Object> resourceSkylinesInvalid = new ArrayList<Object>();
        resourceSkylinesInvalid.add(null);
        this.skylineStore.updateHistory(recurrenceIdInvalid, resourceSkylines);
    }

    @After
    public final void cleanUp() {
        this.skylineStore = null;
        this.resourceOverTime.clear();
        this.resourceOverTime = null;
        this.skylineList = null;
        this.riAdd = null;
        this.resource = null;
    }
}

