/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.resourceestimator.service;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.test.framework.JerseyTest;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.ws.rs.core.MediaType;
import org.apache.hadoop.resourceestimator.common.api.RecurrenceId;
import org.apache.hadoop.resourceestimator.common.api.ResourceSkyline;
import org.apache.hadoop.resourceestimator.common.serialization.RLESparseResourceAllocationSerDe;
import org.apache.hadoop.resourceestimator.common.serialization.ResourceSerDe;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestResourceEstimatorService
extends JerseyTest {
    private final String parseLogCommand = "resourceestimator/translator/src/test/resources/resourceEstimatorService.txt";
    private final String getHistorySkylineCommand = "resourceestimator/skylinestore/history/tpch_q12/*";
    private final String getEstimatedSkylineCommand = "resourceestimator/skylinestore/estimation/tpch_q12";
    private final String makeEstimationCommand = "resourceestimator/estimator/tpch_q12";
    private final String deleteHistoryCommand = "resourceestimator/skylinestore/history/tpch_q12/tpch_q12_1";
    private static boolean setUpDone = false;
    private Resource containerSpec;
    private Gson gson;
    private long containerMemAlloc;
    private int containerCPUAlloc;

    public TestResourceEstimatorService() {
        super(new String[]{"org.apache.hadoop.resourceestimator.service"});
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.containerMemAlloc = 1024L;
        this.containerCPUAlloc = 1;
        this.containerSpec = Resource.newInstance((long)this.containerMemAlloc, (int)this.containerCPUAlloc);
        this.gson = new GsonBuilder().registerTypeAdapter(Resource.class, (Object)new ResourceSerDe()).registerTypeAdapter(RLESparseResourceAllocation.class, (Object)new RLESparseResourceAllocationSerDe()).enableComplexMapKeySerialization().create();
    }

    private void compareResourceSkyline(ResourceSkyline skyline1, ResourceSkyline skyline2) {
        Assert.assertEquals((Object)skyline1.getJobId(), (Object)skyline2.getJobId());
        Assert.assertEquals((double)skyline1.getJobInputDataSize(), (double)skyline2.getJobInputDataSize(), (double)0.0);
        Assert.assertEquals((long)skyline1.getJobSubmissionTime(), (long)skyline2.getJobSubmissionTime());
        Assert.assertEquals((long)skyline1.getJobFinishTime(), (long)skyline2.getJobFinishTime());
        Assert.assertEquals((long)skyline1.getContainerSpec().getMemorySize(), (long)skyline2.getContainerSpec().getMemorySize());
        Assert.assertEquals((long)skyline1.getContainerSpec().getVirtualCores(), (long)skyline2.getContainerSpec().getVirtualCores());
        RLESparseResourceAllocation skylineList1 = skyline1.getSkylineList();
        RLESparseResourceAllocation skylineList2 = skyline2.getSkylineList();
        int i = (int)skylineList1.getEarliestStartTime();
        while ((long)i < skylineList1.getLatestNonNullTime()) {
            Assert.assertEquals((long)skylineList1.getCapacityAtTime((long)i).getMemorySize(), (long)skylineList2.getCapacityAtTime((long)i).getMemorySize());
            Assert.assertEquals((long)skylineList1.getCapacityAtTime((long)i).getVirtualCores(), (long)skylineList2.getCapacityAtTime((long)i).getVirtualCores());
            ++i;
        }
    }

    private ResourceSkyline getSkyline1() {
        TreeMap resourceOverTime = new TreeMap();
        RLESparseResourceAllocation skylineList = new RLESparseResourceAllocation(resourceOverTime, (ResourceCalculator)new DefaultResourceCalculator());
        ReservationInterval riAdd = new ReservationInterval(0L, 10L);
        Resource resource = Resource.newInstance((long)this.containerMemAlloc, (int)this.containerCPUAlloc);
        skylineList.addInterval(riAdd, resource);
        riAdd = new ReservationInterval(10L, 15L);
        resource = Resource.newInstance((long)(this.containerMemAlloc * 1074L), (int)(this.containerCPUAlloc * 1074));
        skylineList.addInterval(riAdd, resource);
        riAdd = new ReservationInterval(15L, 20L);
        resource = Resource.newInstance((long)(this.containerMemAlloc * 2538L), (int)(this.containerCPUAlloc * 2538));
        skylineList.addInterval(riAdd, resource);
        riAdd = new ReservationInterval(20L, 25L);
        resource = Resource.newInstance((long)(this.containerMemAlloc * 2468L), (int)(this.containerCPUAlloc * 2468));
        skylineList.addInterval(riAdd, resource);
        ResourceSkyline resourceSkyline1 = new ResourceSkyline("tpch_q12_0", 0.0, 0L, 25L, this.containerSpec, skylineList);
        return resourceSkyline1;
    }

    private ResourceSkyline getSkyline2() {
        TreeMap resourceOverTime = new TreeMap();
        RLESparseResourceAllocation skylineList = new RLESparseResourceAllocation(resourceOverTime, (ResourceCalculator)new DefaultResourceCalculator());
        ReservationInterval riAdd = new ReservationInterval(0L, 10L);
        Resource resource = Resource.newInstance((long)this.containerMemAlloc, (int)this.containerCPUAlloc);
        skylineList.addInterval(riAdd, resource);
        riAdd = new ReservationInterval(10L, 15L);
        resource = Resource.newInstance((long)(this.containerMemAlloc * 794L), (int)(this.containerCPUAlloc * 794));
        skylineList.addInterval(riAdd, resource);
        riAdd = new ReservationInterval(15L, 20L);
        resource = Resource.newInstance((long)(this.containerMemAlloc * 2517L), (int)(this.containerCPUAlloc * 2517));
        skylineList.addInterval(riAdd, resource);
        riAdd = new ReservationInterval(20L, 25L);
        resource = Resource.newInstance((long)(this.containerMemAlloc * 2484L), (int)(this.containerCPUAlloc * 2484));
        skylineList.addInterval(riAdd, resource);
        ResourceSkyline resourceSkyline2 = new ResourceSkyline("tpch_q12_1", 0.0, 0L, 25L, this.containerSpec, skylineList);
        return resourceSkyline2;
    }

    private void checkResult(String jobId, Map<RecurrenceId, List<ResourceSkyline>> jobHistory) {
        switch (jobId) {
            case "tpch_q12_0": {
                RecurrenceId recurrenceId = new RecurrenceId("tpch_q12", "tpch_q12_0");
                Assert.assertEquals((long)1L, (long)jobHistory.get(recurrenceId).size());
                ResourceSkyline skylineReceive = jobHistory.get(recurrenceId).get(0);
                this.compareResourceSkyline(skylineReceive, this.getSkyline1());
                break;
            }
            case "tpch_q12_1": {
                RecurrenceId recurrenceId = new RecurrenceId("tpch_q12", "tpch_q12_1");
                Assert.assertEquals((long)1L, (long)jobHistory.get(recurrenceId).size());
                ResourceSkyline skylineReceive = jobHistory.get(recurrenceId).get(0);
                this.compareResourceSkyline(skylineReceive, this.getSkyline2());
                break;
            }
        }
    }

    private void compareRLESparseResourceAllocation(RLESparseResourceAllocation rle1, RLESparseResourceAllocation rle2) {
        int i = (int)rle1.getEarliestStartTime();
        while ((long)i < rle1.getLatestNonNullTime()) {
            Assert.assertEquals((Object)rle1.getCapacityAtTime((long)i), (Object)rle2.getCapacityAtTime((long)i));
            ++i;
        }
    }

    @Test
    public void testGetPrediction() {
        String logFile = "resourceEstimatorService.txt";
        WebResource webResource = this.resource();
        webResource.path("resourceestimator/translator/src/test/resources/resourceEstimatorService.txt").type(MediaType.APPLICATION_XML_TYPE).post((Object)"resourceEstimatorService.txt");
        webResource = this.resource().path("resourceestimator/skylinestore/history/tpch_q12/*");
        String response = (String)webResource.get(String.class);
        Map jobHistory = (Map)this.gson.fromJson(response, new /* Unavailable Anonymous Inner Class!! */.getType());
        this.checkResult("tpch_q12_0", jobHistory);
        this.checkResult("tpch_q12_1", jobHistory);
        webResource = this.resource().path("resourceestimator/skylinestore/estimation/tpch_q12");
        response = (String)webResource.get(String.class);
        Assert.assertEquals((Object)"null", (Object)response);
        webResource = this.resource().path("resourceestimator/estimator/tpch_q12");
        response = (String)webResource.get(String.class);
        RLESparseResourceAllocation skylineList = (RLESparseResourceAllocation)this.gson.fromJson(response, new /* Unavailable Anonymous Inner Class!! */.getType());
        Assert.assertEquals((long)1L, (long)(skylineList.getCapacityAtTime(0L).getMemorySize() / this.containerMemAlloc));
        Assert.assertEquals((long)1058L, (long)(skylineList.getCapacityAtTime(10L).getMemorySize() / this.containerMemAlloc));
        Assert.assertEquals((long)2538L, (long)(skylineList.getCapacityAtTime(15L).getMemorySize() / this.containerMemAlloc));
        Assert.assertEquals((long)2484L, (long)(skylineList.getCapacityAtTime(20L).getMemorySize() / this.containerMemAlloc));
        webResource = this.resource().path("resourceestimator/skylinestore/estimation/tpch_q12");
        response = (String)webResource.get(String.class);
        RLESparseResourceAllocation skylineList2 = (RLESparseResourceAllocation)this.gson.fromJson(response, new /* Unavailable Anonymous Inner Class!! */.getType());
        this.compareRLESparseResourceAllocation(skylineList, skylineList2);
        webResource = this.resource().path("resourceestimator/estimator/tpch_q12");
        response = (String)webResource.get(String.class);
        RLESparseResourceAllocation skylineList3 = (RLESparseResourceAllocation)this.gson.fromJson(response, new /* Unavailable Anonymous Inner Class!! */.getType());
        this.compareRLESparseResourceAllocation(skylineList, skylineList3);
        webResource = this.resource().path("resourceestimator/skylinestore/history/tpch_q12/tpch_q12_1");
        webResource.delete();
        webResource = this.resource().path("resourceestimator/skylinestore/history/tpch_q12/*");
        response = (String)webResource.get(String.class);
        jobHistory = (Map)this.gson.fromJson(response, new /* Unavailable Anonymous Inner Class!! */.getType());
        Assert.assertEquals((long)1L, (long)jobHistory.size());
        String pipelineId = ((RecurrenceId)jobHistory.keySet().toArray()[0]).getRunId();
        Assert.assertEquals((Object)"tpch_q12_0", (Object)pipelineId);
    }
}

