/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.resourceestimator.common.serialization;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.hadoop.resourceestimator.common.api.ResourceSkyline;
import org.apache.hadoop.resourceestimator.common.serialization.RLESparseResourceAllocationSerDe;
import org.apache.hadoop.resourceestimator.common.serialization.ResourceSerDe;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestResourceSkylineSerDe {
    private Gson gson;
    private ResourceSkyline resourceSkyline;
    private Resource resource;
    private Resource resource2;
    private TreeMap<Long, Resource> resourceOverTime;
    private RLESparseResourceAllocation skylineList;

    @Before
    public final void setup() {
        this.resourceOverTime = new TreeMap();
        this.skylineList = new RLESparseResourceAllocation((NavigableMap)this.resourceOverTime, (ResourceCalculator)new DefaultResourceCalculator());
        this.resource = Resource.newInstance((int)102400, (int)100);
        this.resource2 = Resource.newInstance((int)204800, (int)200);
        this.gson = new GsonBuilder().registerTypeAdapter(Resource.class, (Object)new ResourceSerDe()).registerTypeAdapter(RLESparseResourceAllocation.class, (Object)new RLESparseResourceAllocationSerDe()).create();
    }

    @Test
    public final void testSerialization() {
        ReservationInterval riAdd = new ReservationInterval(0L, 10L);
        this.skylineList.addInterval(riAdd, this.resource);
        riAdd = new ReservationInterval(10L, 20L);
        this.skylineList.addInterval(riAdd, this.resource2);
        this.resourceSkyline = new ResourceSkyline("1", 1024.5, 0L, 20L, this.resource, this.skylineList);
        String json = this.gson.toJson((Object)this.resourceSkyline, new /* Unavailable Anonymous Inner Class!! */.getType());
        ResourceSkyline resourceSkylineDe = (ResourceSkyline)this.gson.fromJson(json, new /* Unavailable Anonymous Inner Class!! */.getType());
        Assert.assertEquals((Object)resourceSkylineDe.getJobId(), (Object)this.resourceSkyline.getJobId());
        Assert.assertEquals((double)resourceSkylineDe.getJobInputDataSize(), (double)this.resourceSkyline.getJobInputDataSize(), (double)0.0);
        Assert.assertEquals((long)resourceSkylineDe.getJobSubmissionTime(), (long)this.resourceSkyline.getJobSubmissionTime());
        Assert.assertEquals((long)resourceSkylineDe.getJobFinishTime(), (long)this.resourceSkyline.getJobFinishTime());
        Assert.assertEquals((long)resourceSkylineDe.getContainerSpec().getMemorySize(), (long)this.resourceSkyline.getContainerSpec().getMemorySize());
        Assert.assertEquals((long)resourceSkylineDe.getContainerSpec().getVirtualCores(), (long)this.resourceSkyline.getContainerSpec().getVirtualCores());
        RLESparseResourceAllocation skylineList2 = this.resourceSkyline.getSkylineList();
        RLESparseResourceAllocation skylineListDe = resourceSkylineDe.getSkylineList();
        for (int i = 0; i < 20; ++i) {
            Assert.assertEquals((long)skylineList2.getCapacityAtTime((long)i).getMemorySize(), (long)skylineListDe.getCapacityAtTime((long)i).getMemorySize());
            Assert.assertEquals((long)skylineList2.getCapacityAtTime((long)i).getVirtualCores(), (long)skylineListDe.getCapacityAtTime((long)i).getVirtualCores());
        }
    }

    @After
    public final void cleanUp() {
        this.gson = null;
        this.resourceSkyline = null;
        this.resourceOverTime.clear();
        this.resourceOverTime = null;
        this.resource = null;
        this.resource2 = null;
        this.skylineList = null;
    }
}

