/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.resourceestimator.common.api;

import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.hadoop.resourceestimator.common.api.ResourceSkyline;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestResourceSkyline {
    private ResourceSkyline resourceSkyline;
    private Resource resource1;
    private Resource resource2;
    private TreeMap<Long, Resource> resourceOverTime;
    private RLESparseResourceAllocation skylineList;

    @Before
    public final void setup() {
        this.resourceOverTime = new TreeMap();
        this.skylineList = new RLESparseResourceAllocation((NavigableMap)this.resourceOverTime, (ResourceCalculator)new DefaultResourceCalculator());
        this.resource1 = Resource.newInstance((int)102400, (int)100);
        this.resource2 = Resource.newInstance((int)204800, (int)200);
    }

    @Test
    public final void testGetJobId() {
        Assert.assertNull((Object)this.resourceSkyline);
        ReservationInterval riAdd = new ReservationInterval(0L, 10L);
        this.skylineList.addInterval(riAdd, this.resource1);
        riAdd = new ReservationInterval(10L, 20L);
        this.skylineList.addInterval(riAdd, this.resource1);
        this.resourceSkyline = new ResourceSkyline("1", 1024.5, 0L, 20L, this.resource1, this.skylineList);
        Assert.assertEquals((Object)"1", (Object)this.resourceSkyline.getJobId());
    }

    @Test
    public final void testGetJobSubmissionTime() {
        Assert.assertNull((Object)this.resourceSkyline);
        ReservationInterval riAdd = new ReservationInterval(0L, 10L);
        this.skylineList.addInterval(riAdd, this.resource1);
        riAdd = new ReservationInterval(10L, 20L);
        this.skylineList.addInterval(riAdd, this.resource1);
        this.resourceSkyline = new ResourceSkyline("1", 1024.5, 0L, 20L, this.resource1, this.skylineList);
        Assert.assertEquals((long)0L, (long)this.resourceSkyline.getJobSubmissionTime());
    }

    @Test
    public final void testGetJobFinishTime() {
        Assert.assertNull((Object)this.resourceSkyline);
        ReservationInterval riAdd = new ReservationInterval(0L, 10L);
        this.skylineList.addInterval(riAdd, this.resource1);
        riAdd = new ReservationInterval(10L, 20L);
        this.skylineList.addInterval(riAdd, this.resource1);
        this.resourceSkyline = new ResourceSkyline("1", 1024.5, 0L, 20L, this.resource1, this.skylineList);
        Assert.assertEquals((long)20L, (long)this.resourceSkyline.getJobFinishTime());
    }

    @Test
    public final void testGetKthResource() {
        int i;
        Assert.assertNull((Object)this.resourceSkyline);
        ReservationInterval riAdd = new ReservationInterval(10L, 20L);
        this.skylineList.addInterval(riAdd, this.resource1);
        riAdd = new ReservationInterval(20L, 30L);
        this.skylineList.addInterval(riAdd, this.resource2);
        this.resourceSkyline = new ResourceSkyline("1", 1024.5, 0L, 20L, this.resource1, this.skylineList);
        RLESparseResourceAllocation skylineList2 = this.resourceSkyline.getSkylineList();
        for (i = 10; i < 20; ++i) {
            Assert.assertEquals((long)this.resource1.getMemorySize(), (long)skylineList2.getCapacityAtTime((long)i).getMemorySize());
            Assert.assertEquals((long)this.resource1.getVirtualCores(), (long)skylineList2.getCapacityAtTime((long)i).getVirtualCores());
        }
        for (i = 20; i < 30; ++i) {
            Assert.assertEquals((long)this.resource2.getMemorySize(), (long)skylineList2.getCapacityAtTime((long)i).getMemorySize());
            Assert.assertEquals((long)this.resource2.getVirtualCores(), (long)skylineList2.getCapacityAtTime((long)i).getVirtualCores());
        }
        Assert.assertEquals((long)0L, (long)skylineList2.getCapacityAtTime(9L).getMemorySize());
        Assert.assertEquals((long)0L, (long)skylineList2.getCapacityAtTime(9L).getVirtualCores());
        Assert.assertEquals((long)0L, (long)skylineList2.getCapacityAtTime(30L).getMemorySize());
        Assert.assertEquals((long)0L, (long)skylineList2.getCapacityAtTime(30L).getVirtualCores());
    }

    @After
    public final void cleanUp() {
        this.resourceSkyline = null;
        this.resource1 = null;
        this.resource2 = null;
        this.resourceOverTime.clear();
        this.resourceOverTime = null;
        this.skylineList = null;
    }
}

