/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.util;

import org.apache.hadoop.ozone.s3.util.RangeHeader;
import org.apache.hadoop.ozone.s3.util.RangeHeaderParserUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestRangeHeaderParserUtil {
    @Test
    public void testRangeHeaderParser() {
        RangeHeader rangeHeader = RangeHeaderParserUtil.parseRangeHeader((String)"bytes=0-8", (long)10L);
        Assert.assertEquals((long)0L, (long)rangeHeader.getStartOffset());
        Assert.assertEquals((long)8L, (long)rangeHeader.getEndOffset());
        Assert.assertEquals((Object)false, (Object)rangeHeader.isReadFull());
        Assert.assertEquals((Object)false, (Object)rangeHeader.isInValidRange());
        rangeHeader = RangeHeaderParserUtil.parseRangeHeader((String)"bytes=0-0", (long)10L);
        Assert.assertEquals((long)0L, (long)rangeHeader.getStartOffset());
        Assert.assertEquals((long)0L, (long)rangeHeader.getEndOffset());
        Assert.assertEquals((Object)false, (Object)rangeHeader.isReadFull());
        Assert.assertEquals((Object)false, (Object)rangeHeader.isInValidRange());
        rangeHeader = RangeHeaderParserUtil.parseRangeHeader((String)"bytes=11-10", (long)10L);
        Assert.assertEquals((Object)true, (Object)rangeHeader.isInValidRange());
        rangeHeader = RangeHeaderParserUtil.parseRangeHeader((String)"bytes=11-8", (long)10L);
        Assert.assertEquals((long)0L, (long)rangeHeader.getStartOffset());
        Assert.assertEquals((long)9L, (long)rangeHeader.getEndOffset());
        Assert.assertEquals((Object)true, (Object)rangeHeader.isReadFull());
        Assert.assertEquals((Object)false, (Object)rangeHeader.isInValidRange());
        rangeHeader = RangeHeaderParserUtil.parseRangeHeader((String)"mb=11-8", (long)10L);
        Assert.assertEquals((long)0L, (long)rangeHeader.getStartOffset());
        Assert.assertEquals((long)9L, (long)rangeHeader.getEndOffset());
        Assert.assertEquals((Object)true, (Object)rangeHeader.isReadFull());
        Assert.assertEquals((Object)false, (Object)rangeHeader.isInValidRange());
        rangeHeader = RangeHeaderParserUtil.parseRangeHeader((String)"bytes=-11-8", (long)10L);
        Assert.assertEquals((long)0L, (long)rangeHeader.getStartOffset());
        Assert.assertEquals((long)9L, (long)rangeHeader.getEndOffset());
        Assert.assertEquals((Object)true, (Object)rangeHeader.isReadFull());
        Assert.assertEquals((Object)false, (Object)rangeHeader.isInValidRange());
        rangeHeader = RangeHeaderParserUtil.parseRangeHeader((String)"bytes=-6", (long)10L);
        Assert.assertEquals((long)4L, (long)rangeHeader.getStartOffset());
        Assert.assertEquals((long)9L, (long)rangeHeader.getEndOffset());
        Assert.assertEquals((Object)false, (Object)rangeHeader.isReadFull());
        Assert.assertEquals((Object)false, (Object)rangeHeader.isInValidRange());
        rangeHeader = RangeHeaderParserUtil.parseRangeHeader((String)"bytes=-106", (long)10L);
        Assert.assertEquals((long)0L, (long)rangeHeader.getStartOffset());
        Assert.assertEquals((long)9L, (long)rangeHeader.getEndOffset());
        Assert.assertEquals((Object)false, (Object)rangeHeader.isInValidRange());
        rangeHeader = RangeHeaderParserUtil.parseRangeHeader((String)"bytes=3977248768-4977248768", (long)4977248769L);
        Assert.assertEquals((long)3977248768L, (long)rangeHeader.getStartOffset());
        Assert.assertEquals((long)4977248768L, (long)rangeHeader.getEndOffset());
        Assert.assertEquals((Object)false, (Object)rangeHeader.isInValidRange());
    }
}

