/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.util;

import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.s3.util.OzoneS3Util;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestOzoneS3Util {
    private OzoneConfiguration configuration;
    private String serviceID = "omService";

    @Before
    public void setConf() {
        this.configuration = new OzoneConfiguration();
        String nodeIDs = "om1,om2,om3";
        this.configuration.set("ozone.om.service.ids", this.serviceID);
        this.configuration.set("ozone.om.nodes." + this.serviceID, nodeIDs);
        this.configuration.setBoolean("hadoop.security.token.service.use_ip", false);
    }

    @Test
    public void testBuildServiceNameForToken() {
        Collection nodeIDList = OmUtils.getOMNodeIds((Configuration)this.configuration, (String)this.serviceID);
        this.configuration.set(OmUtils.addKeySuffixes((String)"ozone.om.address", (String[])new String[]{this.serviceID, "om1"}), "om1:9862");
        this.configuration.set(OmUtils.addKeySuffixes((String)"ozone.om.address", (String[])new String[]{this.serviceID, "om2"}), "om2:9862");
        this.configuration.set(OmUtils.addKeySuffixes((String)"ozone.om.address", (String[])new String[]{this.serviceID, "om3"}), "om3:9862");
        String expectedOmServiceAddress = this.buildServiceAddress(nodeIDList);
        SecurityUtil.setConfiguration((Configuration)this.configuration);
        String omserviceAddr = OzoneS3Util.buildServiceNameForToken((OzoneConfiguration)this.configuration, (String)this.serviceID, (Collection)nodeIDList);
        Assert.assertEquals((Object)expectedOmServiceAddress, (Object)omserviceAddr);
    }

    @Test
    public void testBuildServiceNameForTokenIncorrectConfig() {
        Collection nodeIDList = OmUtils.getOMNodeIds((Configuration)this.configuration, (String)this.serviceID);
        this.configuration.set(OmUtils.addKeySuffixes((String)"ozone.om.address", (String[])new String[]{this.serviceID, "om1"}), "om1:9862");
        this.configuration.set(OmUtils.addKeySuffixes((String)"ozone.om.address", (String[])new String[]{this.serviceID, "om2"}), "om2:9862");
        SecurityUtil.setConfiguration((Configuration)this.configuration);
        try {
            OzoneS3Util.buildServiceNameForToken((OzoneConfiguration)this.configuration, (String)this.serviceID, (Collection)nodeIDList);
            Assert.fail((String)"testBuildServiceNameForTokenIncorrectConfig failed");
        }
        catch (IllegalArgumentException ex) {
            GenericTestUtils.assertExceptionContains((String)"Could not find rpcAddress for", (Throwable)ex);
        }
    }

    private String buildServiceAddress(Collection<String> nodeIDList) {
        StringBuilder omServiceAddrBuilder = new StringBuilder();
        int nodesLength = nodeIDList.size();
        int counter = 0;
        for (String nodeID : nodeIDList) {
            String addr = this.configuration.get(OmUtils.addKeySuffixes((String)"ozone.om.address", (String[])new String[]{this.serviceID, nodeID}));
            if (++counter != nodesLength) {
                omServiceAddrBuilder.append(addr + ",");
                continue;
            }
            omServiceAddrBuilder.append(addr);
        }
        return omServiceAddrBuilder.toString();
    }
}

