/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.header;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import org.apache.hadoop.ozone.s3.AWSV4SignatureProcessor;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.header.AuthorizationHeaderV4;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAuthorizationHeaderV4 {
    private String curDate;

    @Before
    public void setup() {
        LocalDate now = LocalDate.now();
        this.curDate = AWSV4SignatureProcessor.DATE_FORMATTER.format(now);
    }

    @Test
    public void testV4HeaderWellFormed() throws Exception {
        String auth = "AWS4-HMAC-SHA256 Credential=ozone/" + this.curDate + "/us-east-1/s3/aws4_request, SignedHeaders=host;range;x-amz-date, Signature=fe5f80f77d5fa3beca038a248ff027";
        AuthorizationHeaderV4 v4 = new AuthorizationHeaderV4(auth);
        Assert.assertEquals((Object)"AWS4-HMAC-SHA256", (Object)v4.getAlgorithm());
        Assert.assertEquals((Object)"ozone", (Object)v4.getAccessKeyID());
        Assert.assertEquals((Object)this.curDate, (Object)v4.getDate());
        Assert.assertEquals((Object)"us-east-1", (Object)v4.getAwsRegion());
        Assert.assertEquals((Object)"aws4_request", (Object)v4.getAwsRequest());
        Assert.assertEquals((Object)"host;range;x-amz-date", (Object)v4.getSignedHeaderString());
        Assert.assertEquals((Object)"fe5f80f77d5fa3beca038a248ff027", (Object)v4.getSignature());
    }

    @Test
    public void testV4HeaderMissingParts() {
        try {
            String auth = "AWS4-HMAC-SHA256 Credential=ozone/" + this.curDate + "/us-east-1/s3/aws4_request, SignedHeaders=host;range;x-amz-date,";
            AuthorizationHeaderV4 v4 = new AuthorizationHeaderV4(auth);
            Assert.fail((String)"Exception is expected in case of malformed header");
        }
        catch (OS3Exception ex) {
            Assert.assertEquals((Object)"AuthorizationHeaderMalformed", (Object)ex.getCode());
        }
    }

    @Test
    public void testV4HeaderInvalidCredential() {
        try {
            String auth = "AWS4-HMAC-SHA256 Credential=" + this.curDate + "/us-east-1/s3/aws4_request, SignedHeaders=host;range;x-amz-date, Signature=fe5f80f77d5fa3beca038a248ff027";
            AuthorizationHeaderV4 v4 = new AuthorizationHeaderV4(auth);
            Assert.fail((String)"Exception is expected in case of malformed header");
        }
        catch (OS3Exception ex) {
            Assert.assertEquals((Object)"AuthorizationHeaderMalformed", (Object)ex.getCode());
        }
    }

    @Test
    public void testV4HeaderWithoutSpace() throws OS3Exception {
        String auth = "AWS4-HMAC-SHA256 Credential=ozone/" + this.curDate + "/us-east-1/s3/aws4_request,SignedHeaders=host;x-amz-content-sha256;x-amz-date,Signature=fe5f80f77d5fa3beca038a248ff027";
        AuthorizationHeaderV4 v4 = new AuthorizationHeaderV4(auth);
        Assert.assertEquals((Object)"AWS4-HMAC-SHA256", (Object)v4.getAlgorithm());
        Assert.assertEquals((Object)"ozone", (Object)v4.getAccessKeyID());
        Assert.assertEquals((Object)this.curDate, (Object)v4.getDate());
        Assert.assertEquals((Object)"us-east-1", (Object)v4.getAwsRegion());
        Assert.assertEquals((Object)"aws4_request", (Object)v4.getAwsRequest());
        Assert.assertEquals((Object)"host;x-amz-content-sha256;x-amz-date", (Object)v4.getSignedHeaderString());
        Assert.assertEquals((Object)"fe5f80f77d5fa3beca038a248ff027", (Object)v4.getSignature());
    }

    @Test
    public void testV4HeaderDateValidationSuccess() throws OS3Exception {
        LocalDate now = LocalDate.now();
        String dateStr = AWSV4SignatureProcessor.DATE_FORMATTER.format(now);
        this.validateResponse(dateStr);
        dateStr = AWSV4SignatureProcessor.DATE_FORMATTER.format(now.plus(1L, ChronoUnit.DAYS));
        this.validateResponse(dateStr);
        dateStr = AWSV4SignatureProcessor.DATE_FORMATTER.format(now.minus(1L, ChronoUnit.DAYS));
        this.validateResponse(dateStr);
    }

    @Test
    public void testV4HeaderDateValidationFailure() throws Exception {
        LocalDate now = LocalDate.now();
        String dateStr = "";
        LambdaTestUtils.intercept(OS3Exception.class, (String)"", () -> this.validateResponse(dateStr));
        String dateStr2 = AWSV4SignatureProcessor.DATE_FORMATTER.format(now.plus(2L, ChronoUnit.DAYS));
        LambdaTestUtils.intercept(OS3Exception.class, (String)"", () -> this.validateResponse(dateStr2));
        String dateStr3 = AWSV4SignatureProcessor.DATE_FORMATTER.format(now.minus(2L, ChronoUnit.DAYS));
        LambdaTestUtils.intercept(OS3Exception.class, (String)"", () -> this.validateResponse(dateStr3));
    }

    private void validateResponse(String dateStr) throws OS3Exception {
        String auth = "AWS4-HMAC-SHA256 Credential=ozone/" + dateStr + "/us-east-1/s3/aws4_request,SignedHeaders=host;x-amz-content-sha256;x-amz-date,Signature=fe5f80f77d5fa3beca038a248ff027";
        AuthorizationHeaderV4 v4 = new AuthorizationHeaderV4(auth);
        Assert.assertEquals((Object)"AWS4-HMAC-SHA256", (Object)v4.getAlgorithm());
        Assert.assertEquals((Object)"ozone", (Object)v4.getAccessKeyID());
        Assert.assertEquals((Object)dateStr, (Object)v4.getDate());
        Assert.assertEquals((Object)"us-east-1", (Object)v4.getAwsRegion());
        Assert.assertEquals((Object)"aws4_request", (Object)v4.getAwsRequest());
        Assert.assertEquals((Object)"host;x-amz-content-sha256;x-amz-date", (Object)v4.getSignedHeaderString());
        Assert.assertEquals((Object)"fe5f80f77d5fa3beca038a248ff027", (Object)v4.getSignature());
    }

    @Test
    public void testV4HeaderRegionValidationFailure() throws Exception {
        String auth = "AWS4-HMAC-SHA256 Credential=ozone/" + this.curDate + "//s3/aws4_request,SignedHeaders=host;x-amz-content-sha256;x-amz-date,Signature=fe5f80f77d5fa3beca038a248ff027%";
        LambdaTestUtils.intercept(OS3Exception.class, (String)"", () -> new AuthorizationHeaderV4(auth));
        String auth2 = "AWS4-HMAC-SHA256 Credential=ozone/" + this.curDate + "s3/aws4_request,SignedHeaders=host;x-amz-content-sha256;x-amz-date,Signature=fe5f80f77d5fa3beca038a248ff027%";
        LambdaTestUtils.intercept(OS3Exception.class, (String)"", () -> new AuthorizationHeaderV4(auth2));
    }

    @Test
    public void testV4HeaderServiceValidationFailure() throws Exception {
        String auth = "AWS4-HMAC-SHA256 Credential=ozone/" + this.curDate + "/us-east-1//aws4_request,SignedHeaders=host;x-amz-content-sha256;x-amz-date,Signature=fe5f80f77d5fa3beca038a248ff027";
        LambdaTestUtils.intercept(OS3Exception.class, (String)"", () -> new AuthorizationHeaderV4(auth));
        String auth2 = "AWS4-HMAC-SHA256 Credential=ozone/" + this.curDate + "/us-east-1/aws4_request,SignedHeaders=host;x-amz-content-sha256;x-amz-date,Signature=fe5f80f77d5fa3beca038a248ff027";
        LambdaTestUtils.intercept(OS3Exception.class, (String)"", () -> new AuthorizationHeaderV4(auth2));
    }

    @Test
    public void testV4HeaderRequestValidationFailure() throws Exception {
        String auth = "AWS4-HMAC-SHA256 Credential=ozone/" + this.curDate + "/us-east-1/s3/   ,SignedHeaders=host;x-amz-content-sha256;x-amz-date,Signature=fe5f80f77d5fa3beca038a248ff027";
        LambdaTestUtils.intercept(OS3Exception.class, (String)"", () -> new AuthorizationHeaderV4(auth));
        String auth2 = "AWS4-HMAC-SHA256 Credential=ozone/" + this.curDate + "/us-east-1/s3/,SignedHeaders=host;x-amz-content-sha256;x-amz-date,Signature=fe5f80f77d5fa3beca038a248ff027";
        LambdaTestUtils.intercept(OS3Exception.class, (String)"", () -> new AuthorizationHeaderV4(auth2));
        String auth3 = "AWS4-HMAC-SHA256 Credential=ozone/" + this.curDate + "/us-east-1/s3,SignedHeaders=host;x-amz-content-sha256;x-amz-date,Signature=fe5f80f77d5fa3beca038a248ff027";
        LambdaTestUtils.intercept(OS3Exception.class, (String)"", () -> new AuthorizationHeaderV4(auth3));
    }

    @Test
    public void testV4HeaderSignedHeaderValidationFailure() throws Exception {
        String auth = "AWS4-HMAC-SHA256 Credential=ozone/" + this.curDate + "/us-east-1/s3/aws4_request,SignedHeaders=;;,Signature=fe5f80f77d5fa3beca038a248ff027";
        LambdaTestUtils.intercept(OS3Exception.class, (String)"", () -> new AuthorizationHeaderV4(auth));
        String auth2 = "AWS4-HMAC-SHA256 Credential=ozone/" + this.curDate + "/us-east-1/s3/aws4_request,SignedHeaders=,Signature=fe5f80f77d5fa3beca038a248ff027";
        LambdaTestUtils.intercept(OS3Exception.class, (String)"", () -> new AuthorizationHeaderV4(auth2));
        String auth3 = "AWS4-HMAC-SHA256 Credential=ozone/" + this.curDate + "/us-east-1/s3/aws4_request,=x-amz-content-sha256;x-amz-date,Signature=fe5f80f77d5fa3beca038a248ff027";
        LambdaTestUtils.intercept(OS3Exception.class, (String)"", () -> new AuthorizationHeaderV4(auth3));
        String auth4 = "AWS4-HMAC-SHA256 Credential=ozone/" + this.curDate + "/us-east-1/s3/aws4_request,=,Signature=fe5f80f77d5fa3beca038a248ff027";
        LambdaTestUtils.intercept(OS3Exception.class, (String)"", () -> new AuthorizationHeaderV4(auth4));
    }

    @Test
    public void testV4HeaderSignatureValidationFailure() throws Exception {
        String auth = "AWS4-HMAC-SHA256 Credential=ozone/" + this.curDate + "/us-east-1/s3/aws4_request,SignedHeaders=host;x-amz-content-sha256;x-amz-date,Signature=fe5f80f77d5fa3beca038a248ff027%";
        LambdaTestUtils.intercept(OS3Exception.class, (String)"", () -> new AuthorizationHeaderV4(auth));
        String auth2 = "AWS4-HMAC-SHA256 Credential=ozone/" + this.curDate + "/us-east-1/s3/aws4_request,SignedHeaders=host;x-amz-content-sha256;x-amz-date,Signature=";
        LambdaTestUtils.intercept(OS3Exception.class, (String)"", () -> new AuthorizationHeaderV4(auth2));
        String auth3 = "AWS4-HMAC-SHA256 Credential=ozone/" + this.curDate + "/us-east-1/s3/aws4_request,SignedHeaders=host;x-amz-content-sha256;x-amz-date,=";
        LambdaTestUtils.intercept(OS3Exception.class, (String)"", () -> new AuthorizationHeaderV4(auth3));
    }

    @Test
    public void testV4HeaderHashAlgoValidationFailure() throws Exception {
        String auth = "AWS4-HMAC-SHA Credential=ozone/" + this.curDate + "/us-east-1/s3/aws4_request,SignedHeaders=host;x-amz-content-sha256;x-amz-date,Signature=fe5f80f77d5fa3beca038a248ff027";
        LambdaTestUtils.intercept(OS3Exception.class, (String)"", () -> new AuthorizationHeaderV4(auth));
        String auth2 = "SHA-256 Credential=ozone/" + this.curDate + "/us-east-1/s3/aws4_request,SignedHeaders=host;x-amz-content-sha256;x-amz-date,Signature=fe5f80f77d5fa3beca038a248ff027";
        LambdaTestUtils.intercept(OS3Exception.class, (String)"", () -> new AuthorizationHeaderV4(auth2));
        String auth3 = " Credential=ozone/" + this.curDate + "/us-east-1/s3/aws4_request,SignedHeaders=host;x-amz-content-sha256;x-amz-date,Signature=fe5f80f77d5fa3beca038a248ff027";
        LambdaTestUtils.intercept(OS3Exception.class, (String)"", () -> new AuthorizationHeaderV4(auth3));
    }

    @Test
    public void testV4HeaderCredentialValidationFailure() throws Exception {
        String auth = "AWS4-HMAC-SHA Credential=/" + this.curDate + "///,SignedHeaders=host;x-amz-content-sha256;x-amz-date,Signature=fe5f80f77d5fa3beca038a248ff027";
        LambdaTestUtils.intercept(OS3Exception.class, (String)"", () -> new AuthorizationHeaderV4(auth));
        String auth2 = "AWS4-HMAC-SHA =/" + this.curDate + "///,SignedHeaders=host;x-amz-content-sha256;x-amz-date,Signature=fe5f80f77d5fa3beca038a248ff027";
        LambdaTestUtils.intercept(OS3Exception.class, (String)"", () -> new AuthorizationHeaderV4(auth2));
    }
}

