/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.header;

import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.header.AuthorizationHeaderV2;
import org.junit.Assert;
import org.junit.Test;

public class TestAuthorizationHeaderV2 {
    @Test
    public void testAuthHeaderV2() throws OS3Exception {
        try {
            String auth = "AWS accessKey:signature";
            AuthorizationHeaderV2 v2 = new AuthorizationHeaderV2(auth);
            Assert.assertEquals((Object)v2.getAccessKeyID(), (Object)"accessKey");
            Assert.assertEquals((Object)v2.getSignature(), (Object)"signature");
        }
        catch (OS3Exception ex) {
            Assert.fail((String)"testAuthHeaderV2 failed");
        }
    }

    @Test
    public void testIncorrectHeader1() throws OS3Exception {
        try {
            String auth = "AAA accessKey:signature";
            new AuthorizationHeaderV2(auth);
            Assert.fail((String)"testIncorrectHeader");
        }
        catch (OS3Exception ex) {
            Assert.assertEquals((Object)"AuthorizationHeaderMalformed", (Object)ex.getCode());
        }
    }

    @Test
    public void testIncorrectHeader2() throws OS3Exception {
        try {
            String auth = "AWS :accessKey";
            new AuthorizationHeaderV2(auth);
            Assert.fail((String)"testIncorrectHeader");
        }
        catch (OS3Exception ex) {
            Assert.assertEquals((Object)"AuthorizationHeaderMalformed", (Object)ex.getCode());
        }
    }

    @Test
    public void testIncorrectHeader3() throws OS3Exception {
        try {
            String auth = "AWS :signature";
            new AuthorizationHeaderV2(auth);
            Assert.fail((String)"testIncorrectHeader");
        }
        catch (OS3Exception ex) {
            Assert.assertEquals((Object)"AuthorizationHeaderMalformed", (Object)ex.getCode());
        }
    }

    @Test
    public void testIncorrectHeader4() throws OS3Exception {
        try {
            String auth = "AWS accessKey:";
            new AuthorizationHeaderV2(auth);
            Assert.fail((String)"testIncorrectHeader");
        }
        catch (OS3Exception ex) {
            Assert.assertEquals((Object)"AuthorizationHeaderMalformed", (Object)ex.getCode());
        }
    }
}

