/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.exception;

import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;
import org.apache.hadoop.ozone.web.utils.OzoneUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestOS3Exception {
    @Test
    public void testOS3Exception() {
        OS3Exception ex = new OS3Exception("AccessDenied", "Access Denied", 403);
        String requestId = OzoneUtils.getRequestID();
        ex = S3ErrorTable.newError((OS3Exception)ex, (String)"bucket");
        ex.setRequestId(requestId);
        String val = ex.toXml();
        String formatString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Error>\n  <Code>%s</Code>\n  <Message>%s</Message>\n  <Resource>%s</Resource>\n  <RequestId>%s</RequestId>\n</Error>\n";
        String expected = String.format(formatString, ex.getCode(), ex.getErrorMessage(), ex.getResource(), ex.getRequestId());
        Assert.assertEquals((Object)expected, (Object)val);
    }
}

