/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import org.apache.hadoop.ozone.client.ObjectStore;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientStub;
import org.apache.hadoop.ozone.s3.SignatureProcessor;
import org.apache.hadoop.ozone.s3.endpoint.ListBucketResponse;
import org.apache.hadoop.ozone.s3.endpoint.RootEndpoint;
import org.apache.hadoop.ozone.s3.util.OzoneS3Util;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRootList {
    private OzoneClientStub clientStub;
    private ObjectStore objectStoreStub;
    private RootEndpoint rootEndpoint;
    private String userName = "ozone";

    @Before
    public void setup() throws Exception {
        this.clientStub = new OzoneClientStub();
        this.objectStoreStub = this.clientStub.getObjectStore();
        this.rootEndpoint = new RootEndpoint();
        this.rootEndpoint.setClient((OzoneClient)this.clientStub);
    }

    @Test
    public void testListBucket() throws Exception {
        this.rootEndpoint.setSignatureProcessor(new SignatureProcessor(){

            public String getStringToSign() throws Exception {
                return null;
            }

            public String getSignature() {
                return null;
            }

            public String getAwsAccessId() {
                return "ozone";
            }
        });
        ListBucketResponse response = (ListBucketResponse)this.rootEndpoint.get().getEntity();
        Assert.assertEquals((long)0L, (long)response.getBucketsNum());
        String s3Username = OzoneS3Util.getS3Username((String)this.userName);
        String bucketBaseName = "bucket-" + this.getClass().getName();
        for (int i = 0; i < 10; ++i) {
            this.objectStoreStub.createS3Bucket(s3Username, bucketBaseName + i);
        }
        response = (ListBucketResponse)this.rootEndpoint.get().getEntity();
        Assert.assertEquals((long)10L, (long)response.getBucketsNum());
    }
}

