/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientStub;
import org.apache.hadoop.ozone.s3.endpoint.MultipartUploadInitiateResponse;
import org.apache.hadoop.ozone.s3.endpoint.ObjectEndpoint;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestPartUpload {
    private static final ObjectEndpoint REST = new ObjectEndpoint();

    @BeforeClass
    public static void setUp() throws Exception {
        OzoneClientStub client = new OzoneClientStub();
        client.getObjectStore().createS3Bucket("ozone", "s3Bucket");
        HttpHeaders headers = (HttpHeaders)Mockito.mock(HttpHeaders.class);
        Mockito.when((Object)headers.getHeaderString("x-amz-storage-class")).thenReturn((Object)"STANDARD");
        REST.setHeaders(headers);
        REST.setClient((OzoneClient)client);
    }

    @Test
    public void testPartUpload() throws Exception {
        Response response = REST.initializeMultipartUpload("s3Bucket", "key");
        MultipartUploadInitiateResponse multipartUploadInitiateResponse = (MultipartUploadInitiateResponse)response.getEntity();
        Assert.assertNotNull((Object)multipartUploadInitiateResponse.getUploadID());
        String uploadID = multipartUploadInitiateResponse.getUploadID();
        Assert.assertEquals((long)response.getStatus(), (long)200L);
        String content = "Multipart Upload";
        ByteArrayInputStream body = new ByteArrayInputStream(content.getBytes());
        response = REST.put("s3Bucket", "key", (long)content.length(), 1, uploadID, (InputStream)body);
        Assert.assertNotNull((Object)response.getHeaderString("ETag"));
    }

    @Test
    public void testPartUploadWithOverride() throws Exception {
        Response response = REST.initializeMultipartUpload("s3Bucket", "key");
        MultipartUploadInitiateResponse multipartUploadInitiateResponse = (MultipartUploadInitiateResponse)response.getEntity();
        Assert.assertNotNull((Object)multipartUploadInitiateResponse.getUploadID());
        String uploadID = multipartUploadInitiateResponse.getUploadID();
        Assert.assertEquals((long)response.getStatus(), (long)200L);
        String content = "Multipart Upload";
        ByteArrayInputStream body = new ByteArrayInputStream(content.getBytes());
        response = REST.put("s3Bucket", "key", (long)content.length(), 1, uploadID, (InputStream)body);
        Assert.assertNotNull((Object)response.getHeaderString("ETag"));
        String eTag = response.getHeaderString("ETag");
        content = "Multipart Upload Changed";
        response = REST.put("s3Bucket", "key", (long)content.length(), 1, uploadID, (InputStream)body);
        Assert.assertNotNull((Object)response.getHeaderString("ETag"));
        Assert.assertNotEquals((Object)eTag, (Object)response.getHeaderString("ETag"));
    }

    @Test
    public void testPartUploadWithIncorrectUploadID() throws Exception {
        try {
            String content = "Multipart Upload With Incorrect uploadID";
            ByteArrayInputStream body = new ByteArrayInputStream(content.getBytes());
            REST.put("s3Bucket", "key", (long)content.length(), 1, "random", (InputStream)body);
            Assert.fail((String)"testPartUploadWithIncorrectUploadID failed");
        }
        catch (OS3Exception ex) {
            Assert.assertEquals((Object)"NoSuchUpload", (Object)ex.getCode());
            Assert.assertEquals((long)404L, (long)ex.getHttpCode());
        }
    }
}

