/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.ozone.client.ObjectStore;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientStub;
import org.apache.hadoop.ozone.client.OzoneKeyDetails;
import org.apache.hadoop.ozone.client.io.OzoneInputStream;
import org.apache.hadoop.ozone.s3.endpoint.ObjectEndpoint;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestObjectPut {
    public static final String CONTENT = "0123456789";
    private String userName = "ozone";
    private String bucketName = "b1";
    private String keyName = "key1";
    private String destBucket = "b2";
    private String destkey = "key2";
    private String nonexist = "nonexist";
    private OzoneClientStub clientStub;
    private ObjectStore objectStoreStub;
    private ObjectEndpoint objectEndpoint;

    @Before
    public void setup() throws IOException {
        this.clientStub = new OzoneClientStub();
        this.objectStoreStub = this.clientStub.getObjectStore();
        this.objectStoreStub.createS3Bucket(this.userName, this.bucketName);
        this.objectStoreStub.createS3Bucket("ozone1", this.destBucket);
        this.objectEndpoint = new ObjectEndpoint();
        this.objectEndpoint.setClient((OzoneClient)this.clientStub);
    }

    @Test
    public void testPutObject() throws IOException, OS3Exception {
        HttpHeaders headers = (HttpHeaders)Mockito.mock(HttpHeaders.class);
        ByteArrayInputStream body = new ByteArrayInputStream(CONTENT.getBytes());
        this.objectEndpoint.setHeaders(headers);
        Response response = this.objectEndpoint.put(this.bucketName, this.keyName, (long)CONTENT.length(), 1, null, (InputStream)body);
        String volumeName = this.clientStub.getObjectStore().getOzoneVolumeName(this.bucketName);
        OzoneInputStream ozoneInputStream = this.clientStub.getObjectStore().getVolume(volumeName).getBucket(this.bucketName).readKey(this.keyName);
        String keyContent = IOUtils.toString((InputStream)ozoneInputStream, (Charset)Charset.forName("UTF-8"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)CONTENT, (Object)keyContent);
    }

    @Test
    public void testPutObjectWithSignedChunks() throws IOException, OS3Exception {
        HttpHeaders headers = (HttpHeaders)Mockito.mock(HttpHeaders.class);
        this.objectEndpoint.setHeaders(headers);
        String chunkedContent = "0a;chunk-signature=signature\r\n1234567890\r\n05;chunk-signature=signature\r\nabcde\r\n";
        Mockito.when((Object)headers.getHeaderString("x-amz-content-sha256")).thenReturn((Object)"STREAMING-AWS4-HMAC-SHA256-PAYLOAD");
        Response response = this.objectEndpoint.put(this.bucketName, this.keyName, (long)chunkedContent.length(), 1, null, (InputStream)new ByteArrayInputStream(chunkedContent.getBytes()));
        String volumeName = this.clientStub.getObjectStore().getOzoneVolumeName(this.bucketName);
        OzoneInputStream ozoneInputStream = this.clientStub.getObjectStore().getVolume(volumeName).getBucket(this.bucketName).readKey(this.keyName);
        String keyContent = IOUtils.toString((InputStream)ozoneInputStream, (Charset)Charset.forName("UTF-8"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"1234567890abcde", (Object)keyContent);
    }

    @Test
    public void testCopyObject() throws IOException, OS3Exception {
        HttpHeaders headers = (HttpHeaders)Mockito.mock(HttpHeaders.class);
        ByteArrayInputStream body = new ByteArrayInputStream(CONTENT.getBytes());
        this.objectEndpoint.setHeaders(headers);
        this.keyName = "sourceKey";
        Response response = this.objectEndpoint.put(this.bucketName, this.keyName, (long)CONTENT.length(), 1, null, (InputStream)body);
        String volumeName = this.clientStub.getObjectStore().getOzoneVolumeName(this.bucketName);
        OzoneInputStream ozoneInputStream = this.clientStub.getObjectStore().getVolume(volumeName).getBucket(this.bucketName).readKey(this.keyName);
        String keyContent = IOUtils.toString((InputStream)ozoneInputStream, (Charset)Charset.forName("UTF-8"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)CONTENT, (Object)keyContent);
        Mockito.when((Object)headers.getHeaderString("x-amz-copy-source")).thenReturn((Object)(this.bucketName + "/" + this.keyName));
        response = this.objectEndpoint.put(this.destBucket, this.destkey, (long)CONTENT.length(), 1, null, (InputStream)body);
        volumeName = this.clientStub.getObjectStore().getOzoneVolumeName(this.destBucket);
        ozoneInputStream = this.clientStub.getObjectStore().getVolume(volumeName).getBucket(this.destBucket).readKey(this.destkey);
        keyContent = IOUtils.toString((InputStream)ozoneInputStream, (Charset)Charset.forName("UTF-8"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)CONTENT, (Object)keyContent);
        try {
            this.objectEndpoint.put(this.bucketName, this.keyName, (long)CONTENT.length(), 1, null, (InputStream)body);
            Assert.fail((String)"test copy object failed");
        }
        catch (OS3Exception ex) {
            Assert.assertTrue((boolean)ex.getErrorMessage().contains("This copy request is illegal"));
        }
        try {
            Mockito.when((Object)headers.getHeaderString("x-amz-copy-source")).thenReturn((Object)(this.nonexist + "/" + this.keyName));
            this.objectEndpoint.put(this.destBucket, this.destkey, (long)CONTENT.length(), 1, null, (InputStream)body);
            Assert.fail((String)"test copy object failed");
        }
        catch (OS3Exception ex) {
            Assert.assertTrue((boolean)ex.getCode().contains("NoSuchBucket"));
        }
        try {
            Mockito.when((Object)headers.getHeaderString("x-amz-copy-source")).thenReturn((Object)(this.bucketName + "/" + this.keyName));
            this.objectEndpoint.put(this.nonexist, this.destkey, (long)CONTENT.length(), 1, null, (InputStream)body);
            Assert.fail((String)"test copy object failed");
        }
        catch (OS3Exception ex) {
            Assert.assertTrue((boolean)ex.getCode().contains("NoSuchBucket"));
        }
        try {
            Mockito.when((Object)headers.getHeaderString("x-amz-copy-source")).thenReturn((Object)(this.nonexist + "/" + this.keyName));
            this.objectEndpoint.put(this.nonexist, this.destkey, (long)CONTENT.length(), 1, null, (InputStream)body);
            Assert.fail((String)"test copy object failed");
        }
        catch (OS3Exception ex) {
            Assert.assertTrue((boolean)ex.getCode().contains("NoSuchBucket"));
        }
        try {
            Mockito.when((Object)headers.getHeaderString("x-amz-copy-source")).thenReturn((Object)(this.bucketName + "/" + this.nonexist));
            this.objectEndpoint.put("nonexistent", this.keyName, (long)CONTENT.length(), 1, null, (InputStream)body);
            Assert.fail((String)"test copy object failed");
        }
        catch (OS3Exception ex) {
            Assert.assertTrue((boolean)ex.getCode().contains("NoSuchBucket"));
        }
    }

    @Test
    public void testInvalidStorageType() throws IOException {
        HttpHeaders headers = (HttpHeaders)Mockito.mock(HttpHeaders.class);
        ByteArrayInputStream body = new ByteArrayInputStream(CONTENT.getBytes());
        this.objectEndpoint.setHeaders(headers);
        this.keyName = "sourceKey";
        Mockito.when((Object)headers.getHeaderString("x-amz-storage-class")).thenReturn((Object)"random");
        try {
            Response response = this.objectEndpoint.put(this.bucketName, this.keyName, (long)CONTENT.length(), 1, null, (InputStream)body);
            Assert.fail((String)"testInvalidStorageType");
        }
        catch (OS3Exception ex) {
            Assert.assertEquals((Object)S3ErrorTable.INVALID_ARGUMENT.getErrorMessage(), (Object)ex.getErrorMessage());
            Assert.assertEquals((Object)"random", (Object)ex.getResource());
        }
    }

    @Test
    public void testEmptyStorageType() throws IOException, OS3Exception {
        HttpHeaders headers = (HttpHeaders)Mockito.mock(HttpHeaders.class);
        ByteArrayInputStream body = new ByteArrayInputStream(CONTENT.getBytes());
        this.objectEndpoint.setHeaders(headers);
        this.keyName = "sourceKey";
        Mockito.when((Object)headers.getHeaderString("x-amz-storage-class")).thenReturn((Object)"");
        Response response = this.objectEndpoint.put(this.bucketName, this.keyName, (long)CONTENT.length(), 1, null, (InputStream)body);
        String volumeName = this.clientStub.getObjectStore().getOzoneVolumeName(this.bucketName);
        OzoneKeyDetails key = this.clientStub.getObjectStore().getVolume(volumeName).getBucket(this.bucketName).getKey(this.keyName);
        Assert.assertEquals((Object)ReplicationType.RATIS, (Object)key.getReplicationType());
    }
}

