/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientStub;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.s3.endpoint.BucketEndpoint;
import org.apache.hadoop.ozone.s3.endpoint.MultiDeleteRequest;
import org.apache.hadoop.ozone.s3.endpoint.MultiDeleteResponse;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.junit.Assert;
import org.junit.Test;

public class TestObjectMultiDelete {
    @Test
    public void delete() throws IOException, OS3Exception, JAXBException {
        OzoneClientStub client = new OzoneClientStub();
        OzoneBucket bucket = this.initTestData(client);
        BucketEndpoint rest = new BucketEndpoint();
        rest.setClient((OzoneClient)client);
        MultiDeleteRequest mdr = new MultiDeleteRequest();
        mdr.getObjects().add(new MultiDeleteRequest.DeleteObject("key1"));
        mdr.getObjects().add(new MultiDeleteRequest.DeleteObject("key2"));
        mdr.getObjects().add(new MultiDeleteRequest.DeleteObject("key4"));
        MultiDeleteResponse response = rest.multiDelete("b1", "", mdr);
        Set keysAtTheEnd = Sets.newHashSet((Iterator)bucket.listKeys("")).stream().map(OzoneKey::getName).collect(Collectors.toSet());
        HashSet<String> expectedResult = new HashSet<String>();
        expectedResult.add("key3");
        Assert.assertEquals(expectedResult, keysAtTheEnd);
        Assert.assertEquals((long)3L, (long)response.getDeletedObjects().size());
        Assert.assertEquals((long)0L, (long)response.getErrors().size());
    }

    @Test
    public void deleteQuiet() throws IOException, OS3Exception, JAXBException {
        OzoneClientStub client = new OzoneClientStub();
        OzoneBucket bucket = this.initTestData(client);
        BucketEndpoint rest = new BucketEndpoint();
        rest.setClient((OzoneClient)client);
        MultiDeleteRequest mdr = new MultiDeleteRequest();
        mdr.setQuiet(true);
        mdr.getObjects().add(new MultiDeleteRequest.DeleteObject("key1"));
        mdr.getObjects().add(new MultiDeleteRequest.DeleteObject("key2"));
        mdr.getObjects().add(new MultiDeleteRequest.DeleteObject("key4"));
        MultiDeleteResponse response = rest.multiDelete("b1", "", mdr);
        Set keysAtTheEnd = Sets.newHashSet((Iterator)bucket.listKeys("")).stream().map(OzoneKey::getName).collect(Collectors.toSet());
        Assert.assertEquals((long)0L, (long)response.getDeletedObjects().size());
        Assert.assertEquals((long)0L, (long)response.getErrors().size());
    }

    private OzoneBucket initTestData(OzoneClient client) throws IOException {
        client.getObjectStore().createS3Bucket("bilbo", "b1");
        String volumeName = client.getObjectStore().getOzoneVolumeName("b1");
        OzoneBucket bucket = client.getObjectStore().getVolume(volumeName).getBucket("b1");
        bucket.createKey("key1", 0L).close();
        bucket.createKey("key2", 0L).close();
        bucket.createKey("key3", 0L).close();
        return bucket;
    }
}

