/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.ozone.client.ObjectStore;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientStub;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.s3.endpoint.ObjectEndpoint;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestObjectHead {
    private String bucketName = "b1";
    private OzoneClientStub clientStub;
    private ObjectStore objectStoreStub;
    private ObjectEndpoint keyEndpoint;
    private OzoneBucket bucket;

    @Before
    public void setup() throws IOException {
        this.clientStub = new OzoneClientStub();
        this.objectStoreStub = this.clientStub.getObjectStore();
        this.objectStoreStub.createS3Bucket("bilbo", this.bucketName);
        String volName = this.objectStoreStub.getOzoneVolumeName(this.bucketName);
        this.bucket = this.objectStoreStub.getVolume(volName).getBucket(this.bucketName);
        this.keyEndpoint = new ObjectEndpoint();
        this.keyEndpoint.setClient((OzoneClient)this.clientStub);
    }

    @Test
    public void testHeadObject() throws Exception {
        String value = RandomStringUtils.randomAlphanumeric((int)32);
        OzoneOutputStream out = this.bucket.createKey("key1", (long)value.getBytes(StandardCharsets.UTF_8).length, ReplicationType.STAND_ALONE, ReplicationFactor.ONE, new HashMap());
        out.write(value.getBytes(StandardCharsets.UTF_8));
        out.close();
        Response response = this.keyEndpoint.head(this.bucketName, "key1");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((long)value.getBytes(StandardCharsets.UTF_8).length, (long)Long.parseLong(response.getHeaderString("Content-Length")));
        DateTimeFormatter.RFC_1123_DATE_TIME.parse(response.getHeaderString("Last-Modified"));
    }

    @Test
    public void testHeadFailByBadName() throws Exception {
        try {
            Response response = this.keyEndpoint.head(this.bucketName, "badKeyName");
            Assert.assertEquals((long)404L, (long)response.getStatus());
        }
        catch (OS3Exception ex) {
            Assert.assertTrue((boolean)ex.getCode().contains("NoSuchObject"));
            Assert.assertTrue((boolean)ex.getErrorMessage().contains("object does not exist"));
            Assert.assertEquals((long)404L, (long)ex.getHttpCode());
        }
    }
}

